/*
 * Decompiled with CFR 0.152.
 */
package jn.willfrydev.ghostblocked;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import jn.willfrydev.ghostblocked.GhostBlocked;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.StringUtil;

public class GhostBlockerCommand
implements CommandExecutor,
TabCompleter {
    private final GhostBlocked plugin;
    private static final String PREFIX = String.valueOf(ChatColor.DARK_AQUA) + "[xBlocked] " + String.valueOf(ChatColor.RESET);

    public GhostBlockerCommand(GhostBlocked plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        String sub;
        if (args.length == 0) {
            this.sendHelp(sender, label);
            return true;
        }
        switch (sub = args[0].toLowerCase()) {
            case "reload": {
                if (!sender.hasPermission("xblocked.reload")) {
                    sender.sendMessage(PREFIX + String.valueOf(ChatColor.RED) + "No tienes permiso para ejecutar este comando.");
                    return true;
                }
                this.plugin.applyConfigReload();
                sender.sendMessage(PREFIX + String.valueOf(ChatColor.GREEN) + "Configuraci\u00f3n recargada.");
                if (!this.plugin.isProtocolLibAvailable()) {
                    sender.sendMessage(PREFIX + String.valueOf(ChatColor.RED) + "Aviso: ProtocolLib no est\u00e1 instalado/activo. Listeners deshabilitados (modo degradado).");
                }
                return true;
            }
            case "help": 
            case "?": {
                this.sendHelp(sender, label);
                return true;
            }
            case "version": {
                sender.sendMessage(PREFIX + "Versi\u00f3n: " + String.valueOf(ChatColor.GOLD) + this.plugin.getDescription().getVersion());
                if (!this.plugin.isProtocolLibAvailable()) {
                    sender.sendMessage(PREFIX + String.valueOf(ChatColor.RED) + "Modo degradado: instala ProtocolLib para habilitar los listeners.");
                }
                return true;
            }
            case "diag": {
                this.doDiag(sender);
                return true;
            }
        }
        this.sendHelp(sender, label);
        return true;
    }

    private void sendHelp(CommandSender sender, String label) {
        String v = this.plugin.getDescription().getVersion();
        sender.sendMessage(String.valueOf(ChatColor.GRAY) + "---------------- " + String.valueOf(ChatColor.DARK_AQUA) + "xBlocked " + String.valueOf(ChatColor.GRAY) + "(" + v + ") ----------------");
        sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "/" + label + String.valueOf(ChatColor.WHITE) + " - Muestra esta ayuda.");
        sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "/" + label + " reload" + String.valueOf(ChatColor.WHITE) + " - Recarga la configuraci\u00f3n.");
        sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "/" + label + " version" + String.valueOf(ChatColor.WHITE) + " - Muestra la versi\u00f3n del plugin.");
        sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "/" + label + " diag" + String.valueOf(ChatColor.WHITE) + " - Diagn\u00f3stico r\u00e1pido (ProtocolLib/valores de config).");
        if (!this.plugin.isProtocolLibAvailable()) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "Aviso: ProtocolLib NO est\u00e1 instalado/activo. Funcionando en modo degradado (solo comandos).");
        }
        sender.sendMessage(String.valueOf(ChatColor.GRAY) + "----------------------------------------------");
    }

    private void doDiag(CommandSender sender) {
        sender.sendMessage(PREFIX + "Diagn\u00f3stico:");
        sender.sendMessage(String.valueOf(ChatColor.GRAY) + "  Servidor: " + String.valueOf(ChatColor.WHITE) + this.plugin.getServer().getName() + " " + this.plugin.getServer().getBukkitVersion());
        sender.sendMessage(String.valueOf(ChatColor.GRAY) + "  xBlocked: " + String.valueOf(ChatColor.WHITE) + this.plugin.getDescription().getVersion());
        Plugin plib = this.plugin.getServer().getPluginManager().getPlugin("ProtocolLib");
        String plibState = plib != null && plib.isEnabled() ? plib.getDescription().getVersion() + " (activo)" : "NO instalado o inactivo";
        sender.sendMessage(String.valueOf(ChatColor.GRAY) + "  ProtocolLib: " + String.valueOf(ChatColor.WHITE) + plibState);
        int minProto = this.plugin.getConfig().getInt("min-protocol", 735);
        long ttl = this.plugin.getConfig().getLong("cache-ttl-seconds", 45L);
        int soft = Math.max(100, this.plugin.getConfig().getInt("cache-soft-limit", 1000));
        boolean motdEnabled = this.plugin.getConfig().getBoolean("motd.enabled", false);
        sender.sendMessage(String.valueOf(ChatColor.GRAY) + "  min-protocol: " + String.valueOf(ChatColor.WHITE) + minProto);
        sender.sendMessage(String.valueOf(ChatColor.GRAY) + "  cache-ttl-seconds: " + String.valueOf(ChatColor.WHITE) + ttl);
        sender.sendMessage(String.valueOf(ChatColor.GRAY) + "  cache-soft-limit: " + String.valueOf(ChatColor.WHITE) + soft);
        sender.sendMessage(String.valueOf(ChatColor.GRAY) + "  motd.enabled: " + String.valueOf(ChatColor.WHITE) + motdEnabled);
    }

    public List<String> onTabComplete(CommandSender sender, Command cmd, String alias, String[] args) {
        if (args.length == 1) {
            ArrayList<String> base = new ArrayList<String>();
            base.add("help");
            base.add("version");
            base.add("diag");
            if (sender.hasPermission("xblocked.reload")) {
                base.add("reload");
            }
            ArrayList<String> completions = new ArrayList<String>();
            StringUtil.copyPartialMatches((String)args[0], base, completions);
            Collections.sort(completions);
            return completions;
        }
        return Collections.emptyList();
    }
}

