/*
 * Decompiled with CFR 0.152.
 */
package jn.willfrydev.ghostblocked;

import java.io.File;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.plugin.java.JavaPlugin;

public final class I18nManager {
    private final JavaPlugin plugin;
    private final Map<String, YamlConfiguration> bundles = new HashMap<String, YamlConfiguration>();
    private final boolean enabled;
    private final String defaultLang;
    private final Mode mode;
    private final String fixedLang;
    private final Map<String, String> localeMap;
    private final String pingLang;

    public I18nManager(JavaPlugin plugin) {
        this.plugin = plugin;
        this.enabled = plugin.getConfig().getBoolean("i18n.enabled", true);
        this.defaultLang = plugin.getConfig().getString("i18n.default-lang", "es_ES");
        this.mode = Mode.valueOf(plugin.getConfig().getString("i18n.mode", "PLAYER_LOCALE_THEN_DEFAULT").toUpperCase(Locale.ROOT));
        this.fixedLang = plugin.getConfig().getString("i18n.fixed-lang", this.defaultLang);
        this.pingLang = plugin.getConfig().getString("i18n.ping-lang", this.defaultLang);
        Map rawMap = plugin.getConfig().getConfigurationSection("i18n.locale-map") != null ? plugin.getConfig().getConfigurationSection("i18n.locale-map").getValues(false) : Collections.emptyMap();
        HashMap<String, String> tmp = new HashMap<String, String>();
        rawMap.forEach((k, v) -> tmp.put(k.toLowerCase(Locale.ROOT), String.valueOf(v)));
        this.localeMap = tmp;
        this.loadBundles();
    }

    public boolean enabled() {
        return this.enabled;
    }

    public String defaultLang() {
        return this.defaultLang;
    }

    public String pingLang() {
        return this.pingLang != null ? this.pingLang : this.defaultLang;
    }

    public void reload() {
        this.loadBundles();
    }

    private void loadBundles() {
        File dir = new File(this.plugin.getDataFolder(), "messages");
        if (!dir.exists() && !dir.mkdirs()) {
            this.plugin.getLogger().warning("[i18n] No se pudo crear el directorio: " + String.valueOf(dir));
        }
        this.copyIfAbsent("messages/es_ES.yml");
        this.copyIfAbsent("messages/en_US.yml");
        this.bundles.clear();
        File[] files = dir.listFiles((d, n) -> n.endsWith(".yml"));
        if (files == null || files.length == 0) {
            this.plugin.getLogger().warning("[Lang] No se encontraron bundles en " + dir.getAbsolutePath());
            return;
        }
        for (File f : files) {
            YamlConfiguration yml = YamlConfiguration.loadConfiguration((File)f);
            String key = f.getName().substring(0, f.getName().length() - 4);
            this.bundles.put(key, yml);
        }
        this.plugin.getLogger().info("[Lang] Cargados idiomas: " + String.join((CharSequence)", ", this.bundles.keySet()));
    }

    private void copyIfAbsent(String resourcePath) {
        try {
            File out = new File(this.plugin.getDataFolder(), resourcePath);
            if (out.exists()) {
                return;
            }
            if (!out.getParentFile().exists()) {
                out.getParentFile().mkdirs();
            }
            try (InputStream in = this.plugin.getResource(resourcePath);){
                if (in == null) {
                    return;
                }
                Files.copy(in, out.toPath(), new CopyOption[0]);
            }
        }
        catch (Exception e) {
            this.plugin.getLogger().warning("[Lang] Error copiando " + resourcePath + ": " + e.getMessage());
        }
    }

    public String resolve(Player p) {
        if (!this.enabled) {
            return this.defaultLang;
        }
        if (this.mode == Mode.FIXED) {
            return this.bundles.containsKey(this.fixedLang) ? this.fixedLang : this.defaultLang;
        }
        String tag = this.safeLocaleTag(p);
        String mapped = this.mapLocale(tag);
        if (this.bundles.containsKey(mapped)) {
            return mapped;
        }
        String base = this.baseLang(mapped);
        for (String b : this.bundles.keySet()) {
            String low = b.toLowerCase(Locale.ROOT);
            if (!low.equals(base) && !low.startsWith(base + "_")) continue;
            return b;
        }
        return this.defaultLang;
    }

    public String raw(Player p, String path) {
        String lang = this.resolve(p);
        return this.raw(lang, path);
    }

    public String raw(String lang, String path) {
        YamlConfiguration y = this.bundles.getOrDefault(lang, this.bundles.get(this.defaultLang));
        return y != null ? y.getString(path, path) : path;
    }

    private String safeLocaleTag(Player p) {
        try {
            Locale l = p.locale();
            return l.toLanguageTag().replace('-', '_');
        }
        catch (Throwable ignored) {
            try {
                return p.getLocale().replace('-', '_');
            }
            catch (Throwable t) {
                return this.defaultLang;
            }
        }
    }

    private String mapLocale(String tag) {
        String low = tag.toLowerCase(Locale.ROOT);
        if (this.localeMap.containsKey(low)) {
            return this.localeMap.get(low);
        }
        String base = this.baseLang(low);
        if (this.localeMap.containsKey(base)) {
            return this.localeMap.get(base);
        }
        return tag;
    }

    private String baseLang(String tag) {
        int i = tag.indexOf(95);
        return i > 0 ? tag.substring(0, i) : tag;
    }

    public static enum Mode {
        PLAYER_LOCALE_THEN_DEFAULT,
        FIXED;

    }
}

