/*
 * Decompiled with CFR 0.152.
 */
package jn.willfrydev.ghostblocked;

import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import jn.willfrydev.ghostblocked.GhostBlocked;
import jn.willfrydev.ghostblocked.libs.net.kyori.adventure.text.Component;
import jn.willfrydev.ghostblocked.libs.net.kyori.adventure.text.TextComponent;
import jn.willfrydev.ghostblocked.libs.net.kyori.adventure.text.event.ClickEvent;
import jn.willfrydev.ghostblocked.libs.net.kyori.adventure.text.format.NamedTextColor;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public final class UpdateChecker {
    private final GhostBlocked plugin;
    private final HttpClient http;
    private final String project;
    private final boolean notifyConsole;
    private final boolean notifyAdmins;
    private final String perm;
    private volatile String lastLatest;
    private static final String MODRINTH_VERSIONS = "https://api.modrinth.com/v2/project/%s/version";
    private static final String MODRINTH_PAGE = "https://modrinth.com/plugin/%s";

    public UpdateChecker(GhostBlocked plugin) {
        this.plugin = plugin;
        this.http = HttpClient.newBuilder().connectTimeout(Duration.ofSeconds(6L)).build();
        this.project = plugin.getConfig().getString("updates.modrinth.project", "xblocker");
        this.notifyConsole = plugin.getConfig().getBoolean("updates.modrinth.notify.console", true);
        this.notifyAdmins = plugin.getConfig().getBoolean("updates.modrinth.notify.admins-on-join", true);
        this.perm = plugin.getConfig().getString("updates.modrinth.notify.permission", "xblocker.update");
    }

    public void runCheckAsync() {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
            try {
                String url = String.format(MODRINTH_VERSIONS, this.project);
                HttpRequest req = HttpRequest.newBuilder(URI.create(url)).header("User-Agent", "xBlocked-UpdateChecker").timeout(Duration.ofSeconds(10L)).GET().build();
                HttpResponse<String> res = this.http.send(req, HttpResponse.BodyHandlers.ofString());
                if (res.statusCode() != 200) {
                    this.plugin.getLogger().warning("[Update] Modrinth respondi\u00f3 " + res.statusCode());
                    return;
                }
                String body = res.body();
                String latest = this.extractFirstVersionNumber(body);
                if (latest == null || latest.isEmpty()) {
                    this.plugin.getLogger().warning("[Update] No pude leer 'version_number' en la respuesta.");
                    return;
                }
                String current = this.plugin.getDescription().getVersion();
                if (this.isNewer(latest, current)) {
                    if (latest.equals(this.lastLatest)) {
                        return;
                    }
                    this.lastLatest = latest;
                    this.notifyUpdate(latest, current);
                } else if (this.notifyConsole) {
                    this.plugin.getLogger().info("[Update] Est\u00e1s en la \u00faltima versi\u00f3n (" + current + ").");
                }
            }
            catch (Exception e) {
                this.plugin.getLogger().warning("[Update] Error comprobando Modrinth: " + e.getMessage());
            }
        });
    }

    private void notifyUpdate(String latest, String current) {
        String page = String.format(MODRINTH_PAGE, this.project);
        if (this.notifyConsole) {
            this.plugin.getLogger().warning("[xBlocked] \u00a1Nueva versi\u00f3n disponible en Modrinth! Actual: " + current + " | Nueva: " + latest + " -> " + page);
        }
        if (this.notifyAdmins) {
            Component msg = ((TextComponent)((TextComponent)Component.text("xBlocked: Nueva versi\u00f3n disponible ").color(NamedTextColor.YELLOW)).append((Component)Component.text("(Actual: " + current + " | Nueva: " + latest + ") ").color(NamedTextColor.GRAY))).append(((TextComponent)Component.text("[Abrir Modrinth]").color(NamedTextColor.GREEN)).clickEvent(ClickEvent.openUrl(page)));
            Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> {
                for (Player p : Bukkit.getOnlinePlayers()) {
                    if (this.perm == null || this.perm.isEmpty()) {
                        if (!p.isOp()) continue;
                        p.sendMessage(msg);
                        continue;
                    }
                    if (!p.hasPermission(this.perm)) continue;
                    p.sendMessage(msg);
                }
            });
        }
    }

    public void notifyIfOutdated(Player p) {
        if (this.lastLatest == null) {
            return;
        }
        String current = this.plugin.getDescription().getVersion();
        if (this.isNewer(this.lastLatest, current)) {
            String page = String.format(MODRINTH_PAGE, this.project);
            Component msg = ((TextComponent)((TextComponent)Component.text("xBlocked: Nueva versi\u00f3n disponible ").color(NamedTextColor.YELLOW)).append((Component)Component.text("(Actual: " + current + " | Nueva: " + this.lastLatest + ") ").color(NamedTextColor.GRAY))).append(((TextComponent)Component.text("[Abrir Modrinth]").color(NamedTextColor.GREEN)).clickEvent(ClickEvent.openUrl(page)));
            if (this.perm == null || this.perm.isEmpty()) {
                if (p.isOp()) {
                    p.sendMessage(msg);
                }
            } else if (p.hasPermission(this.perm)) {
                p.sendMessage(msg);
            }
        }
    }

    private String extractFirstVersionNumber(String jsonArray) {
        int i = jsonArray.indexOf("\"version_number\"");
        if (i < 0) {
            return null;
        }
        int c = jsonArray.indexOf(58, i);
        if (c < 0) {
            return null;
        }
        int q1 = jsonArray.indexOf(34, c + 1);
        if (q1 < 0) {
            return null;
        }
        int q2 = jsonArray.indexOf(34, q1 + 1);
        if (q2 < 0) {
            return null;
        }
        return jsonArray.substring(q1 + 1, q2).trim();
    }

    private boolean isNewer(String latest, String current) {
        try {
            String[] L = latest.split("\\.");
            String[] C = current.split("\\.");
            for (int i = 0; i < Math.max(L.length, C.length); ++i) {
                int c;
                int l = i < L.length ? this.parseIntSafe(L[i]) : 0;
                int n = c = i < C.length ? this.parseIntSafe(C[i]) : 0;
                if (l > c) {
                    return true;
                }
                if (l >= c) continue;
                return false;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    private int parseIntSafe(String s) {
        String digits = s.replaceAll("[^0-9]", "");
        if (digits.isEmpty()) {
            return 0;
        }
        return Integer.parseInt(digits);
    }
}

