/*
 * Decompiled with CFR 0.152.
 */
package jn.willfrydev.ghostblocked;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.ProtocolLibrary;
import com.comphenix.protocol.ProtocolManager;
import com.comphenix.protocol.events.ListenerPriority;
import com.comphenix.protocol.events.PacketAdapter;
import com.comphenix.protocol.events.PacketEvent;
import com.comphenix.protocol.events.PacketListener;
import com.comphenix.protocol.wrappers.WrappedChatComponent;
import com.comphenix.protocol.wrappers.WrappedServerPing;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jn.willfrydev.ghostblocked.GhostBlocked;
import jn.willfrydev.ghostblocked.libs.net.kyori.adventure.text.Component;
import jn.willfrydev.ghostblocked.libs.net.kyori.adventure.text.minimessage.MiniMessage;
import jn.willfrydev.ghostblocked.libs.net.kyori.adventure.text.serializer.gson.GsonComponentSerializer;
import jn.willfrydev.ghostblocked.libs.net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import org.bukkit.ChatColor;
import org.bukkit.plugin.Plugin;

public class VersionCheckListener {
    private final GhostBlocked plugin;
    private final ProtocolManager protocolManager;
    private volatile int minProtocol;
    private volatile String incompatibleMessage;
    private volatile long cacheTtlMillis;
    private volatile int cacheSoftLimit;
    private volatile boolean debug;
    private volatile boolean debugForceIncompatible;
    private volatile boolean motdEnabled;
    private volatile String motdLine1;
    private volatile String motdLine2;
    private volatile boolean motdCenter;
    private volatile int motdCenterWidth;
    private volatile String motdFormat;
    private volatile boolean disconnectEnabled;
    private volatile boolean disconnectOnlyOnMismatch;
    private volatile String disconnectFormat;
    private volatile String disconnectMessage;
    private static final Pattern HEX_PATTERN = Pattern.compile("(?i)#[0-9A-F]{6}");
    private static final Pattern OUTDATED_HINT = Pattern.compile("(?i)outdated|newer|older|version|multiplayer.*disconnect");
    private final Map<InetAddress, Entry> clientProtocols = new ConcurrentHashMap<InetAddress, Entry>();

    public VersionCheckListener(GhostBlocked plugin) {
        this.plugin = plugin;
        this.protocolManager = ProtocolLibrary.getProtocolManager();
        this.loadFromConfig();
        this.registerPacketListeners();
    }

    private void loadFromConfig() {
        this.minProtocol = this.plugin.getConfig().getInt("min-protocol", 735);
        this.cacheTtlMillis = this.plugin.getConfig().getLong("cache-ttl-seconds", 45L) * 1000L;
        this.cacheSoftLimit = Math.max(100, this.plugin.getConfig().getInt("cache-soft-limit", 1000));
        this.debug = this.plugin.getConfig().getBoolean("debug", false);
        this.debugForceIncompatible = this.plugin.getConfig().getBoolean("debug-force-incompatible", false);
        this.motdEnabled = this.plugin.getConfig().getBoolean("motd.enabled", false);
        this.motdCenter = this.plugin.getConfig().getBoolean("motd.center", false);
        this.motdCenterWidth = Math.max(10, this.plugin.getConfig().getInt("motd.center-width", 50));
        this.motdFormat = this.plugin.getConfig().getString("motd.format", "auto");
        this.disconnectEnabled = this.plugin.getConfig().getBoolean("disconnect.enabled", true);
        this.disconnectOnlyOnMismatch = this.plugin.getConfig().getBoolean("disconnect.only-on-version-mismatch", true);
        this.disconnectFormat = this.plugin.getConfig().getString("disconnect.format", "auto");
        if (this.plugin.i18n().enabled()) {
            String langPing = this.plugin.i18n().pingLang();
            this.motdLine1 = this.plugin.i18n().raw(langPing, "motd.line1");
            this.motdLine2 = this.plugin.i18n().raw(langPing, "motd.line2");
            this.incompatibleMessage = this.plugin.i18n().raw(langPing, "serverlist.incompatible");
            this.disconnectMessage = this.plugin.i18n().raw(langPing, "disconnect.incompatible");
        } else {
            this.motdLine1 = this.plugin.getConfig().getString("motd.line1", "&aMi Servidor");
            this.motdLine2 = this.plugin.getConfig().getString("motd.line2", "&7Bienvenido");
            this.incompatibleMessage = this.plugin.getConfig().getString("incompatible-message", "&cVersi\u00f3n incompatible. Usa %server_version% o superior.");
            this.disconnectMessage = this.plugin.getConfig().getString("disconnect.message", "<red>\u2716 Tu cliente/servidor no coincide.</red> <gray>Usa</gray> <white>%server_version%</white>");
        }
    }

    public void reloadFromConfig() {
        this.loadFromConfig();
        this.plugin.getLogger().info("[xBlocker] Config (y i18n) recargados en el listener.");
    }

    private void registerPacketListeners() {
        final GhostBlocked gb = this.plugin;
        this.protocolManager.addPacketListener((PacketListener)new PacketAdapter((Plugin)gb, ListenerPriority.HIGHEST, new PacketType[]{PacketType.Handshake.Client.SET_PROTOCOL}){

            public void onPacketReceiving(PacketEvent event) {
                try {
                    int clientProto = (Integer)event.getPacket().getIntegers().read(0);
                    SocketAddress sa = VersionCheckListener.this.getRemoteAddress(event);
                    if (sa instanceof InetSocketAddress) {
                        InetSocketAddress isa = (InetSocketAddress)sa;
                        VersionCheckListener.this.clientProtocols.put(isa.getAddress(), new Entry(clientProto, System.currentTimeMillis()));
                        if (VersionCheckListener.this.debug) {
                            gb.getLogger().info("[GB] HS proto=" + clientProto + " ip=" + isa.getAddress().getHostAddress());
                        }
                        VersionCheckListener.this.prune(false);
                    } else if (VersionCheckListener.this.debug) {
                        gb.getLogger().info("[GB] HS sin direcci\u00f3n remota.");
                    }
                }
                catch (Throwable t) {
                    gb.getLogger().log(Level.WARNING, "No se pudo leer el protocolo del handshake: " + t.getMessage());
                }
            }
        });
        this.protocolManager.addPacketListener((PacketListener)new PacketAdapter((Plugin)gb, ListenerPriority.MONITOR, new PacketType[]{PacketType.Status.Server.SERVER_INFO}){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onPacketSending(PacketEvent event) {
                try {
                    InetAddress inetAddress;
                    WrappedServerPing ping = (WrappedServerPing)event.getPacket().getServerPings().read(0);
                    if (VersionCheckListener.this.motdEnabled) {
                        String l2;
                        String l1 = VersionCheckListener.this.renderText(VersionCheckListener.this.motdLine1, VersionCheckListener.this.motdFormat);
                        String string = l2 = VersionCheckListener.this.motdLine2 != null && !VersionCheckListener.this.motdLine2.isEmpty() ? VersionCheckListener.this.renderText(VersionCheckListener.this.motdLine2, VersionCheckListener.this.motdFormat) : null;
                        if (VersionCheckListener.this.motdCenter) {
                            l1 = VersionCheckListener.this.centerColored(l1, VersionCheckListener.this.motdCenterWidth);
                            if (l2 != null) {
                                l2 = VersionCheckListener.this.centerColored(l2, VersionCheckListener.this.motdCenterWidth);
                            }
                        }
                        String motd = l2 != null && !l2.isEmpty() ? l1 + "\n" + l2 : l1;
                        ping.setMotD(motd);
                    }
                    int serverProto = ping.getVersionProtocol();
                    SocketAddress sa = VersionCheckListener.this.getRemoteAddress(event);
                    if (sa instanceof InetSocketAddress) {
                        InetSocketAddress isa = (InetSocketAddress)sa;
                        inetAddress = isa.getAddress();
                    } else {
                        inetAddress = null;
                    }
                    InetAddress addr = inetAddress;
                    Integer clientProto = addr != null ? VersionCheckListener.this.getClientProtocol(addr) : null;
                    boolean incompatible = VersionCheckListener.this.debugForceIncompatible;
                    if (!incompatible && clientProto != null) {
                        boolean bl = incompatible = clientProto < VersionCheckListener.this.minProtocol || clientProto != serverProto;
                    }
                    if (incompatible) {
                        String langPing = gb.i18n().enabled() ? gb.i18n().pingLang() : null;
                        String baseRaw = gb.i18n().enabled() ? gb.i18n().raw(langPing, "serverlist.incompatible") : VersionCheckListener.this.incompatibleMessage;
                        String rendered = VersionCheckListener.this.renderText(baseRaw.replace("%server_version%", gb.getServer().getVersion()), VersionCheckListener.this.motdFormat);
                        ping.setVersionName(rendered);
                        ping.setVersionProtocol(-1);
                        if (VersionCheckListener.this.debug) {
                            gb.getLogger().info("[GB] PING override -> '" + rendered + "'");
                        }
                    } else if (VersionCheckListener.this.debug) {
                        gb.getLogger().info("[GB] PING sin cambios (clientProto=" + clientProto + ", serverProto=" + serverProto + ")");
                    }
                    event.getPacket().getServerPings().write(0, (Object)ping);
                }
                catch (Exception e) {
                    gb.getLogger().log(Level.WARNING, "Error al procesar el ping del servidor: " + e.getMessage());
                }
                finally {
                    VersionCheckListener.this.prune(true);
                }
            }
        });
        this.protocolManager.addPacketListener((PacketListener)new PacketAdapter((Plugin)gb, ListenerPriority.MONITOR, new PacketType[]{PacketType.Login.Server.DISCONNECT}){

            public void onPacketSending(PacketEvent event) {
                if (!VersionCheckListener.this.disconnectEnabled) {
                    return;
                }
                try {
                    Object json;
                    boolean looksOutdated;
                    WrappedChatComponent original = (WrappedChatComponent)event.getPacket().getChatComponents().read(0);
                    String oldJson = original != null ? original.getJson() : "";
                    boolean bl = looksOutdated = oldJson != null && OUTDATED_HINT.matcher(oldJson).find();
                    if (VersionCheckListener.this.disconnectOnlyOnMismatch && !looksOutdated && !VersionCheckListener.this.debugForceIncompatible) {
                        return;
                    }
                    String baseRaw = gb.i18n().enabled() && event.getPlayer() != null ? gb.i18n().raw(event.getPlayer(), "disconnect.incompatible") : VersionCheckListener.this.disconnectMessage;
                    String raw = baseRaw.replace("%server_version%", gb.getServer().getVersion());
                    Component comp = VersionCheckListener.this.parseComponent(raw, VersionCheckListener.this.disconnectFormat);
                    try {
                        json = (String)GsonComponentSerializer.gson().serialize(comp);
                    }
                    catch (Exception | NoClassDefFoundError ex) {
                        gb.getLogger().warning("[GhostBlocker] Gson serializer no disponible; usando fallback de texto plano.");
                        String plain = ChatColor.stripColor((String)VersionCheckListener.this.renderText(raw, VersionCheckListener.this.disconnectFormat)).replace("\\", "\\\\").replace("\"", "\\\"");
                        json = "{\"text\":\"" + plain + "\"}";
                    }
                    event.getPacket().getChatComponents().write(0, (Object)WrappedChatComponent.fromJson((String)json));
                    if (VersionCheckListener.this.debug) {
                        gb.getLogger().info("[GB] LOGIN.DISCONNECT override -> " + raw);
                    }
                }
                catch (Throwable t) {
                    gb.getLogger().log(Level.WARNING, "No se pudo modificar el mensaje de desconexi\u00f3n: " + t.getMessage());
                }
            }
        });
    }

    private SocketAddress getRemoteAddress(PacketEvent event) {
        try {
            Method m = event.getClass().getMethod("getClientAddress", new Class[0]);
            Object o = m.invoke((Object)event, new Object[0]);
            if (o instanceof SocketAddress) {
                return (SocketAddress)o;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            return event.getPlayer() != null ? event.getPlayer().getAddress() : null;
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    private Integer getClientProtocol(InetAddress addr) {
        Entry e = this.clientProtocols.get(addr);
        if (e == null) {
            return null;
        }
        if (System.currentTimeMillis() - e.ts > this.cacheTtlMillis) {
            this.clientProtocols.remove(addr);
            return null;
        }
        return e.protocol;
    }

    private void prune(boolean soft) {
        long now = System.currentTimeMillis();
        Iterator<Map.Entry<InetAddress, Entry>> it = this.clientProtocols.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<InetAddress, Entry> me = it.next();
            if (now - me.getValue().ts <= this.cacheTtlMillis) continue;
            it.remove();
        }
        if (soft && this.clientProtocols.size() > this.cacheSoftLimit) {
            this.clientProtocols.clear();
        }
    }

    private String renderText(String raw, String formatMode) {
        String mode;
        String string = mode = formatMode == null ? "auto" : formatMode.toLowerCase();
        if ("mini".equals(mode) || "auto".equals(mode) && this.looksLikeMini(raw)) {
            Object comp = MiniMessage.miniMessage().deserialize(raw);
            Object serializer = LegacyComponentSerializer.builder().character('\u00a7').hexColors().build();
            return serializer.serialize((Component)comp);
        }
        return this.legacyWithHex(raw);
    }

    private Component parseComponent(String raw, String formatMode) {
        String mode;
        String string = mode = formatMode == null ? "auto" : formatMode.toLowerCase();
        if ("mini".equals(mode) || "auto".equals(mode) && this.looksLikeMini(raw)) {
            return MiniMessage.miniMessage().deserialize(raw);
        }
        String legacy = this.legacyWithHex(raw);
        return LegacyComponentSerializer.legacySection().deserialize(legacy);
    }

    private boolean looksLikeMini(String s) {
        return s != null && s.contains("<") && s.contains(">");
    }

    private String legacyWithHex(String input) {
        if (input == null) {
            return "";
        }
        Matcher m = HEX_PATTERN.matcher(input);
        StringBuffer sb = new StringBuffer();
        while (m.find()) {
            String hex = m.group().substring(1);
            StringBuilder rep = new StringBuilder("\u00a7x");
            for (char c : hex.toCharArray()) {
                rep.append('\u00a7').append(c);
            }
            m.appendReplacement(sb, rep.toString());
        }
        m.appendTail(sb);
        return ChatColor.translateAlternateColorCodes((char)'&', (String)sb.toString());
    }

    private String centerColored(String colored, int width) {
        int len;
        String plain = ChatColor.stripColor((String)colored);
        int n = len = plain != null ? plain.length() : colored.length();
        if (len >= width) {
            return colored;
        }
        int pad = (width - len) / 2;
        return " ".repeat(Math.max(0, pad)) + colored;
    }

    private static class Entry {
        final int protocol;
        final long ts;

        Entry(int p, long t) {
            this.protocol = p;
            this.ts = t;
        }
    }
}

