/*
 * Decompiled with CFR 0.152.
 */
package io.silvicky.item;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import io.silvicky.item.StateSaver;
import io.silvicky.item.cfg.JSONConfig;
import io.silvicky.item.common.Util;
import java.util.Iterator;
import net.minecraft.class_1934;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2596;
import net.minecraft.class_2668;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5321;
import net.minecraft.class_5454;
import net.minecraft.server.MinecraftServer;

public class InventoryManager {
    public static void savePos(class_3222 player, StateSaver stateSaver) {
        InventoryManager.savePos(player, stateSaver, player.method_51469().method_27983().method_29177().toString());
    }

    public static void savePos(class_3222 player, StateSaver stateSaver, String fakeDimension) {
        stateSaver.posList.add(new StateSaver.PositionInfo(player.method_5845(), Util.getDimensionId(fakeDimension), fakeDimension, player.method_19538()));
    }

    public static void saveInventory(class_3222 player, StateSaver stateSaver) {
        InventoryManager.saveInventory(player, stateSaver, false, player.method_51469().method_27983().method_29177().toString());
    }

    public static void saveInventory(class_3222 player, StateSaver stateSaver, boolean tmp, String fakeDimension) {
        stateSaver.nbtList.add(new StateSaver.StorageInfo(player.method_5845(), fakeDimension.substring(0, fakeDimension.indexOf(58)), Util.inventoryToStack(player.method_31548()), Util.enderToStack(player.method_7274()), player.field_7495, player.method_6032(), player.method_7344().method_7586(), player.method_7344().method_7589(), player.method_5669(), player.field_13974.method_14257().method_8379()));
        if (tmp) {
            return;
        }
        player.method_31548().method_5448();
        player.method_7274().method_5448();
        player.method_14228(0);
        player.method_6033(20.0f);
        player.method_7344().method_7580(20);
        player.method_7344().method_7581(5.0f);
        player.field_13974.method_30118(class_1934.field_9215);
        if (player.field_13987 != null) {
            player.field_13987.method_14364((class_2596)new class_2668(class_2668.field_25648, (float)class_1934.field_9215.method_8379()));
        }
    }

    public static void loadPos(MinecraftServer server, class_3222 player, class_3218 targetDimension, StateSaver stateSaver) throws CommandSyntaxException {
        targetDimension = Util.toOverworld(server, targetDimension);
        Iterator<StateSaver.PositionInfo> iterator = stateSaver.posList.iterator();
        StateSaver.PositionInfo n = null;
        while (iterator.hasNext()) {
            StateSaver.PositionInfo nt = iterator.next();
            if (!nt.player.equals(player.method_5845()) || !nt.dimension.equals(Util.getDimensionId(targetDimension))) continue;
            iterator.remove();
            Util.LOGGER.info("Fetched position data!");
            if (n != null) {
                Util.LOGGER.warn("Duplicated data found! Discarding old data, but this should not happen...");
            }
            n = nt;
        }
        if (n == null) {
            Util.LOGGER.info("Entering a new world... Good luck to the pioneer!");
            class_2338 sp = Util.transLoc(targetDimension.method_43126().method_33096(targetDimension.method_32819() - 1), targetDimension);
            class_5454.class_9823 postDimensionTransition = class_5454.field_52245;
            class_5454 target = new class_5454(targetDimension, sp.method_46558(), class_243.field_1353, 0.0f, 0.0f, postDimensionTransition);
            if (player.field_13987 != null) {
                player.method_61275(target);
            } else {
                Util.fakeTeleportTo(player, target);
            }
        } else {
            String dim = n.rdim;
            class_3218 sw2 = server.method_3847(class_5321.method_29179((class_5321)class_5321.method_29180((class_2960)targetDimension.method_27983().method_41185()), (class_2960)class_2960.method_60655((String)targetDimension.method_27983().method_29177().method_12836(), (String)dim.substring(dim.indexOf(":") + 1))));
            if (sw2 == null) {
                Util.LOGGER.error("A dimension named " + dim + " is NOT FOUND!");
                throw Util.ERR_DIMENSION_NOT_FOUND.create();
            }
            class_243 v3d = n.pos;
            class_2338 sp = new class_2338((int)Math.floor(v3d.field_1352), (int)Math.floor(v3d.field_1351), (int)Math.floor(v3d.field_1350));
            class_5454.class_9823 postDimensionTransition = class_5454.field_52245;
            class_5454 target = new class_5454(sw2, sp.method_46558(), class_243.field_1353, 0.0f, 0.0f, postDimensionTransition);
            if (player.field_13987 != null) {
                player.method_61275(target);
            } else {
                Util.fakeTeleportTo(player, target);
            }
        }
    }

    public static void loadInventory(class_3222 player, class_3218 targetDimension, StateSaver stateSaver) throws CommandSyntaxException {
        Iterator<StateSaver.StorageInfo> iterator = stateSaver.nbtList.iterator();
        StateSaver.StorageInfo n = null;
        while (iterator.hasNext()) {
            StateSaver.StorageInfo nt = iterator.next();
            if (!nt.player.equals(player.method_5845()) || !nt.dimension.equals(targetDimension.method_27983().method_29177().method_12836())) continue;
            iterator.remove();
            Util.LOGGER.info("Fetched inventory!");
            if (n != null) {
                Util.LOGGER.warn("Duplicated data found! Discarding old data, but this should not happen...");
            }
            n = nt;
        }
        if (n != null) {
            try {
                Util.stackToInventory(player.method_31548(), n.inventory);
                Util.stackToEnder(player.method_7274(), n.ender);
            }
            catch (Exception e) {
                Util.LOGGER.error(e.getMessage());
                stateSaver.nbtList.add(n);
                throw Util.ERR_ITEM.create();
            }
            player.method_14228(n.xp);
            player.method_6033(n.hp);
            player.method_7344().method_7580(n.food);
            player.method_7344().method_7581(n.food2);
            player.method_5855(n.air);
            player.field_13974.method_30118(class_1934.method_8384((int)n.gamemode));
            if (player.field_13987 != null) {
                player.field_13987.method_14364((class_2596)new class_2668(class_2668.field_25648, (float)n.gamemode));
            }
        } else {
            player.method_31548().method_5448();
            player.method_7274().method_5448();
            player.method_14228(0);
            player.method_6033(20.0f);
            player.method_7344().method_7580(20);
            player.method_7344().method_7581(20.0f);
            player.method_5855(300);
            int gamemode = stateSaver.gamemode.getOrDefault(targetDimension.method_27983().method_29177().method_12836(), 0);
            player.field_13974.method_30118(class_1934.method_8384((int)gamemode));
            if (player.field_13987 != null) {
                player.field_13987.method_14364((class_2596)new class_2668(class_2668.field_25648, (float)gamemode));
            }
        }
    }

    public static void save(MinecraftServer server, class_3222 player) {
        InventoryManager.save(server, player, false, player.method_51469().method_27983().method_29177().toString());
    }

    public static void save(MinecraftServer server, class_3222 player, boolean tmp, String fakeDimension) {
        StateSaver stateSaver = StateSaver.getServerState(server);
        InventoryManager.savePos(player, stateSaver, fakeDimension);
        if (JSONConfig.useStorage.booleanValue()) {
            InventoryManager.saveInventory(player, stateSaver, tmp, fakeDimension);
        }
    }

    public static void load(MinecraftServer server, class_3222 player, class_3218 targetDimension) throws CommandSyntaxException {
        StateSaver stateSaver = StateSaver.getServerState(server);
        if (JSONConfig.useStorage.booleanValue()) {
            InventoryManager.loadInventory(player, targetDimension, stateSaver);
        }
        InventoryManager.loadPos(server, player, targetDimension, stateSaver);
    }

    public static void directWarp(MinecraftServer server, class_3222 player, class_3218 targetDimension) throws CommandSyntaxException {
        StateSaver stateSaver = StateSaver.getServerState(server);
        InventoryManager.savePos(player, stateSaver);
        InventoryManager.loadPos(server, player, targetDimension, stateSaver);
    }
}

