/*
 * Decompiled with CFR 0.152.
 */
package io.silvicky.item.command.warp;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import io.silvicky.item.InventoryManager;
import io.silvicky.item.StateSaver;
import io.silvicky.item.common.Util;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2181;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;

public class Warp {
    public static void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"warp").executes(context -> Warp.help((class_2168)context.getSource()))).then(class_2170.method_9244((String)"dimension", (ArgumentType)class_2181.method_9288()).executes(context -> Warp.warp((class_2168)context.getSource(), ((class_2168)context.getSource()).method_44023(), class_2181.method_9289((CommandContext)context, (String)"dimension")))));
    }

    private static int help(class_2168 source) {
        source.method_9226(() -> class_2561.method_43470((String)"Usage: /warp <dimension>"), false);
        source.method_9226(() -> class_2561.method_43470((String)"Go to that world."), false);
        source.method_9226(() -> class_2561.method_43470((String)"Only works when executed by a player."), false);
        return 1;
    }

    public static int warp(class_2168 source, class_3222 player, class_3218 dimension) throws CommandSyntaxException {
        return Warp.warp(source, player, dimension, false);
    }

    public static int warp(class_2168 source, class_3222 player, class_3218 dimension, boolean silent) throws CommandSyntaxException {
        if (player == null) {
            throw Util.ERR_NOT_BY_PLAYER.create();
        }
        class_3218 from = player.method_51469();
        MinecraftServer server = source.method_9211();
        StateSaver stateSaver = StateSaver.getServerState(server);
        StateSaver.WarpRestrictionInfo info = stateSaver.restrictionInfoHashMap.get(class_2960.method_60654((String)Util.getDimensionId(dimension)));
        if (info != null && !source.method_9259(info.level)) {
            throw Util.ERR_WARP_FORBIDDEN.create((Object)info.reason);
        }
        if (!Util.getDimensionId(dimension).equals(Util.getDimensionId(from))) {
            Util.LOGGER.info(player.method_5477().getString() + " goes to " + Util.getDimensionId(dimension));
            if (!dimension.method_27983().method_29177().method_12836().equals(from.method_27983().method_29177().method_12836())) {
                player.method_6012();
                InventoryManager.save(server, player);
                try {
                    InventoryManager.load(server, player, dimension);
                }
                catch (Exception e) {
                    InventoryManager.loadInventory(player, from, StateSaver.getServerState(server));
                    throw e;
                }
            } else {
                InventoryManager.directWarp(server, player, dimension);
            }
            if (!silent) {
                source.method_9226(() -> class_2561.method_43470((String)("Teleported to " + Util.getDimensionId(dimension) + "!")), false);
            }
        } else if (!silent) {
            source.method_9226(() -> class_2561.method_43470((String)"Nothing happened."), false);
        }
        return 1;
    }
}

