/*
 * Decompiled with CFR 0.152.
 */
package io.silvicky.item.command.world;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import io.silvicky.item.StateSaver;
import io.silvicky.item.command.warp.BanWarp;
import io.silvicky.item.command.warp.Evacuate;
import io.silvicky.item.command.world.ImportWorld;
import io.silvicky.item.common.Util;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2181;
import net.minecraft.class_2232;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_5218;
import net.minecraft.class_5321;
import net.minecraft.class_5363;
import net.minecraft.class_7924;
import net.minecraft.server.MinecraftServer;

public class DeleteWorld {
    private static class_2960 id;
    private static boolean firstType;

    public static void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"deleteworld").requires(source -> source.method_9259(4))).executes(context -> DeleteWorld.help((class_2168)context.getSource()))).then(class_2170.method_9244((String)"dimension_id", (ArgumentType)class_2232.method_9441()).then(class_2170.method_9244((String)"target", (ArgumentType)class_2181.method_9288()).executes(context -> DeleteWorld.deleteWorld((class_2168)context.getSource(), class_2232.method_9443((CommandContext)context, (String)"dimension_id"), class_2181.method_9289((CommandContext)context, (String)"target"))))));
    }

    private static int help(class_2168 source) {
        source.method_9226(() -> class_2561.method_43470((String)"Usage: /deleteworld <id> <target>"), false);
        source.method_9226(() -> class_2561.method_43470((String)"Delete a world."), false);
        source.method_9226(() -> class_2561.method_43470((String)"If <id> is a member of a triplet, all the triplet would be deleted."), false);
        source.method_9226(() -> class_2561.method_43470((String)"Any player (even offline) would be evacuated into <target>."), false);
        source.method_9226(() -> class_2561.method_43470((String)"During the first stage, no actual change would be done until restart, when the dimension entries are deleted."), false);
        source.method_9226(() -> class_2561.method_43470((String)"During the second stage, actual change would be done and no restart is needed."), false);
        return 1;
    }

    public static boolean notifyEvacuation(class_2168 source, class_2960 id) {
        List<String> players = Util.getListOfPlayers(source.method_9211(), id.toString());
        if (!players.isEmpty()) {
            source.method_9226(() -> class_2561.method_43470((String)"Some players are still in that world:"), false);
            source.method_9226(() -> class_2561.method_43470((String)Util.listToString(players)), false);
            source.method_9226(() -> class_2561.method_43470((String)"Please evacuate them, otherwise undefined behavior might be observed."), false);
            return true;
        }
        return false;
    }

    public static int deleteWorld(class_2168 source, class_2960 idTmp, class_3218 safeZone) throws CommandSyntaxException {
        if (firstType) {
            firstType = false;
            source.method_9226(() -> class_2561.method_43470((String)"Hello, admin! This command can delete a world. The world will be lost forever(a long time). It is still strongly suggested that you backup your save first. Also you need to read the result carefully. Type this command without arguments to see the help. Type this command again if you already understand what you are doing."), false);
            return 1;
        }
        id = class_2960.method_60654((String)Util.getDimensionId(idTmp.toString()));
        if (id.method_12836().equals("minecraft")) {
            source.method_9226(() -> class_2561.method_43470((String)"how dare you..."), false);
            return 1;
        }
        boolean isSinglet = !id.method_12832().endsWith("overworld");
        class_2960 idNether = null;
        class_2960 idEnd = null;
        if (!isSinglet) {
            String tmp1 = id.method_12832().substring(0, id.method_12832().length() - "overworld".length());
            idNether = class_2960.method_60655((String)id.method_12836(), (String)(tmp1 + "the_nether"));
            idEnd = class_2960.method_60655((String)id.method_12836(), (String)(tmp1 + "the_end"));
        }
        MinecraftServer server = source.method_9211();
        StateSaver stateSaver = StateSaver.getServerState(server);
        class_3218 src = server.method_3847(class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)id));
        if (src != null) {
            if (Util.getDimensionId(id.toString()).equals(Util.getDimensionId(safeZone))) {
                source.method_9226(() -> class_2561.method_43470((String)"Target dimension cannot be the same as the one to be deleted."), false);
                return 1;
            }
            BanWarp.banWarp(source, src, Integer.MAX_VALUE, "To be deleted.", true);
            Evacuate.evacuate(source, src, safeZone, false);
            ImportWorld.deletedDimensions.add((class_5321<class_5363>)class_5321.method_29179((class_5321)class_7924.field_41224, (class_2960)id));
            if (!isSinglet) {
                ImportWorld.deletedDimensions.add((class_5321<class_5363>)class_5321.method_29179((class_5321)class_7924.field_41224, (class_2960)idNether));
                ImportWorld.deletedDimensions.add((class_5321<class_5363>)class_5321.method_29179((class_5321)class_7924.field_41224, (class_2960)idEnd));
            }
            source.method_9226(() -> class_2561.method_43470((String)"Dimension options deleted."), false);
            source.method_9226(() -> class_2561.method_43470((String)"First stage is done. Restart the game and type the same command again to continue."), false);
            if (!source.method_9211().method_3816()) {
                source.method_9226(() -> class_2561.method_43470((String)"DO NOT ENTER THIS WORLD AGAIN BEFORE RESTARTING YOUR GAME OR YOUR SAVE WOULD BE DESTROYED!!!"), false);
            }
            return 1;
        }
        try {
            stateSaver.seed.remove(id);
            stateSaver.border.remove(id);
            stateSaver.restrictionInfoHashMap.remove(id);
            if (!isSinglet) {
                stateSaver.seed.remove(idNether);
                stateSaver.seed.remove(idEnd);
                stateSaver.border.remove(idNether);
                stateSaver.border.remove(idEnd);
                stateSaver.restrictionInfoHashMap.remove(idNether);
                stateSaver.restrictionInfoHashMap.remove(idEnd);
            }
            source.method_9226(() -> class_2561.method_43470((String)"Seeds deleted."), false);
        }
        catch (Exception e) {
            e.printStackTrace();
            source.method_9226(() -> class_2561.method_43470((String)"ERR: Failed to delete seed! Please manually delete them."), false);
        }
        try {
            if (!isSinglet && stateSaver.dragonFight.remove(idEnd) != null) {
                source.method_9226(() -> class_2561.method_43470((String)"Dragon fight deleted."), false);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            source.method_9226(() -> class_2561.method_43470((String)"ERR: Failed to delete dragon fight! Please manually delete them."), false);
        }
        try {
            HashSet<String> removedPlayers = new HashSet<String>();
            Iterator<StateSaver.PositionInfo> it1 = stateSaver.posList.iterator();
            int cnt = 0;
            while (it1.hasNext()) {
                StateSaver.PositionInfo i2 = it1.next();
                if (!i2.dimension.equals(id.toString())) continue;
                removedPlayers.add(i2.player);
                ++cnt;
                it1.remove();
            }
            stateSaver.nbtList.removeIf(i -> removedPlayers.contains(i.player) && i.dimension.equals(id.method_12836()));
            int finalCnt = cnt;
            source.method_9226(() -> class_2561.method_43470((String)("Deleted " + finalCnt + " player data.")), false);
        }
        catch (Exception e) {
            e.printStackTrace();
            source.method_9226(() -> class_2561.method_43470((String)"ERR: Failed to delete player data! Please manually delete them."), false);
        }
        try {
            Path target = server.method_27050(class_5218.field_24188).resolve("dimensions").resolve(id.method_12836());
            Path targetOverworld = target.resolve(id.method_12832());
            Util.deleteFolder(targetOverworld);
            if (!isSinglet) {
                Path targetNether = target.resolve(idNether.method_12832());
                Path targetEnd = target.resolve(idEnd.method_12832());
                Util.deleteFolder(targetNether);
                Util.deleteFolder(targetEnd);
            }
            target.toFile().delete();
            source.method_9226(() -> class_2561.method_43470((String)"Deleted save files."), false);
        }
        catch (Exception e) {
            e.printStackTrace();
            source.method_9226(() -> class_2561.method_43470((String)"ERR: Failed to delete save files! Please manually delete them."), false);
        }
        source.method_9226(() -> class_2561.method_43470((String)"Done."), false);
        return 1;
    }

    static {
        firstType = true;
    }
}

