/*
 * Decompiled with CFR 0.152.
 */
package io.silvicky.item;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.util.Pair;
import io.silvicky.item.ItemStorage;
import io.silvicky.item.PositionInfo;
import io.silvicky.item.StateSaver;
import io.silvicky.item.StorageInfo;
import io.silvicky.item.Warp;
import io.silvicky.item.cfg.JSONConfig;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.class_1661;
import net.minecraft.class_1730;
import net.minecraft.class_1799;
import net.minecraft.class_1934;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2596;
import net.minecraft.class_2668;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5321;
import net.minecraft.class_5454;
import net.minecraft.server.MinecraftServer;

public class InventoryManager {
    public static final String DIMENSION = "dimension";
    public static final String PLAYER = "player";
    public static final String OVERWORLD = "overworld";
    public static final String NETHER = "the_nether";
    public static final String END = "the_end";
    public static final int playerInventorySize = 41;

    public static String getDimensionId(class_3218 world) {
        Object id = world.method_27983().method_29177().toString();
        if (((String)id).endsWith(NETHER)) {
            id = ((String)id).substring(0, ((String)id).length() - 10) + OVERWORLD;
        }
        if (((String)id).endsWith(END)) {
            id = ((String)id).substring(0, ((String)id).length() - 7) + OVERWORLD;
        }
        return id;
    }

    public static class_2338 transLoc(class_2338 sp, class_3218 sw) {
        while (!sw.method_8320(sp).method_26215() || !sw.method_8320(sp.method_10084()).method_26215()) {
            sp = sp.method_10074();
        }
        while (sw.method_8320(sp.method_10074()).method_26215() && sp.method_10264() > sw.method_31607()) {
            sp = sp.method_10074();
        }
        if (sp.method_10264() == sw.method_31607()) {
            sp = sp.method_33096(sw.method_32819());
            ItemStorage.LOGGER.warn("Spawn point not found!");
        }
        return sp;
    }

    public static void savePos(class_3222 player, StateSaver stateSaver) {
        stateSaver.posList.add(new PositionInfo(player.method_5845(), InventoryManager.getDimensionId(player.method_51469()), player.method_51469().method_27983().method_29177().toString(), player.method_19538()));
    }

    public static ArrayList<Pair<class_1799, Byte>> inventoryToStack(class_1661 inventory) {
        ArrayList<Pair<class_1799, Byte>> ret = new ArrayList<Pair<class_1799, Byte>>();
        for (int i = 0; i < 41; ++i) {
            if (inventory.method_5438(i).method_7960()) continue;
            ret.add((Pair<class_1799, Byte>)new Pair((Object)inventory.method_5438(i), (Object)((byte)i)));
        }
        return ret;
    }

    public static ArrayList<Pair<class_1799, Byte>> enderToStack(class_1730 inventory) {
        ArrayList<Pair<class_1799, Byte>> ret = new ArrayList<Pair<class_1799, Byte>>();
        for (int i = 0; i < inventory.method_5439(); ++i) {
            class_1799 itemStack = inventory.method_5438(i);
            if (itemStack.method_7960()) continue;
            ret.add((Pair<class_1799, Byte>)new Pair((Object)itemStack, (Object)((byte)i)));
        }
        return ret;
    }

    public static void stackToInventory(class_1661 inventory, List<Pair<class_1799, Byte>> stack) {
        inventory.method_5448();
        for (Pair<class_1799, Byte> pair : stack) {
            byte j = (Byte)pair.getSecond();
            class_1799 itemStack = (class_1799)pair.getFirst();
            if (j >= 41) continue;
            inventory.method_5447((int)j, itemStack);
        }
    }

    public static void stackToEnder(class_1730 inventory, List<Pair<class_1799, Byte>> stack) {
        inventory.method_5448();
        for (Pair<class_1799, Byte> pair : stack) {
            byte j = (Byte)pair.getSecond();
            if (j >= inventory.method_5439()) continue;
            inventory.method_5447((int)j, (class_1799)pair.getFirst());
        }
    }

    public static void saveInventory(class_3222 player, StateSaver stateSaver) {
        stateSaver.nbtList.add(new StorageInfo(player.method_5845(), player.method_51469().method_27983().method_29177().method_12836(), InventoryManager.inventoryToStack(player.method_31548()), InventoryManager.enderToStack(player.method_7274()), player.field_7495, player.method_6032(), player.method_7344().method_7586(), player.method_7344().method_7589(), player.method_5669(), player.field_13974.method_14257().method_8379()));
        player.method_31548().method_5448();
        player.method_7274().method_5448();
        player.method_14228(0);
        player.method_6033(20.0f);
        player.method_7344().method_7580(20);
        player.method_7344().method_7581(5.0f);
        player.field_13974.method_30118(class_1934.field_9215);
        player.field_13987.method_14364((class_2596)new class_2668(class_2668.field_25648, (float)class_1934.field_9215.method_8379()));
    }

    public static void loadPos(MinecraftServer server, class_3222 player, class_3218 targetDimension, StateSaver stateSaver) throws CommandSyntaxException {
        targetDimension = InventoryManager.toOverworld(server, targetDimension);
        Iterator<PositionInfo> iterator = stateSaver.posList.iterator();
        PositionInfo n = null;
        while (iterator.hasNext()) {
            PositionInfo nt = iterator.next();
            if (!nt.player.equals(player.method_5845()) || !nt.dimension.equals(InventoryManager.getDimensionId(targetDimension))) continue;
            iterator.remove();
            ItemStorage.LOGGER.info("Fetched position data!");
            if (n != null) {
                ItemStorage.LOGGER.warn("Duplicated data found! Discarding old data, but this should not happen...");
            }
            n = nt;
        }
        if (n == null) {
            ItemStorage.LOGGER.info("Entering a new world... Good luck to the pioneer!");
            class_2338 sp = InventoryManager.transLoc(targetDimension.method_43126().method_33096(targetDimension.method_32819() - 1), targetDimension);
            class_5454.class_9823 postDimensionTransition = class_5454.field_52245;
            class_5454 target = new class_5454(targetDimension, sp.method_46558(), class_243.field_1353, 0.0f, 0.0f, postDimensionTransition);
            player.method_61275(target);
        } else {
            String dim = n.rdim;
            class_3218 sw2 = server.method_3847(class_5321.method_29179((class_5321)class_5321.method_29180((class_2960)targetDimension.method_27983().method_41185()), (class_2960)class_2960.method_60655((String)targetDimension.method_27983().method_29177().method_12836(), (String)dim.substring(dim.indexOf(":") + 1))));
            if (sw2 == null) {
                ItemStorage.LOGGER.error("A dimension named " + dim + " is NOT FOUND!");
                throw Warp.ERR_DIMENSION_NOT_FOUND.create();
            }
            class_243 v3d = n.pos;
            class_2338 sp = new class_2338((int)Math.floor(v3d.field_1352), (int)Math.floor(v3d.field_1351), (int)Math.floor(v3d.field_1350));
            class_5454.class_9823 postDimensionTransition = class_5454.field_52245;
            class_5454 target = new class_5454(sw2, sp.method_46558(), class_243.field_1353, 0.0f, 0.0f, postDimensionTransition);
            player.method_61275(target);
        }
    }

    public static void loadInventory(class_3222 player, class_3218 targetDimension, StateSaver stateSaver) throws CommandSyntaxException {
        Iterator<StorageInfo> iterator = stateSaver.nbtList.iterator();
        StorageInfo n = null;
        while (iterator.hasNext()) {
            StorageInfo nt = iterator.next();
            if (!nt.player.equals(player.method_5845()) || !nt.dimension.equals(targetDimension.method_27983().method_29177().method_12836())) continue;
            iterator.remove();
            ItemStorage.LOGGER.info("Fetched inventory!");
            if (n != null) {
                ItemStorage.LOGGER.warn("Duplicated data found! Discarding old data, but this should not happen...");
            }
            n = nt;
        }
        if (n != null) {
            try {
                InventoryManager.stackToInventory(player.method_31548(), n.inventory);
                InventoryManager.stackToEnder(player.method_7274(), n.ender);
            }
            catch (Exception e) {
                stateSaver.nbtList.add(n);
                throw Warp.ERR_ITEM.create();
            }
            player.method_14228(n.xp);
            player.method_6033(n.hp);
            player.method_7344().method_7580(n.food);
            player.method_7344().method_7581(n.food2);
            player.method_5855(n.air);
            player.field_13974.method_30118(class_1934.method_8384((int)n.gamemode));
            player.field_13987.method_14364((class_2596)new class_2668(class_2668.field_25648, (float)n.gamemode));
        } else {
            player.method_31548().method_5448();
            player.method_7274().method_5448();
            player.method_14228(0);
            player.method_6033(20.0f);
            player.method_7344().method_7580(20);
            player.method_7344().method_7581(20.0f);
            player.method_5855(300);
            player.field_13974.method_30118(class_1934.field_9215);
            player.field_13987.method_14364((class_2596)new class_2668(class_2668.field_25648, (float)class_1934.field_9215.method_8379()));
        }
    }

    public static class_3218 toOverworld(MinecraftServer server, class_3218 world) {
        String overworldId = InventoryManager.getDimensionId(world);
        class_3218 sw = server.method_3847(class_5321.method_29179((class_5321)class_5321.method_29180((class_2960)world.method_27983().method_41185()), (class_2960)class_2960.method_60655((String)world.method_27983().method_29177().method_12836(), (String)overworldId.substring(overworldId.indexOf(":") + 1))));
        return sw != null ? sw : world;
    }

    public static void save(MinecraftServer server, class_3222 player) {
        StateSaver stateSaver = StateSaver.getServerState(server);
        InventoryManager.savePos(player, stateSaver);
        if (JSONConfig.useStorage.booleanValue()) {
            InventoryManager.saveInventory(player, stateSaver);
        }
    }

    public static void load(MinecraftServer server, class_3222 player, class_3218 targetDimension) throws CommandSyntaxException {
        StateSaver stateSaver = StateSaver.getServerState(server);
        if (JSONConfig.useStorage.booleanValue()) {
            InventoryManager.loadInventory(player, targetDimension, stateSaver);
        }
        InventoryManager.loadPos(server, player, targetDimension, stateSaver);
    }

    public static void directWarp(MinecraftServer server, class_3222 player, class_3218 targetDimension) throws CommandSyntaxException {
        StateSaver stateSaver = StateSaver.getServerState(server);
        InventoryManager.savePos(player, stateSaver);
        InventoryManager.loadPos(server, player, targetDimension, stateSaver);
    }
}

