/*
 * Decompiled with CFR 0.152.
 */
package io.silvicky.item;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Objects;
import net.querz.nbt.io.NBTUtil;
import net.querz.nbt.io.NamedTag;
import net.querz.nbt.tag.CompoundTag;
import net.querz.nbt.tag.ListTag;
import net.querz.nbt.tag.StringTag;
import net.querz.nbt.tag.Tag;

public class Main {
    public static String getDimensionId(String id) {
        if (((String)id).endsWith("the_nether")) {
            id = ((String)id).substring(0, ((String)id).length() - 10) + "overworld";
        }
        if (((String)id).endsWith("the_end")) {
            id = ((String)id).substring(0, ((String)id).length() - 7) + "overworld";
        }
        return id;
    }

    public static void main(String[] args) throws IOException {
        String mainFile;
        BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));
        System.out.println("Welcome to CombinedWorld maintenance console!");
        System.out.println("Give me a ItemStorage.dat path for later use:");
        while (!new File(mainFile = reader.readLine()).exists()) {
            System.out.println("uhh...retry(no quote, just a bare line)");
        }
        while (true) {
            NamedTag mainDat = NBTUtil.read((String)mainFile);
            CompoundTag mainTag = (CompoundTag)mainDat.getTag();
            ListTag pos = mainTag.getCompoundTag("data").getListTag("pos");
            ListTag saved = mainTag.getCompoundTag("data").getListTag("saved");
            System.out.println("Choose operation you need:");
            System.out.println("1.Rename group");
            System.out.println("2.Turn non-vanilla player data into mod stored data(to prevent collision)");
            System.out.println("9.Quit");
            int i = Integer.parseInt(reader.readLine());
            if (i == 1) {
                String pd;
                System.out.println("Input old group name:");
                String old = reader.readLine();
                System.out.println("Input new group name:");
                String neu = reader.readLine();
                for (CompoundTag ctg1 : pos) {
                    String oldVal;
                    if (ctg1.getStringTag("dimension").getValue().startsWith(old)) {
                        oldVal = ctg1.getStringTag("dimension").getValue();
                        ctg1.getStringTag("dimension").setValue(neu + oldVal.replaceFirst(old, ""));
                    }
                    if (!ctg1.getStringTag("rdim").getValue().startsWith(old)) continue;
                    oldVal = ctg1.getStringTag("rdim").getValue();
                    ctg1.getStringTag("rdim").setValue(neu + oldVal.replaceFirst(old, ""));
                }
                for (CompoundTag ctg1 : saved) {
                    if (!ctg1.getStringTag("dimension").getValue().equals(old)) continue;
                    ctg1.getStringTag("dimension").setValue(neu);
                }
                System.out.println("Now, give me a path to playerdata folder:");
                while (!new File(pd = reader.readLine()).exists() || !new File(pd).isDirectory()) {
                    System.out.println("uhh...retry(no quote, just a bare line)");
                }
                File pdFile = new File(pd);
                for (File file : Objects.requireNonNull(pdFile.listFiles())) {
                    String oldVal;
                    if (!file.getPath().endsWith("dat")) continue;
                    NamedTag tg = NBTUtil.read((File)file);
                    CompoundTag ctg1 = (CompoundTag)tg.getTag();
                    if (ctg1.getStringTag("Dimension").getValue().startsWith(old)) {
                        oldVal = ctg1.getStringTag("Dimension").getValue();
                        ctg1.getStringTag("Dimension").setValue(neu + oldVal.replaceFirst(old, ""));
                    }
                    if (ctg1.getStringTag("SpawnDimension") != null && ctg1.getStringTag("SpawnDimension").getValue().startsWith(old)) {
                        oldVal = ctg1.getStringTag("SpawnDimension").getValue();
                        ctg1.getStringTag("SpawnDimension").setValue(neu + oldVal.replaceFirst(old, ""));
                    }
                    NBTUtil.write((NamedTag)tg, (File)file);
                }
                NBTUtil.write((NamedTag)mainDat, (String)mainFile);
                System.out.println("Done. You need to move world folder and level.dat manually.");
                continue;
            }
            if (i == 2) {
                String pd;
                System.out.println("Now, give me a path to playerdata folder:");
                while (!new File(pd = reader.readLine()).exists() || !new File(pd).isDirectory()) {
                    System.out.println("uhh...retry(no quote, just a bare line)");
                }
                File pdFile = new File(pd);
                for (File file : Objects.requireNonNull(pdFile.listFiles())) {
                    NamedTag tg;
                    CompoundTag tgc;
                    if (!file.getPath().endsWith("dat") || (tgc = (CompoundTag)(tg = NBTUtil.read((File)file)).getTag()).getStringTag("Dimension").getValue().startsWith("minecraft:")) continue;
                    CompoundTag posDat = new CompoundTag();
                    CompoundTag savedDat = new CompoundTag();
                    CompoundTag posDat1 = new CompoundTag();
                    posDat1.put("x", tgc.getListTag("Pos").asDoubleTagList().get(0));
                    posDat1.put("y", tgc.getListTag("Pos").asDoubleTagList().get(1));
                    posDat1.put("z", tgc.getListTag("Pos").asDoubleTagList().get(2));
                    posDat.put("pos", (Tag)posDat1);
                    posDat.put("rdim", (Tag)tgc.getStringTag("Dimension"));
                    posDat.put("player", (Tag)new StringTag(file.getName().replaceFirst(".dat", "")));
                    posDat.put("dimension", (Tag)new StringTag(Main.getDimensionId(tgc.getStringTag("Dimension").getValue())));
                    pos.add((Tag)posDat);
                    savedDat.put("inventory", (Tag)tgc.getListTag("Inventory"));
                    savedDat.put("ender", (Tag)tgc.getListTag("EnderItems"));
                    String did = tgc.getStringTag("Dimension").getValue();
                    savedDat.put("dimension", (Tag)new StringTag(did.substring(0, did.indexOf(58))));
                    savedDat.put("player", (Tag)new StringTag(file.getName().replaceFirst(".dat", "")));
                    savedDat.put("air", (Tag)tgc.getShortTag("Air"));
                    savedDat.put("gamemode", (Tag)tgc.getIntTag("playerGameType"));
                    saved.add((Tag)savedDat);
                }
                NBTUtil.write((NamedTag)mainDat, (String)mainFile);
                continue;
            }
            if (i == 9) break;
        }
    }
}

