/*
 * Decompiled with CFR 0.152.
 */
package io.silvicky.item.cfg;

import com.google.gson.Gson;
import io.silvicky.item.ItemStorage;
import io.silvicky.item.cfg.Cfg;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.nio.file.Paths;
import net.fabricmc.loader.api.FabricLoader;

public class JSONConfig {
    public static Boolean useStorage = true;
    protected static final File cfgFile = Paths.get(FabricLoader.getInstance().getConfigDir().toString(), "ItemStorage.json").toFile();
    protected static final Gson gson = new Gson();

    private static void reCreateCfg() {
        try {
            FileWriter writer = new FileWriter(cfgFile, false);
            gson.toJson((Object)new Cfg(), (Appendable)writer);
            ((Writer)writer).close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void config() {
        if (!cfgFile.exists()) {
            JSONConfig.reCreateCfg();
        } else {
            ItemStorage.LOGGER.info("Find ItemStorage config!");
            try {
                Cfg cfg = (Cfg)gson.fromJson((Reader)new FileReader(cfgFile), Cfg.class);
                if (cfg == null) {
                    JSONConfig.reCreateCfg();
                    return;
                }
                useStorage = cfg.useStorage;
            }
            catch (FileNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

