/*
 * Decompiled with CFR 0.152.
 */
package io.silvicky.item.command.warp;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import io.silvicky.item.InventoryManager;
import io.silvicky.item.command.warp.Warp;
import io.silvicky.item.command.warp.WarpTp;
import io.silvicky.item.command.world.ImportWorld;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2181;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5218;

public class Evacuate {
    public static void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"evacuate").requires(ctx -> ctx.method_9259(2))).executes(context -> Evacuate.help((class_2168)context.getSource()))).then(class_2170.method_9247((String)"online").then(class_2170.method_9244((String)"dimension", (ArgumentType)class_2181.method_9288()).then(class_2170.method_9244((String)WarpTp.TARGET, (ArgumentType)class_2181.method_9288()).executes(context -> Evacuate.evacuate((class_2168)context.getSource(), class_2181.method_9289((CommandContext)context, (String)"dimension"), class_2181.method_9289((CommandContext)context, (String)WarpTp.TARGET), true)))))).then(class_2170.method_9247((String)"all").then(class_2170.method_9244((String)"dimension", (ArgumentType)class_2181.method_9288()).then(class_2170.method_9244((String)WarpTp.TARGET, (ArgumentType)class_2181.method_9288()).executes(context -> Evacuate.evacuate((class_2168)context.getSource(), class_2181.method_9289((CommandContext)context, (String)"dimension"), class_2181.method_9289((CommandContext)context, (String)WarpTp.TARGET), false))))));
    }

    private static int help(class_2168 source) {
        source.method_9226(() -> class_2561.method_43470((String)"Usage: /evacuate (online|all) <dimension> <target>"), false);
        source.method_9226(() -> class_2561.method_43470((String)"Warp all players in world of <dimension> into <target>"), false);
        return 1;
    }

    public static int evacuate(class_2168 source, class_3218 src, class_3218 dest, boolean online) throws CommandSyntaxException {
        if (InventoryManager.getDimensionId(dest).equals(InventoryManager.getDimensionId(src))) {
            source.method_9226(() -> class_2561.method_43470((String)"Nothing happened."), false);
            return 1;
        }
        int cnt = 0;
        for (class_3222 player : source.method_9211().method_3760().method_14571()) {
            if (!InventoryManager.getDimensionId(player.method_51469()).equals(InventoryManager.getDimensionId(src))) continue;
            Warp.warp(source, player, dest, true);
            ++cnt;
        }
        if (!online) {
            Path playerData = source.method_9211().method_27050(class_5218.field_24182);
            for (File i : playerData.toFile().listFiles()) {
                try {
                    class_3222 class_32222 = ImportWorld.loadFakePlayer(i.toPath());
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        int finalCnt = cnt;
        source.method_9226(() -> class_2561.method_43470((String)("Evacuated " + finalCnt + " players.")), false);
        return 1;
    }
}

