/*
 * Decompiled with CFR 0.152.
 */
package io.silvicky.item.command.warp;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.LiteralMessage;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import io.silvicky.item.InventoryManager;
import io.silvicky.item.ItemStorage;
import io.silvicky.item.StateSaver;
import java.util.function.Function;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2181;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;

public class Warp {
    public static final SimpleCommandExceptionType ERR_DIMENSION_NOT_FOUND = new SimpleCommandExceptionType((Message)new LiteralMessage("Target dimension NOT FOUND!"));
    public static final SimpleCommandExceptionType ERR_ITEM = new SimpleCommandExceptionType((Message)new LiteralMessage("Item stack error(from version change, contact your admin)!"));
    public static final SimpleCommandExceptionType ERR_NOT_BY_PLAYER = new SimpleCommandExceptionType((Message)new LiteralMessage("This command must be executed by a player."));
    public static final SimpleCommandExceptionType ERR_NOT_ONE_PLAYER = new SimpleCommandExceptionType((Message)new LiteralMessage("Amount of player selected must be exactly one."));
    public static final DynamicCommandExceptionType ERR_WARP_FORBIDDEN = new DynamicCommandExceptionType((Function)new Function<Object, Message>(){

        @Override
        public Message apply(Object o) {
            return new LiteralMessage("Warp forbidden! Reason: " + String.valueOf(o));
        }
    });

    public static void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"warp").executes(context -> Warp.help((class_2168)context.getSource()))).then(class_2170.method_9244((String)"dimension", (ArgumentType)class_2181.method_9288()).executes(context -> Warp.warp((class_2168)context.getSource(), ((class_2168)context.getSource()).method_44023(), class_2181.method_9289((CommandContext)context, (String)"dimension")))));
    }

    private static int help(class_2168 source) {
        source.method_9226(() -> class_2561.method_43470((String)"Usage: /warp <dimension>"), false);
        source.method_9226(() -> class_2561.method_43470((String)"Go to that world."), false);
        source.method_9226(() -> class_2561.method_43470((String)"Only works when executed by a player."), false);
        return 1;
    }

    public static int warp(class_2168 source, class_3222 player, class_3218 dimension) throws CommandSyntaxException {
        return Warp.warp(source, player, dimension, false);
    }

    public static int warp(class_2168 source, class_3222 player, class_3218 dimension, boolean silent) throws CommandSyntaxException {
        if (player == null) {
            throw ERR_NOT_BY_PLAYER.create();
        }
        class_3218 from = player.method_51469();
        MinecraftServer server = source.method_9211();
        StateSaver stateSaver = StateSaver.getServerState(server);
        StateSaver.WarpRestrictionInfo info = stateSaver.restrictionInfoHashMap.get(class_2960.method_60654((String)InventoryManager.getDimensionId(dimension)));
        if (info != null && !source.method_9259(info.level)) {
            throw ERR_WARP_FORBIDDEN.create((Object)info.reason);
        }
        if (!InventoryManager.getDimensionId(dimension).equals(InventoryManager.getDimensionId(from))) {
            ItemStorage.LOGGER.info(player.method_5477().getString() + " goes to " + InventoryManager.getDimensionId(dimension));
            if (!dimension.method_27983().method_29177().method_12836().equals(from.method_27983().method_29177().method_12836())) {
                player.method_6012();
                InventoryManager.save(server, player);
                try {
                    InventoryManager.load(server, player, dimension);
                }
                catch (Exception e) {
                    InventoryManager.loadInventory(player, from, StateSaver.getServerState(server));
                    throw e;
                }
            } else {
                InventoryManager.directWarp(server, player, dimension);
            }
            if (!silent) {
                source.method_9226(() -> class_2561.method_43470((String)("Teleported to " + InventoryManager.getDimensionId(dimension) + "!")), false);
            }
        } else if (!silent) {
            source.method_9226(() -> class_2561.method_43470((String)"Nothing happened."), false);
        }
        return 1;
    }
}

