/*
 * Decompiled with CFR 0.152.
 */
package io.silvicky.item.command.warp;

import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import io.silvicky.item.command.warp.Warp;
import java.util.Collection;
import net.minecraft.class_1297;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2181;
import net.minecraft.class_2186;
import net.minecraft.class_2191;
import net.minecraft.class_2277;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5454;
import net.minecraft.server.MinecraftServer;

public class WarpTp {
    public static String PLAYER = "player";
    public static String CORD = "coordination";
    public static String TARGET = "target";

    public static void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"warptp").requires(source -> source.method_9259(2))).executes(context -> WarpTp.help((class_2168)context.getSource()))).then(class_2170.method_9244((String)"dimension", (ArgumentType)class_2181.method_9288()).then(class_2170.method_9244((String)CORD, (ArgumentType)class_2277.method_9737()).executes(context -> WarpTp.warpTp((class_2168)context.getSource(), class_2181.method_9289((CommandContext)context, (String)"dimension"), class_2277.method_9736((CommandContext)context, (String)CORD)))))).then(class_2170.method_9244((String)TARGET, (ArgumentType)class_2186.method_9309()).executes(context -> WarpTp.warpTp((class_2168)context.getSource(), class_2186.method_9313((CommandContext)context, (String)TARGET))))).then(((RequiredArgumentBuilder)class_2170.method_9244((String)PLAYER, (ArgumentType)class_2191.method_9329()).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"dimension", (ArgumentType)class_2181.method_9288()).executes(context -> WarpTp.warpTp((class_2168)context.getSource(), (Collection<GameProfile>)class_2191.method_9330((CommandContext)context, (String)PLAYER), class_2181.method_9289((CommandContext)context, (String)"dimension")))).then(class_2170.method_9244((String)CORD, (ArgumentType)class_2277.method_9737()).executes(context -> WarpTp.warpTp((class_2168)context.getSource(), class_2191.method_9330((CommandContext)context, (String)PLAYER), class_2181.method_9289((CommandContext)context, (String)"dimension"), class_2277.method_9736((CommandContext)context, (String)CORD)))))).then(class_2170.method_9244((String)TARGET, (ArgumentType)class_2186.method_9309()).executes(context -> WarpTp.warpTp((class_2168)context.getSource(), (Collection<GameProfile>)class_2191.method_9330((CommandContext)context, (String)PLAYER), class_2186.method_9313((CommandContext)context, (String)TARGET))))));
    }

    private static int help(class_2168 source) {
        source.method_9226(() -> class_2561.method_43470((String)"Usage:"), false);
        source.method_9226(() -> class_2561.method_43470((String)"/warptp [<player>] <dimension> [<position>]"), false);
        source.method_9226(() -> class_2561.method_43470((String)"/warptp [<player>] <target>"), false);
        source.method_9226(() -> class_2561.method_43470((String)"Warp <player>(or yourself) to world of <dimension>(and subsequent teleport)"), false);
        return 1;
    }

    public static class_3222 profileListToPlayer(MinecraftServer server, Collection<GameProfile> profileList) throws CommandSyntaxException {
        if (profileList.size() != 1) {
            throw Warp.ERR_NOT_ONE_PLAYER.create();
        }
        GameProfile profile = profileList.stream().toList().getFirst();
        return server.method_3760().method_14566(profile.getName());
    }

    public static int warpTp(class_2168 source, Collection<GameProfile> profileList, class_3218 dimension) throws CommandSyntaxException {
        return Warp.warp(source, WarpTp.profileListToPlayer(source.method_9211(), profileList), dimension);
    }

    public static int warpTp(class_2168 source, Collection<GameProfile> profileList, class_3218 dimension, class_243 target) throws CommandSyntaxException {
        return WarpTp.warpTp(source, WarpTp.profileListToPlayer(source.method_9211(), profileList), dimension, target);
    }

    public static int warpTp(class_2168 source, class_3222 player, class_3218 dimension, class_243 target) throws CommandSyntaxException {
        Warp.warp(source, player, dimension);
        class_5454 tpTarget = new class_5454(dimension, target, class_243.field_1353, 0.0f, 0.0f, class_5454.field_52245);
        player.method_61275(tpTarget);
        return 1;
    }

    public static int warpTp(class_2168 source, class_3218 dimension, class_243 target) throws CommandSyntaxException {
        return WarpTp.warpTp(source, source.method_44023(), dimension, target);
    }

    public static int warpTp(class_2168 source, class_1297 entity) throws CommandSyntaxException {
        return WarpTp.warpTp(source, (class_3218)entity.method_37908(), entity.method_19538());
    }

    public static int warpTp(class_2168 source, Collection<GameProfile> profileList, class_1297 entity) throws CommandSyntaxException {
        return WarpTp.warpTp(source, profileList, (class_3218)entity.method_37908(), entity.method_19538());
    }
}

