/*
 * Decompiled with CFR 0.152.
 */
package io.silvicky.item.command.world;

import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.LiteralMessage;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.datafixers.DataFixer;
import com.mojang.serialization.Dynamic;
import io.silvicky.item.InventoryManager;
import io.silvicky.item.ItemStorage;
import io.silvicky.item.StateSaver;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Stream;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2232;
import net.minecraft.class_2487;
import net.minecraft.class_2505;
import net.minecraft.class_2507;
import net.minecraft.class_2512;
import net.minecraft.class_2561;
import net.minecraft.class_2881;
import net.minecraft.class_2960;
import net.minecraft.class_32;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3551;
import net.minecraft.class_4284;
import net.minecraft.class_4844;
import net.minecraft.class_5218;
import net.minecraft.class_5321;
import net.minecraft.class_5363;
import net.minecraft.class_6903;
import net.minecraft.class_7134;
import net.minecraft.class_7225;
import net.minecraft.class_7726;
import net.minecraft.class_7924;
import net.minecraft.class_8792;
import net.minecraft.server.MinecraftServer;

public class ImportWorld {
    public static class_7225.class_7874 wrapper;
    public static HashMap<class_5321<class_5363>, class_5363> newDimensions;
    public static HashSet<class_5321<class_5363>> deletedDimensions;
    private static StateSaver stateSaver;
    private static ArrayList<class_2960> identifiers;
    private static boolean firstType;
    private static class_2960 id;
    public static final String DIMENSION_ID = "dimension_id";
    public static final String DIMENSION_PATH = "path";
    public static final String DATA = "data";
    public static final String POI = "poi";
    public static final String REGION = "region";
    public static final String ENTITIES = "entities";
    private static MinecraftServer server;
    public static final SimpleCommandExceptionType ERR_DIMENSION_EXIST;
    public static final SimpleCommandExceptionType ERR_NAMESPACE_EXIST;
    public static final SimpleCommandExceptionType ERR_FOLDER_NOT_EXIST;
    public static final SimpleCommandExceptionType ERR_LEVEL_NOT_EXIST;
    public static final SimpleCommandExceptionType ERR_FAIL_TO_READ_LEVEL;
    public static final SimpleCommandExceptionType ERR_WORLD_GEN;
    public static final SimpleCommandExceptionType ERR_PLAYER;
    public static final SimpleCommandExceptionType ERR_SAVE;

    public static void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"importworld").requires(source -> source.method_9259(4))).executes(context -> ImportWorld.help((class_2168)context.getSource()))).then(((RequiredArgumentBuilder)class_2170.method_9244((String)DIMENSION_ID, (ArgumentType)class_2232.method_9441()).executes(context -> ImportWorld.importWorld((class_2168)context.getSource(), Paths.get(FabricLoader.getInstance().getGameDir().toString(), "imported"), class_2232.method_9443((CommandContext)context, (String)DIMENSION_ID)))).then(class_2170.method_9244((String)DIMENSION_PATH, (ArgumentType)StringArgumentType.greedyString()).executes(context -> ImportWorld.importWorld((class_2168)context.getSource(), Paths.get(StringArgumentType.getString((CommandContext)context, (String)DIMENSION_PATH), new String[0]), class_2232.method_9443((CommandContext)context, (String)DIMENSION_ID))))));
    }

    private static int help(class_2168 source) {
        source.method_9226(() -> class_2561.method_43470((String)"Usage: /importworld <id> [<path>]"), false);
        source.method_9226(() -> class_2561.method_43470((String)"Import the world in <path>(default <game_root>/imported) and give it id of <id>."), false);
        source.method_9226(() -> class_2561.method_43470((String)"Namespace of <id> mustn't be used in other dimensions to prevent collision."), false);
        source.method_9226(() -> class_2561.method_43470((String)"If <id> ends with overworld/the_nether/the_end, world would be imported as a vanilla triplet."), false);
        source.method_9226(() -> class_2561.method_43470((String)"Otherwise, world would be imported as a singlet and only overworld would be imported."), false);
        source.method_9226(() -> class_2561.method_43470((String)"Currently only vanilla worlds are supported."), false);
        source.method_9226(() -> class_2561.method_43470((String)"After importing, restart the whole game to apply changes."), false);
        return 1;
    }

    private static void rollbackSeed() {
        for (class_2960 i : identifiers) {
            ImportWorld.stateSaver.seed.remove(i);
        }
    }

    private static void rollbackDragon() {
        for (class_2960 i : identifiers) {
            ImportWorld.stateSaver.dragonFight.remove(i);
        }
        ImportWorld.rollbackSeed();
    }

    private static void rollbackPlayer() {
        ImportWorld.stateSaver.posList.removeIf(positionInfo -> positionInfo.dimension.equals(id.toString()));
        ImportWorld.stateSaver.nbtList.removeIf(storageInfo -> storageInfo.dimension.equals(id.method_12836()));
        ImportWorld.rollbackDragon();
    }

    public static void deleteFolder(Path path) throws IOException {
        if (!path.toFile().exists()) {
            return;
        }
        Files.walkFileTree(path, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                Files.delete(file);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                Files.delete(dir);
                return FileVisitResult.CONTINUE;
            }
        });
    }

    public static void copyFolder(Path src, Path dest) throws IOException {
        try (Stream<Path> stream = Files.walk(src, new FileVisitOption[0]);){
            stream.forEach(source -> {
                try {
                    Files.copy(source, dest.resolve(src.relativize((Path)source)), StandardCopyOption.REPLACE_EXISTING);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            });
        }
    }

    private static void rollbackWorld() {
        Path target = server.method_27050(class_5218.field_24188).resolve("dimensions").resolve(id.method_12836());
        try {
            ImportWorld.deleteFolder(target);
        }
        catch (Exception e) {
            e.printStackTrace();
            ItemStorage.LOGGER.warn("Failed to delete the copied save files, please check manually!");
        }
        ImportWorld.rollbackPlayer();
    }

    private static void rollbackLevel() {
        newDimensions.entrySet().removeIf(entry -> identifiers.contains(((class_5321)entry.getKey()).method_29177()));
        ImportWorld.rollbackWorld();
    }

    public static class_3222 loadFakePlayer(class_2487 compound) {
        class_8792 connectedClientData = class_8792.method_53824((GameProfile)new GameProfile((UUID)compound.method_67491("UUID", class_4844.field_25122).orElseThrow(), "tmp"), (boolean)false);
        class_3218 world = server.method_3847(class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)class_2960.method_60654((String)compound.method_68564("Dimension", server.method_30002().method_27983().method_29177().toString()))));
        if (world == null) {
            world = server.method_30002();
        }
        class_3222 serverPlayerEntity = new class_3222(server, world, connectedClientData.comp_1959(), connectedClientData.comp_1961());
        serverPlayerEntity.method_5651(compound);
        serverPlayerEntity.method_32748(compound);
        return serverPlayerEntity;
    }

    public static class_3222 loadFakePlayer(Path path) throws IOException {
        class_2487 nbtCompound = class_2507.method_30613((Path)path, (class_2505)class_2505.method_53898());
        nbtCompound = class_4284.field_19213.method_48130(class_3551.method_15450(), nbtCompound, class_2512.method_48309((class_2487)nbtCompound, (int)-1));
        return ImportWorld.loadFakePlayer(nbtCompound);
    }

    /*
     * WARNING - void declaration
     */
    public static int importWorld(class_2168 source, Path path, class_2960 idTmp) throws CommandSyntaxException {
        void var4_14;
        class_7726 worldGenSettings;
        Dynamic levelDynamic;
        if (firstType) {
            firstType = false;
            source.method_9226(() -> class_2561.method_43470((String)"Hello, admin! This command can import a world(currently vanilla only), and although it has been tested, it is still strongly suggested that you backup your save first. Also you need to read the result carefully. Type this command without arguments to see the help. Type this command again if you already understand what you are doing."), false);
            return 1;
        }
        server = source.method_9211();
        stateSaver = StateSaver.getServerState(server);
        id = class_2960.method_60654((String)InventoryManager.getDimensionId(idTmp.toString()));
        for (class_3218 class_32182 : server.method_3738()) {
            if (!class_32182.method_27983().method_29177().equals((Object)id)) continue;
            throw ERR_DIMENSION_EXIST.create();
        }
        for (class_5321 class_53212 : newDimensions.keySet()) {
            if (!class_53212.method_29177().equals((Object)id)) continue;
            throw ERR_DIMENSION_EXIST.create();
        }
        for (class_3218 class_32183 : server.method_3738()) {
            if (!class_32183.method_27983().method_29177().method_12836().equals(id.method_12836())) continue;
            throw ERR_NAMESPACE_EXIST.create();
        }
        for (class_5321 class_53213 : newDimensions.keySet()) {
            if (!class_53213.method_29177().method_12836().equals(id.method_12836())) continue;
            throw ERR_NAMESPACE_EXIST.create();
        }
        identifiers = new ArrayList();
        identifiers.add(id);
        boolean isSinglet = !id.method_12832().endsWith("overworld");
        Object var4_12 = null;
        class_2960 idEnd = null;
        if (!isSinglet) {
            String tmp1 = id.method_12832().substring(0, id.method_12832().length() - "overworld".length());
            class_2960 class_29602 = class_2960.method_60655((String)id.method_12836(), (String)(tmp1 + "the_nether"));
            idEnd = class_2960.method_60655((String)id.method_12836(), (String)(tmp1 + "the_end"));
            identifiers.add(class_29602);
            identifiers.add(idEnd);
        }
        if (!path.toFile().exists() || !path.toFile().isDirectory()) {
            throw ERR_FOLDER_NOT_EXIST.create();
        }
        Path levelDat = null;
        for (File i : path.toFile().listFiles()) {
            if (!i.getPath().endsWith("level.dat")) continue;
            levelDat = i.toPath();
            break;
        }
        if (levelDat == null) {
            throw ERR_LEVEL_NOT_EXIST.create();
        }
        try {
            levelDynamic = class_32.method_54528(levelDat, (DataFixer)class_3551.method_15450());
        }
        catch (Exception e) {
            e.printStackTrace();
            throw ERR_FAIL_TO_READ_LEVEL.create();
        }
        try {
            Dynamic dynamic2 = class_6903.method_56622((Dynamic)levelDynamic, (class_7225.class_7874)wrapper);
            worldGenSettings = (class_7726)class_7726.field_40366.parse(dynamic2.get("WorldGenSettings").orElseEmptyMap()).getOrThrow();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw ERR_WORLD_GEN.create();
        }
        source.method_9226(() -> class_2561.method_43470((String)"Fetched WorldGenSettings."), false);
        long seed = worldGenSettings.comp_1019().method_28028();
        ImportWorld.stateSaver.seed.put(id, seed);
        if (!isSinglet) {
            ImportWorld.stateSaver.seed.put((class_2960)var4_14, seed);
            ImportWorld.stateSaver.seed.put(idEnd, seed);
        }
        source.method_9226(() -> class_2561.method_43470((String)"Seed configured."), false);
        try {
            class_2881.class_8576 dragon = (class_2881.class_8576)class_2881.class_8576.field_44945.parse(levelDynamic.get("DragonFight").orElseEmptyMap()).getOrThrow();
            if (!isSinglet && ((class_5363)worldGenSettings.comp_1020().comp_1014().get(class_5363.field_25414)).comp_1012().method_40225(class_7134.field_37668)) {
                ImportWorld.stateSaver.dragonFight.put(idEnd, dragon);
                source.method_9226(() -> class_2561.method_43470((String)"Configured dragon fight."), false);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            source.method_9226(() -> class_2561.method_43470((String)"Failed to fetch dragon fight... but not a big deal."), false);
        }
        Path playerData = path.resolve("playerdata");
        try {
            int cnt = 0;
            for (File i : playerData.toFile().listFiles()) {
                if (!i.getPath().endsWith(".dat")) continue;
                class_2487 nbtCompound = class_2507.method_30613((Path)i.toPath(), (class_2505)class_2505.method_53898());
                nbtCompound = class_4284.field_19213.method_48130(class_3551.method_15450(), nbtCompound, class_2512.method_48309((class_2487)nbtCompound, (int)-1));
                class_3222 serverPlayerEntity = ImportWorld.loadFakePlayer(nbtCompound);
                String dimension = nbtCompound.method_68564("Dimension", "minecraft:overworld");
                class_2960 identifier = class_2960.method_60654((String)dimension);
                if (!identifier.method_12836().equals("minecraft")) continue;
                dimension = identifier.method_12832();
                String fakeDimension = null;
                switch (dimension) {
                    case "the_end": {
                        if (isSinglet) break;
                        fakeDimension = idEnd.toString();
                        break;
                    }
                    case "the_nether": {
                        if (isSinglet) break;
                        fakeDimension = var4_14.toString();
                        break;
                    }
                    case "overworld": {
                        fakeDimension = id.toString();
                    }
                }
                if (fakeDimension == null) continue;
                InventoryManager.save(server, serverPlayerEntity, true, fakeDimension);
                ++cnt;
            }
            int finalCnt = cnt;
            source.method_9226(() -> class_2561.method_43470((String)("Fetched " + finalCnt + " player data.")), false);
        }
        catch (Exception e) {
            e.printStackTrace();
            ImportWorld.rollbackPlayer();
            throw ERR_PLAYER.create();
        }
        source.method_9226(() -> class_2561.method_43470((String)"We're'bout to copy the save files, you can go to have a rest now..."), false);
        try {
            Path target = server.method_27050(class_5218.field_24188).resolve("dimensions").resolve(id.method_12836());
            ImportWorld.deleteFolder(target);
            target.toFile().mkdirs();
            Path targetOverworld = target.resolve(id.method_12832());
            if (!isSinglet) {
                Path targetNether = target.resolve(var4_14.method_12832());
                Path targetEnd = target.resolve(idEnd.method_12832());
                Path sourceNether = path.resolve("DIM-1");
                Path sourceEnd = path.resolve("DIM1");
                ImportWorld.copyFolder(sourceNether, targetNether);
                ImportWorld.copyFolder(sourceEnd, targetEnd);
            }
            targetOverworld.toFile().mkdirs();
            ImportWorld.copyFolder(path.resolve(DATA), targetOverworld.resolve(DATA));
            ImportWorld.copyFolder(path.resolve(POI), targetOverworld.resolve(POI));
            ImportWorld.copyFolder(path.resolve(ENTITIES), targetOverworld.resolve(ENTITIES));
            ImportWorld.copyFolder(path.resolve(REGION), targetOverworld.resolve(REGION));
            source.method_9226(() -> class_2561.method_43470((String)"Copied save files."), false);
        }
        catch (Exception e) {
            e.printStackTrace();
            ImportWorld.rollbackWorld();
            throw ERR_SAVE.create();
        }
        for (Map.Entry entry : worldGenSettings.comp_1020().comp_1014().entrySet()) {
            String imported;
            class_5321 registryKey = null;
            switch (imported = ((class_5321)entry.getKey()).method_29177().method_12832()) {
                case "overworld": {
                    registryKey = class_5321.method_29179((class_5321)class_7924.field_41224, (class_2960)id);
                    break;
                }
                case "the_nether": {
                    if (isSinglet) break;
                    registryKey = class_5321.method_29179((class_5321)class_7924.field_41224, (class_2960)var4_14);
                    break;
                }
                case "the_end": {
                    if (isSinglet) break;
                    registryKey = class_5321.method_29179((class_5321)class_7924.field_41224, (class_2960)idEnd);
                }
            }
            if (registryKey == null) continue;
            newDimensions.put((class_5321<class_5363>)registryKey, (class_5363)entry.getValue());
        }
        source.method_9226(() -> class_2561.method_43470((String)"Dimension options stored."), false);
        source.method_9226(() -> class_2561.method_43470((String)"Now you can restart to apply all changes."), false);
        if (!source.method_9211().method_3816()) {
            source.method_9226(() -> class_2561.method_43470((String)"DO NOT ENTER THIS WORLD AGAIN BEFORE RESTARTING YOUR GAME OR YOUR SAVE WOULD BE DESTROYED!!!"), false);
        }
        return 1;
    }

    static {
        newDimensions = new HashMap();
        deletedDimensions = new HashSet();
        firstType = true;
        ERR_DIMENSION_EXIST = new SimpleCommandExceptionType((Message)new LiteralMessage("A dimension with such ID already exists!"));
        ERR_NAMESPACE_EXIST = new SimpleCommandExceptionType((Message)new LiteralMessage("Currently we only accept new namespaces, otherwise collision happens."));
        ERR_FOLDER_NOT_EXIST = new SimpleCommandExceptionType((Message)new LiteralMessage("A folder with that path does not exist!"));
        ERR_LEVEL_NOT_EXIST = new SimpleCommandExceptionType((Message)new LiteralMessage("No level.dat was found!"));
        ERR_FAIL_TO_READ_LEVEL = new SimpleCommandExceptionType((Message)new LiteralMessage("Failed to read level.dat!"));
        ERR_WORLD_GEN = new SimpleCommandExceptionType((Message)new LiteralMessage("Failed to fetch WorldGenSettings!"));
        ERR_PLAYER = new SimpleCommandExceptionType((Message)new LiteralMessage("Failed to fetch player data!"));
        ERR_SAVE = new SimpleCommandExceptionType((Message)new LiteralMessage("Failed to copy save files!"));
    }
}

