/*
 * Decompiled with CFR 0.152.
 */
package io.silvicky.item;

import io.silvicky.item.ItemStorage;
import io.silvicky.item.StateSaver;
import io.silvicky.item.cfg.JSONConfig;
import java.util.Iterator;
import net.minecraft.class_1934;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2596;
import net.minecraft.class_2668;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5321;
import net.minecraft.class_5454;
import net.minecraft.class_7225;
import net.minecraft.server.MinecraftServer;

public class InventoryManager {
    public static final String DIMENSION = "dimension";
    public static final String PLAYER = "player";
    public static final String INVENTORY = "inventory";
    public static final String ENDER = "ender";
    public static final String XP = "xp";
    public static final String HP = "hp";
    public static final String FOOD = "food";
    public static final String AIR = "air";
    public static final String FOOD2 = "food2";
    public static final String GAMEMODE = "gamemode";
    public static final String REAL_DIMENSION = "rdim";
    public static final String POS = "pos";
    public static final String OVERWORLD = "overworld";
    public static final String NETHER = "the_nether";
    public static final String END = "the_end";
    public static final String MC = "minecraft";

    public static String getDimensionId(class_3218 world) {
        Object id = world.method_27983().method_29177().toString();
        if (((String)id).endsWith(NETHER)) {
            id = ((String)id).substring(0, ((String)id).length() - 10) + OVERWORLD;
        }
        if (((String)id).endsWith(END)) {
            id = ((String)id).substring(0, ((String)id).length() - 7) + OVERWORLD;
        }
        return id;
    }

    public static class_2487 V3dToNbt(class_243 v) {
        class_2487 ret = new class_2487();
        ret.method_10549("x", v.field_1352);
        ret.method_10549("y", v.field_1351);
        ret.method_10549("z", v.field_1350);
        return ret;
    }

    public static class_243 NbtToV3d(class_2487 n) {
        return new class_243(n.method_10574("x"), n.method_10574("y"), n.method_10574("z"));
    }

    public static class_2338 transLoc(class_2338 sp, class_3218 sw) {
        while (!sw.method_8320(sp).method_26215() || !sw.method_8320(sp.method_10084()).method_26215()) {
            sp = sp.method_10074();
        }
        while (sw.method_8320(sp.method_10074()).method_26215() && sp.method_10264() > sw.method_31607()) {
            sp = sp.method_10074();
        }
        if (sp.method_10264() == sw.method_31607()) {
            sp = sp.method_33096(sw.method_32819());
            ItemStorage.LOGGER.warn("Spawn point not found!");
        }
        return sp;
    }

    public static void savePos(class_3222 player, StateSaver stateSaver) {
        class_2487 pos = new class_2487();
        pos.method_10582(PLAYER, player.method_5845());
        pos.method_10582(DIMENSION, InventoryManager.getDimensionId(player.method_51469()));
        pos.method_10582(REAL_DIMENSION, player.method_51469().method_27983().method_29177().toString());
        pos.method_10566(POS, (class_2520)InventoryManager.V3dToNbt(player.method_19538()));
        stateSaver.posList.add((Object)pos);
    }

    public static void saveInventory(MinecraftServer server, class_3222 player, StateSaver stateSaver) {
        class_2487 sav = new class_2487();
        sav.method_10582(PLAYER, player.method_5845());
        sav.method_10582(DIMENSION, player.method_51469().method_27983().method_29177().method_12836());
        class_2499 pi = new class_2499();
        player.method_31548().method_7384(pi);
        sav.method_10566(INVENTORY, (class_2520)pi);
        sav.method_10566(ENDER, (class_2520)player.method_7274().method_7660((class_7225.class_7874)server.method_30611()));
        sav.method_10569(XP, player.field_7495);
        sav.method_10548(HP, player.method_6032());
        sav.method_10569(FOOD, player.method_7344().method_7586());
        sav.method_10548(FOOD2, player.method_7344().method_7589());
        sav.method_10569(AIR, player.method_5669());
        sav.method_10569(GAMEMODE, player.field_13974.method_14257().method_8379());
        stateSaver.nbtList.add((Object)sav);
        player.method_31548().method_5448();
        player.method_7274().method_5448();
        player.method_14228(0);
        player.method_6033(20.0f);
        player.method_7344().method_7580(20);
        player.method_7344().method_7581(5.0f);
        player.field_13974.method_30118(class_1934.field_9215);
        player.field_13987.method_14364((class_2596)new class_2668(class_2668.field_25648, (float)class_1934.field_9215.method_8379()));
    }

    public static boolean loadPos(MinecraftServer server, class_3222 player, class_3218 targetDimension, StateSaver stateSaver) {
        targetDimension = InventoryManager.toOverworld(server, targetDimension);
        Iterator iterator = stateSaver.posList.iterator();
        class_2487 n = null;
        while (iterator.hasNext()) {
            class_2487 nt = (class_2487)iterator.next();
            if (!nt.method_10558(PLAYER).equals(player.method_5845()) || !nt.method_10558(DIMENSION).equals(InventoryManager.getDimensionId(targetDimension))) continue;
            iterator.remove();
            ItemStorage.LOGGER.info("Fetched position data!");
            if (n != null) {
                ItemStorage.LOGGER.warn("Duplicated data found! Discarding old data, but this should not happen...");
            }
            n = nt;
        }
        if (n == null) {
            ItemStorage.LOGGER.info("Entering a new world... Good luck to the pioneer!");
            class_2338 sp = InventoryManager.transLoc(targetDimension.method_43126().method_33096(targetDimension.method_32819() - 1), targetDimension);
            class_5454.class_9823 postDimensionTransition = class_5454.field_52245;
            class_5454 target = new class_5454(targetDimension, sp.method_46558(), class_243.field_1353, 0.0f, 0.0f, postDimensionTransition);
            player.method_61275(target);
        } else {
            String dim = n.method_10558(REAL_DIMENSION);
            class_3218 sw2 = server.method_3847(class_5321.method_29179((class_5321)class_5321.method_29180((class_2960)targetDimension.method_27983().method_41185()), (class_2960)class_2960.method_60655((String)targetDimension.method_27983().method_29177().method_12836(), (String)dim.substring(dim.indexOf(":") + 1))));
            if (sw2 == null) {
                ItemStorage.LOGGER.error("A dimension named " + dim + " is NOT FOUND!");
                return false;
            }
            class_243 v3d = InventoryManager.NbtToV3d((class_2487)n.method_10580(POS));
            class_2338 sp = new class_2338((int)Math.floor(v3d.field_1352), (int)Math.floor(v3d.field_1351), (int)Math.floor(v3d.field_1350));
            class_5454.class_9823 postDimensionTransition = class_5454.field_52245;
            class_5454 target = new class_5454(sw2, sp.method_46558(), class_243.field_1353, 0.0f, 0.0f, postDimensionTransition);
            player.method_61275(target);
        }
        return true;
    }

    public static void loadInventory(MinecraftServer server, class_3222 player, class_3218 targetDimension, StateSaver stateSaver) {
        Iterator iterator = stateSaver.nbtList.iterator();
        class_2487 n = null;
        while (iterator.hasNext()) {
            class_2487 nt = (class_2487)iterator.next();
            if (!nt.method_10558(PLAYER).equals(player.method_5845()) || !nt.method_10558(DIMENSION).equals(targetDimension.method_27983().method_29177().method_12836())) continue;
            iterator.remove();
            ItemStorage.LOGGER.info("Fetched inventory!");
            if (n != null) {
                ItemStorage.LOGGER.warn("Duplicated data found! Discarding old data, but this should not happen...");
            }
            n = nt;
        }
        if (n != null) {
            player.method_31548().method_7397((class_2499)n.method_10580(INVENTORY));
            player.method_7274().method_7659((class_2499)n.method_10580(ENDER), (class_7225.class_7874)server.method_30611());
            player.method_14228(n.method_10550(XP));
            player.method_6033(n.method_10583(HP));
            player.method_7344().method_7580(n.method_10550(FOOD));
            player.method_7344().method_7581(n.method_10583(FOOD2));
            player.method_5855(n.method_10550(AIR));
            player.field_13974.method_30118(class_1934.method_8384((int)n.method_10550(GAMEMODE)));
            player.field_13987.method_14364((class_2596)new class_2668(class_2668.field_25648, (float)n.method_10550(GAMEMODE)));
        } else {
            player.method_31548().method_5448();
            player.method_7274().method_5448();
            player.method_14228(0);
            player.method_6033(20.0f);
            player.method_7344().method_7580(20);
            player.method_7344().method_7581(20.0f);
            player.method_5855(300);
            player.field_13974.method_30118(class_1934.field_9215);
            player.field_13987.method_14364((class_2596)new class_2668(class_2668.field_25648, (float)class_1934.field_9215.method_8379()));
        }
    }

    public static class_3218 toOverworld(MinecraftServer server, class_3218 world) {
        String overworldId = InventoryManager.getDimensionId(world);
        class_3218 sw = server.method_3847(class_5321.method_29179((class_5321)class_5321.method_29180((class_2960)world.method_27983().method_41185()), (class_2960)class_2960.method_60655((String)world.method_27983().method_29177().method_12836(), (String)overworldId.substring(overworldId.indexOf(":") + 1))));
        return sw != null ? sw : world;
    }

    public static void save(MinecraftServer server, class_3222 player) {
        StateSaver stateSaver = StateSaver.getServerState(server);
        InventoryManager.savePos(player, stateSaver);
        if (JSONConfig.useStorage.booleanValue()) {
            InventoryManager.saveInventory(server, player, stateSaver);
        }
    }

    public static boolean load(MinecraftServer server, class_3222 player, class_3218 targetDimension) {
        StateSaver stateSaver = StateSaver.getServerState(server);
        if (JSONConfig.useStorage.booleanValue()) {
            InventoryManager.loadInventory(server, player, targetDimension, stateSaver);
        }
        return InventoryManager.loadPos(server, player, targetDimension, stateSaver);
    }

    public static boolean directWarp(MinecraftServer server, class_3222 player, class_3218 targetDimension) {
        StateSaver stateSaver = StateSaver.getServerState(server);
        InventoryManager.savePos(player, stateSaver);
        return InventoryManager.loadPos(server, player, targetDimension, stateSaver);
    }
}

