/*
 * Decompiled with CFR 0.152.
 */
package io.silvicky.item.command.warp;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import io.silvicky.item.StateSaver;
import io.silvicky.item.common.Util;
import java.util.HashMap;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2181;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3218;

public class BanWarp {
    public static void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"banwarp").requires(context -> context.method_9259(2))).executes(context -> BanWarp.help((class_2168)context.getSource()))).then(class_2170.method_9247((String)"ban").then(((RequiredArgumentBuilder)class_2170.method_9244((String)"dimension", (ArgumentType)class_2181.method_9288()).executes(ctx -> BanWarp.banWarp((class_2168)ctx.getSource(), class_2181.method_9289((CommandContext)ctx, (String)"dimension")))).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"level", (ArgumentType)IntegerArgumentType.integer()).executes(ctx -> BanWarp.banWarp((class_2168)ctx.getSource(), class_2181.method_9289((CommandContext)ctx, (String)"dimension"), IntegerArgumentType.getInteger((CommandContext)ctx, (String)"level")))).then(class_2170.method_9244((String)"reason", (ArgumentType)StringArgumentType.greedyString()).executes(ctx -> BanWarp.banWarp((class_2168)ctx.getSource(), class_2181.method_9289((CommandContext)ctx, (String)"dimension"), IntegerArgumentType.getInteger((CommandContext)ctx, (String)"level"), StringArgumentType.getString((CommandContext)ctx, (String)"reason")))))))).then(class_2170.method_9247((String)"bangroup").then(((RequiredArgumentBuilder)class_2170.method_9244((String)"dimension", (ArgumentType)class_2181.method_9288()).executes(ctx -> BanWarp.banGroup((class_2168)ctx.getSource(), class_2181.method_9289((CommandContext)ctx, (String)"dimension")))).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"level", (ArgumentType)IntegerArgumentType.integer()).executes(ctx -> BanWarp.banGroup((class_2168)ctx.getSource(), class_2181.method_9289((CommandContext)ctx, (String)"dimension"), IntegerArgumentType.getInteger((CommandContext)ctx, (String)"level")))).then(class_2170.method_9244((String)"reason", (ArgumentType)StringArgumentType.greedyString()).executes(ctx -> BanWarp.banGroup((class_2168)ctx.getSource(), class_2181.method_9289((CommandContext)ctx, (String)"dimension"), IntegerArgumentType.getInteger((CommandContext)ctx, (String)"level"), StringArgumentType.getString((CommandContext)ctx, (String)"reason")))))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"banall").executes(ctx -> BanWarp.banAll((class_2168)ctx.getSource()))).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"level", (ArgumentType)IntegerArgumentType.integer()).executes(ctx -> BanWarp.banAll((class_2168)ctx.getSource(), IntegerArgumentType.getInteger((CommandContext)ctx, (String)"level")))).then(class_2170.method_9244((String)"reason", (ArgumentType)StringArgumentType.greedyString()).executes(ctx -> BanWarp.banAll((class_2168)ctx.getSource(), IntegerArgumentType.getInteger((CommandContext)ctx, (String)"level"), StringArgumentType.getString((CommandContext)ctx, (String)"reason"))))))).then(class_2170.method_9247((String)"lift").then(class_2170.method_9244((String)"dimension", (ArgumentType)class_2181.method_9288()).executes(ctx -> BanWarp.liftBan((class_2168)ctx.getSource(), class_2181.method_9289((CommandContext)ctx, (String)"dimension")))))).then(class_2170.method_9247((String)"liftgroup").then(class_2170.method_9244((String)"dimension", (ArgumentType)class_2181.method_9288()).executes(ctx -> BanWarp.liftGroup((class_2168)ctx.getSource(), class_2181.method_9289((CommandContext)ctx, (String)"dimension")))))).then(class_2170.method_9247((String)"liftall").executes(ctx -> BanWarp.liftAll((class_2168)ctx.getSource()))));
    }

    private static int help(class_2168 source) {
        source.method_9226(() -> class_2561.method_43470((String)"Usage:"), false);
        source.method_9226(() -> class_2561.method_43470((String)"/banwarp (ban|bangroup) <dimension> [<level>] [<reason>]"), false);
        source.method_9226(() -> class_2561.method_43470((String)"Ban warp to world/group of <dimension>."), false);
        source.method_9226(() -> class_2561.method_43470((String)"/banwarp (lift|liftgroup) <dimension>"), false);
        source.method_9226(() -> class_2561.method_43470((String)"Lift ban on world/group of <dimension>."), false);
        source.method_9226(() -> class_2561.method_43470((String)"/banwarp banall [<level>] [<reason>]"), false);
        source.method_9226(() -> class_2561.method_43470((String)"/banwarp liftall"), false);
        source.method_9226(() -> class_2561.method_43470((String)"Ban/lift all."), false);
        return 1;
    }

    public static int banWarp(class_2168 source, class_3218 dimension) {
        return BanWarp.banWarp(source, dimension, Integer.MAX_VALUE);
    }

    public static int banWarp(class_2168 source, class_3218 dimension, int level) {
        return BanWarp.banWarp(source, dimension, level, "no reason specified");
    }

    public static int banWarp(class_2168 source, class_3218 dimension, int level, String reason) {
        return BanWarp.banWarp(source, dimension, level, reason, false);
    }

    public static int banWarp(class_2168 source, class_3218 dimension, int level, String reason, boolean silent) {
        StateSaver stateSaver = StateSaver.getServerState(source.method_9211());
        HashMap<class_2960, StateSaver.WarpRestrictionInfo> restrictionInfoHashMap = stateSaver.restrictionInfoHashMap;
        restrictionInfoHashMap.put(class_2960.method_60654((String)Util.getDimensionId(dimension)), new StateSaver.WarpRestrictionInfo(reason, level));
        if (!silent) {
            source.method_9226(() -> class_2561.method_43470((String)("Banned warp to world of " + String.valueOf(dimension.method_27983().method_29177()) + " for level lower than " + level + ", reason: " + reason)), false);
        }
        return 1;
    }

    public static int liftBan(class_2168 source, class_3218 dimension) {
        return BanWarp.liftBan(source, dimension, false);
    }

    public static int liftBan(class_2168 source, class_3218 dimension, boolean silent) {
        StateSaver stateSaver = StateSaver.getServerState(source.method_9211());
        HashMap<class_2960, StateSaver.WarpRestrictionInfo> restrictionInfoHashMap = stateSaver.restrictionInfoHashMap;
        restrictionInfoHashMap.remove(class_2960.method_60654((String)Util.getDimensionId(dimension)));
        if (!silent) {
            source.method_9226(() -> class_2561.method_43470((String)("Lifted ban on warp to world of " + String.valueOf(dimension.method_27983().method_29177()))), false);
        }
        return 1;
    }

    public static int liftAll(class_2168 source) {
        StateSaver stateSaver = StateSaver.getServerState(source.method_9211());
        HashMap<class_2960, StateSaver.WarpRestrictionInfo> restrictionInfoHashMap = stateSaver.restrictionInfoHashMap;
        restrictionInfoHashMap.clear();
        source.method_9226(() -> class_2561.method_43470((String)"Lifted all ban on warp."), false);
        return 1;
    }

    public static int liftGroup(class_2168 source, class_3218 dimension) {
        for (class_3218 world : source.method_9211().method_3738()) {
            if (!world.method_27983().method_29177().method_12836().equals(dimension.method_27983().method_29177().method_12836())) continue;
            BanWarp.liftBan(source, world, true);
        }
        source.method_9226(() -> class_2561.method_43470((String)("Lifted ban on warp to " + dimension.method_27983().method_29177().method_12836())), false);
        return 1;
    }

    public static int banAll(class_2168 source) {
        return BanWarp.banAll(source, Integer.MAX_VALUE);
    }

    public static int banAll(class_2168 source, int level) {
        return BanWarp.banAll(source, level, "no reason specified");
    }

    public static int banAll(class_2168 source, int level, String reason) {
        for (class_3218 world : source.method_9211().method_3738()) {
            BanWarp.banWarp(source, world, level, reason, true);
        }
        source.method_9226(() -> class_2561.method_43470((String)("Banned all warp for level lower than " + level + ", reason: " + reason)), false);
        return 1;
    }

    public static int banGroup(class_2168 source, class_3218 dimension) {
        return BanWarp.banGroup(source, dimension, Integer.MAX_VALUE);
    }

    public static int banGroup(class_2168 source, class_3218 dimension, int level) {
        return BanWarp.banGroup(source, dimension, level, "no reason specified");
    }

    public static int banGroup(class_2168 source, class_3218 dimension, int level, String reason) {
        for (class_3218 world : source.method_9211().method_3738()) {
            if (!world.method_27983().method_29177().method_12836().equals(dimension.method_27983().method_29177().method_12836())) continue;
            BanWarp.banWarp(source, world, level, reason, true);
        }
        source.method_9226(() -> class_2561.method_43470((String)("Banned warp to " + dimension.method_27983().method_29177().method_12836() + " for level lower than " + level + ", reason: " + reason)), false);
        return 1;
    }
}

