/*
 * Decompiled with CFR 0.152.
 */
package io.silvicky.item.common;

import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.LiteralMessage;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.datafixers.util.Pair;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Stream;
import net.minecraft.class_11352;
import net.minecraft.class_11368;
import net.minecraft.class_1661;
import net.minecraft.class_1730;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2505;
import net.minecraft.class_2507;
import net.minecraft.class_2512;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3551;
import net.minecraft.class_4284;
import net.minecraft.class_4844;
import net.minecraft.class_5321;
import net.minecraft.class_7225;
import net.minecraft.class_7924;
import net.minecraft.class_8792;
import net.minecraft.class_8942;
import net.minecraft.class_9288;
import net.minecraft.class_9326;
import net.minecraft.class_9331;
import net.minecraft.class_9334;
import net.minecraft.class_9336;
import net.minecraft.server.MinecraftServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Util {
    public static final String DIMENSION_ID = "dimension_id";
    public static final String DIMENSION_PATH = "path";
    public static final String DATA = "data";
    public static final String POI = "poi";
    public static final String REGION = "region";
    public static final String ENTITIES = "entities";
    public static final String INVENTORY = "inventory";
    public static final String SAVED = "saved";
    public static final String ENDER = "ender";
    public static final String SLOT = "Slot";
    public static final String LEVEL = "level";
    public static final String REASON = "reason";
    public static final String DIMENSION = "dimension";
    public static final String PLAYER = "player";
    public static final String OVERWORLD = "overworld";
    public static final String NETHER = "the_nether";
    public static final String END = "the_end";
    public static final String CORD = "coordination";
    public static final String TARGET = "target";
    public static final String MOD_ID = "ItemStorage";
    public static final class_2561 INVENTORY_ITEMS = class_2561.method_43470((String)"Inventory Items");
    public static final class_2561 ENDER_ITEMS = class_2561.method_43470((String)"Ender Items");
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"item-storage");
    public static final int playerInventorySize = 41;
    public static final int chestSize = 27;
    public static final SimpleCommandExceptionType ERR_DIMENSION_NOT_FOUND = new SimpleCommandExceptionType((Message)new LiteralMessage("Target dimension NOT FOUND!"));
    public static final SimpleCommandExceptionType ERR_ITEM = new SimpleCommandExceptionType((Message)new LiteralMessage("Item stack error(from version change, contact your admin)!"));
    public static final SimpleCommandExceptionType ERR_NOT_BY_PLAYER = new SimpleCommandExceptionType((Message)new LiteralMessage("This command must be executed by a player."));
    public static final SimpleCommandExceptionType ERR_NOT_ONE_PLAYER = new SimpleCommandExceptionType((Message)new LiteralMessage("Amount of player selected must be exactly one."));
    public static final DynamicCommandExceptionType ERR_WARP_FORBIDDEN = new DynamicCommandExceptionType((Function)new Function<Object, Message>(){

        @Override
        public Message apply(Object o) {
            return new LiteralMessage("Warp forbidden! Reason: " + String.valueOf(o));
        }
    });
    public static final SimpleCommandExceptionType ERR_DIMENSION_EXIST = new SimpleCommandExceptionType((Message)new LiteralMessage("A dimension with such ID already exists!"));
    public static final SimpleCommandExceptionType ERR_NAMESPACE_EXIST = new SimpleCommandExceptionType((Message)new LiteralMessage("Currently we only accept new namespaces, otherwise collision happens."));
    public static final SimpleCommandExceptionType ERR_FOLDER_NOT_EXIST = new SimpleCommandExceptionType((Message)new LiteralMessage("A folder with that path does not exist!"));
    public static final SimpleCommandExceptionType ERR_LEVEL_NOT_EXIST = new SimpleCommandExceptionType((Message)new LiteralMessage("No level.dat was found!"));
    public static final SimpleCommandExceptionType ERR_FAIL_TO_READ_LEVEL = new SimpleCommandExceptionType((Message)new LiteralMessage("Failed to read level.dat!"));
    public static final SimpleCommandExceptionType ERR_WORLD_GEN = new SimpleCommandExceptionType((Message)new LiteralMessage("Failed to fetch WorldGenSettings!"));
    public static final SimpleCommandExceptionType ERR_PLAYER = new SimpleCommandExceptionType((Message)new LiteralMessage("Failed to fetch player data!"));
    public static final SimpleCommandExceptionType ERR_SAVE = new SimpleCommandExceptionType((Message)new LiteralMessage("Failed to copy save files!"));

    public static void deleteFolder(Path path) throws IOException {
        if (!path.toFile().exists()) {
            return;
        }
        Files.walkFileTree(path, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                Files.delete(file);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                Files.delete(dir);
                return FileVisitResult.CONTINUE;
            }
        });
    }

    public static void copyFolder(Path src, Path dest) throws IOException {
        try (Stream<Path> stream = Files.walk(src, new FileVisitOption[0]);){
            stream.forEach(source -> {
                try {
                    Files.copy(source, dest.resolve(src.relativize((Path)source)), StandardCopyOption.REPLACE_EXISTING);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            });
        }
    }

    public static class_3222 loadFakePlayer(class_2487 compound, MinecraftServer server) {
        class_8792 connectedClientData = class_8792.method_53824((GameProfile)new GameProfile((UUID)compound.method_67491("UUID", class_4844.field_25122).orElseThrow(), "tmp"), (boolean)false);
        class_3218 world = server.method_3847(class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)class_2960.method_60654((String)compound.method_68564("Dimension", server.method_30002().method_27983().method_29177().toString()))));
        if (world == null) {
            world = server.method_30002();
        }
        class_3222 serverPlayerEntity = new class_3222(server, world, connectedClientData.comp_1959(), connectedClientData.comp_1961());
        class_8942.class_11340 logging = new class_8942.class_11340(serverPlayerEntity.method_71370(), LOGGER);
        class_11368 readView = class_11352.method_71417((class_8942)logging, (class_7225.class_7874)serverPlayerEntity.method_56673(), (class_2487)compound);
        serverPlayerEntity.method_5651(readView);
        serverPlayerEntity.method_32748(readView);
        return serverPlayerEntity;
    }

    public static class_3222 loadFakePlayer(Path path, MinecraftServer server) throws IOException {
        class_2487 nbtCompound = class_2507.method_30613((Path)path, (class_2505)class_2505.method_53898());
        nbtCompound = class_4284.field_19213.method_48130(class_3551.method_15450(), nbtCompound, class_2512.method_48309((class_2487)nbtCompound, (int)-1));
        return Util.loadFakePlayer(nbtCompound, server);
    }

    public static String getDimensionId(class_3218 world) {
        return Util.getDimensionId(world.method_27983().method_29177().toString());
    }

    public static String getDimensionId(String id) {
        if (((String)id).endsWith(NETHER)) {
            id = ((String)id).substring(0, ((String)id).length() - NETHER.length()) + OVERWORLD;
        }
        if (((String)id).endsWith(END)) {
            id = ((String)id).substring(0, ((String)id).length() - END.length()) + OVERWORLD;
        }
        return id;
    }

    public static class_2338 transLoc(class_2338 sp, class_3218 sw) {
        while (!sw.method_8320(sp).method_26215() || !sw.method_8320(sp.method_10084()).method_26215()) {
            sp = sp.method_10074();
        }
        while (sw.method_8320(sp.method_10074()).method_26215() && sp.method_10264() > sw.method_31607()) {
            sp = sp.method_10074();
        }
        if (sp.method_10264() == sw.method_31607()) {
            sp = sp.method_33096(sw.method_32819());
            LOGGER.warn("Spawn point not found!");
        }
        return sp;
    }

    public static List<String> getListOfPlayers(MinecraftServer server, String dimension) {
        List players = server.method_3760().method_14571();
        ArrayList<String> ret = new ArrayList<String>();
        for (class_3222 player : players) {
            if (!Util.getDimensionId(player.method_51469()).equals(dimension)) continue;
            ret.add(player.method_5477().getString());
        }
        return ret;
    }

    public static <T> String listToString(List<T> list) {
        StringBuilder tot = new StringBuilder();
        boolean first = true;
        for (T t : list) {
            if (!first) {
                tot.append(", ");
            }
            tot.append(t.toString());
        }
        return tot.toString();
    }

    public static ArrayList<Pair<class_1799, Byte>> inventoryToStack(class_1661 inventory) {
        ArrayList<Pair<class_1799, Byte>> ret = new ArrayList<Pair<class_1799, Byte>>();
        for (int i = 0; i < 41; ++i) {
            if (inventory.method_5438(i).method_7960()) continue;
            ret.add((Pair<class_1799, Byte>)new Pair((Object)inventory.method_5438(i), (Object)((byte)i)));
        }
        return ret;
    }

    public static ArrayList<Pair<class_1799, Byte>> enderToStack(class_1730 inventory) {
        ArrayList<Pair<class_1799, Byte>> ret = new ArrayList<Pair<class_1799, Byte>>();
        for (int i = 0; i < inventory.method_5439(); ++i) {
            class_1799 itemStack = inventory.method_5438(i);
            if (itemStack.method_7960()) continue;
            ret.add((Pair<class_1799, Byte>)new Pair((Object)itemStack, (Object)((byte)i)));
        }
        return ret;
    }

    public static void stackToInventory(class_1661 inventory, List<Pair<class_1799, Byte>> stack) {
        inventory.method_5448();
        for (Pair<class_1799, Byte> pair : stack) {
            byte j = (Byte)pair.getSecond();
            class_1799 itemStack = (class_1799)pair.getFirst();
            if (j >= 41) continue;
            inventory.method_5447((int)j, itemStack);
        }
    }

    public static void stackToEnder(class_1730 inventory, List<Pair<class_1799, Byte>> stack) {
        inventory.method_5448();
        for (Pair<class_1799, Byte> pair : stack) {
            byte j = (Byte)pair.getSecond();
            if (j >= inventory.method_5439()) continue;
            inventory.method_5447((int)j, (class_1799)pair.getFirst());
        }
    }

    public static class_3218 toOverworld(MinecraftServer server, class_3218 world) {
        String overworldId = Util.getDimensionId(world);
        class_3218 sw = server.method_3847(class_5321.method_29179((class_5321)class_5321.method_29180((class_2960)world.method_27983().method_41185()), (class_2960)class_2960.method_60655((String)world.method_27983().method_29177().method_12836(), (String)overworldId.substring(overworldId.indexOf(":") + 1))));
        return sw != null ? sw : world;
    }

    public static ArrayList<Pair<class_1799, Byte>> enId(List<class_1799> source) {
        ArrayList<Pair<class_1799, Byte>> ret = new ArrayList<Pair<class_1799, Byte>>();
        for (byte i = 0; i < source.size(); i = (byte)(i + 1)) {
            ret.add((Pair<class_1799, Byte>)new Pair((Object)source.get(i), (Object)i));
        }
        return ret;
    }

    public static ArrayList<class_1799> deId(List<Pair<class_1799, Byte>> source) {
        ArrayList<class_1799> ret = new ArrayList<class_1799>();
        for (Pair<class_1799, Byte> i : source) {
            ret.add((class_1799)i.getFirst());
        }
        return ret;
    }

    public static class_1799 packMono(List<class_1799> source, class_2561 name) {
        class_1799 ret = new class_1799((class_1935)class_1802.field_8106);
        ret.method_59692(class_9326.method_57841().method_57855(class_9336.method_57945((class_9331)class_9334.field_49622, (Object)class_9288.method_57493(source))).method_57852());
        ret.method_59692(class_9326.method_57841().method_57855(class_9336.method_57945((class_9331)class_9334.field_49631, (Object)name)).method_57852());
        return ret;
    }

    public static ArrayList<class_1799> pack(List<class_1799> source, class_2561 name) {
        ArrayList<class_1799> ret = new ArrayList<class_1799>();
        for (int bas = 0; bas < source.size(); bas = (int)((byte)(bas + 27))) {
            ArrayList<class_1799> tmp = new ArrayList<class_1799>();
            for (int i = bas; i < bas + 27 && i < source.size(); i = (int)((byte)(i + 1))) {
                tmp.add(source.get(i));
            }
            ret.add(Util.packMono(tmp, name));
        }
        return ret;
    }

    public static void sendToAllInWorld(class_3218 world, class_2596<?> packet) {
        for (class_3222 player : world.method_18456()) {
            player.field_13987.method_14364(packet);
        }
    }
}

