/*
 * Decompiled with CFR 0.152.
 */
package io.silvicky.item;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_10741;
import net.minecraft.class_1799;
import net.minecraft.class_18;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_26;
import net.minecraft.class_2881;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_4284;
import net.minecraft.server.MinecraftServer;

public class StateSaver
extends class_18 {
    public final ArrayList<StorageInfo> nbtList;
    public final ArrayList<PositionInfo> posList;
    public final HashMap<class_2960, class_2881.class_8576> dragonFight;
    public final HashMap<class_2960, WarpRestrictionInfo> restrictionInfoHashMap;
    public final HashMap<class_2960, Long> seed;
    public static final Codec<StateSaver> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)StorageInfo.CODEC.listOf().xmap(ArrayList::new, list -> list).fieldOf("saved").orElse(new ArrayList()).forGetter(stateSaver -> stateSaver.nbtList), (App)PositionInfo.CODEC.listOf().xmap(ArrayList::new, list -> list).fieldOf("pos").orElse(new ArrayList()).forGetter(stateSaver -> stateSaver.posList), (App)Codec.unboundedMap((Codec)class_2960.field_25139, (Codec)class_2881.class_8576.field_44945).xmap(HashMap::new, map -> map).fieldOf("dragon").orElse(new HashMap()).forGetter(stateSaver -> stateSaver.dragonFight), (App)Codec.unboundedMap((Codec)class_2960.field_25139, (Codec)Codec.LONG).xmap(HashMap::new, map -> map).fieldOf("seed").orElse(new HashMap()).forGetter(stateSaver -> stateSaver.seed), (App)Codec.unboundedMap((Codec)class_2960.field_25139, WarpRestrictionInfo.CODEC).xmap(HashMap::new, map -> map).fieldOf("restriction").orElse(new HashMap()).forGetter(stateSaver -> stateSaver.restrictionInfoHashMap)).apply((Applicative)instance, StateSaver::new));
    private static final class_10741<StateSaver> type = new class_10741("ItemStorage", StateSaver::new, CODEC, class_4284.field_19213);

    public StateSaver(ArrayList<StorageInfo> nbtList, ArrayList<PositionInfo> posList, HashMap<class_2960, class_2881.class_8576> dragonFight, HashMap<class_2960, Long> seed, HashMap<class_2960, WarpRestrictionInfo> restrictionInfoHashMap) {
        this.nbtList = nbtList;
        this.posList = posList;
        this.dragonFight = dragonFight;
        this.seed = seed;
        this.restrictionInfoHashMap = restrictionInfoHashMap;
    }

    public StateSaver() {
        this(new ArrayList<StorageInfo>(), new ArrayList<PositionInfo>(), new HashMap<class_2960, class_2881.class_8576>(), new HashMap<class_2960, Long>(), new HashMap<class_2960, WarpRestrictionInfo>());
    }

    public static StateSaver getServerState(MinecraftServer server) {
        return StateSaver.getServerState(Objects.requireNonNull(server.method_3847(class_1937.field_25179)));
    }

    public static StateSaver getServerState(class_3218 world) {
        class_26 persistentStateManager = world.method_17983();
        StateSaver state = (StateSaver)persistentStateManager.method_17924(type);
        state.method_80();
        return state;
    }

    public static class StorageInfo {
        public String player;
        public String dimension;
        public ArrayList<Pair<class_1799, Byte>> inventory;
        public ArrayList<Pair<class_1799, Byte>> ender;
        public int xp;
        public float hp;
        public int food;
        public float food2;
        public int air;
        public int gamemode;
        public static final Codec<Pair<class_1799, Byte>> SLOT_CODEC = Codec.pair((Codec)class_1799.field_24671.orElse(null), (Codec)Codec.BYTE.fieldOf("Slot").codec());
        public static final Codec<StorageInfo> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("player").forGetter(info -> info.player), (App)Codec.STRING.fieldOf("dimension").forGetter(info -> info.dimension), (App)SLOT_CODEC.listOf().xmap(StorageInfo::listToArrayList, list -> list).fieldOf("inventory").orElse(new ArrayList()).forGetter(info -> info.inventory), (App)SLOT_CODEC.listOf().xmap(StorageInfo::listToArrayList, list -> list).fieldOf("ender").orElse(new ArrayList()).forGetter(info -> info.ender), (App)Codec.INT.fieldOf("xp").orElse((Object)0).forGetter(info -> info.xp), (App)Codec.FLOAT.fieldOf("hp").orElse((Object)Float.valueOf(20.0f)).forGetter(info -> Float.valueOf(info.hp)), (App)Codec.INT.fieldOf("food").orElse((Object)20).forGetter(info -> info.food), (App)Codec.FLOAT.fieldOf("food2").orElse((Object)Float.valueOf(5.0f)).forGetter(info -> Float.valueOf(info.food2)), (App)Codec.INT.fieldOf("air").orElse((Object)300).forGetter(info -> info.air), (App)Codec.INT.fieldOf("gamemode").orElse((Object)0).forGetter(info -> info.gamemode)).apply((Applicative)instance, StorageInfo::new));

        public StorageInfo(String player, String dimension, ArrayList<Pair<class_1799, Byte>> inventory, ArrayList<Pair<class_1799, Byte>> ender, int xp, float hp, int food, float food2, int air, int gamemode) {
            this.player = player;
            this.dimension = dimension;
            this.inventory = inventory;
            this.ender = ender;
            this.xp = xp;
            this.hp = hp;
            this.food = food;
            this.food2 = food2;
            this.air = air;
            this.gamemode = gamemode;
        }

        public static boolean isNonNull(Object o) {
            if (o == null) {
                return false;
            }
            if (o instanceof Pair) {
                return StorageInfo.isNonNull(((Pair)o).getFirst()) && StorageInfo.isNonNull(((Pair)o).getSecond());
            }
            return true;
        }

        public static <T> ArrayList<T> listToArrayList(List<T> src) {
            ArrayList<T> ret = new ArrayList<T>();
            for (T i : src) {
                if (!StorageInfo.isNonNull(i)) continue;
                ret.add(i);
            }
            return ret;
        }
    }

    public static class PositionInfo {
        public String player;
        public String dimension;
        public String rdim;
        public class_243 pos;
        public static final Codec<class_243> VEC_3_D_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.DOUBLE.fieldOf("x").forGetter(v3d -> v3d.field_1352), (App)Codec.DOUBLE.fieldOf("y").forGetter(v3d -> v3d.field_1351), (App)Codec.DOUBLE.fieldOf("z").forGetter(v3d -> v3d.field_1350)).apply((Applicative)instance, class_243::new));
        public static final Codec<PositionInfo> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("player").forGetter(info -> info.player), (App)Codec.STRING.fieldOf("dimension").forGetter(info -> info.dimension), (App)Codec.STRING.fieldOf("rdim").forGetter(info -> info.rdim), (App)VEC_3_D_CODEC.fieldOf("pos").forGetter(info -> info.pos)).apply((Applicative)instance, PositionInfo::new));

        public PositionInfo(String player, String dimension, String rdim, class_243 pos) {
            this.player = player;
            this.dimension = dimension;
            this.rdim = rdim;
            this.pos = pos;
        }
    }

    public static class WarpRestrictionInfo {
        public String reason;
        public static final String DEFAULT_REASON = "no reason specified";
        public int level;
        public static final int INFINITE = Integer.MAX_VALUE;
        public static final Codec<WarpRestrictionInfo> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("reason").orElse((Object)DEFAULT_REASON).forGetter(info -> info.reason), (App)Codec.INT.fieldOf("level").orElse((Object)Integer.MAX_VALUE).forGetter(info -> info.level)).apply((Applicative)instance, WarpRestrictionInfo::new));

        public WarpRestrictionInfo(String reason, int level) {
            this.reason = reason;
            this.level = level;
        }
    }
}

