/*
 * Decompiled with CFR 0.152.
 */
package io.silvicky.item;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.LiteralMessage;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import io.silvicky.item.InventoryManager;
import io.silvicky.item.ItemStorage;
import io.silvicky.item.StateSaver;
import java.util.Objects;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2181;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3222;

public class Warp {
    public static final SimpleCommandExceptionType ERR_DIMENSION_NOT_FOUND = new SimpleCommandExceptionType((Message)new LiteralMessage("Target dimension NOT FOUND!"));

    public static void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)class_2170.method_9247((String)"warp").then(class_2170.method_9244((String)"dimension", (ArgumentType)class_2181.method_9288()).executes(context -> Warp.warp((class_2168)context.getSource(), class_2181.method_9289((CommandContext)context, (String)"dimension")))));
    }

    public static int warp(class_2168 source, class_3218 dimension) throws CommandSyntaxException {
        class_3222 player = source.method_44023();
        assert (player != null);
        if (!InventoryManager.getDimensionId(dimension).equals(InventoryManager.getDimensionId(source.method_9225()))) {
            ItemStorage.LOGGER.info(Objects.requireNonNull(source.method_44023()).method_5477().getString() + " goes to " + InventoryManager.getDimensionId(dimension));
            if (!dimension.method_27983().method_29177().method_12836().equals(source.method_9225().method_27983().method_29177().method_12836())) {
                player.method_6012();
                InventoryManager.save(source.method_9211(), player);
                if (!InventoryManager.load(source.method_9211(), player, dimension)) {
                    InventoryManager.loadInventory(player, source.method_9225(), StateSaver.getServerState(source.method_9211()));
                    throw ERR_DIMENSION_NOT_FOUND.create();
                }
            } else if (!InventoryManager.directWarp(source.method_9211(), player, dimension)) {
                throw ERR_DIMENSION_NOT_FOUND.create();
            }
            source.method_9226(() -> class_2561.method_43470((String)("Teleported to " + InventoryManager.getDimensionId(dimension) + "!")), false);
        } else {
            source.method_9226(() -> class_2561.method_43470((String)"Nothing happened."), false);
        }
        return 1;
    }
}

