/*
 * Decompiled with CFR 0.152.
 */
package com.playdelphi;

import com.playdelphi.ConfigManager;
import com.playdelphi.DatabaseManager;
import com.playdelphi.DelphiVote;
import com.playdelphi.LanguageManager;
import com.playdelphi.PlayerEnv;
import com.playdelphi.PlayerEnvManager;
import com.playdelphi.RewardManager;
import com.playdelphi.UtilsManager;
import com.playdelphi.VoteManager;
import com.playdelphi.exceptions.PlayerNotFoundException;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Logger;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.ComponentBuilder;
import net.md_5.bungee.api.chat.HoverEvent;
import net.md_5.bungee.api.chat.TextComponent;
import net.md_5.bungee.api.chat.hover.content.Content;
import net.md_5.bungee.api.chat.hover.content.Text;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;

public class CommandManager
implements CommandExecutor {
    private final DelphiVote plugin;
    private Logger logger;
    private ConfigManager configManager;
    private DatabaseManager databaseManager;
    private LanguageManager languageManager;
    private RewardManager rewardManager;
    private UtilsManager utilsManager;
    private VoteManager voteManager;
    private PlayerEnvManager playerEnvManager;

    public CommandManager(DelphiVote plugin) {
        this.plugin = plugin;
        this.configManager = plugin.getConfigManager();
        this.databaseManager = plugin.getDatabaseManager();
        this.languageManager = plugin.getLanguageManager();
        this.logger = plugin.getLogger();
        this.rewardManager = plugin.getRewardManager();
        this.utilsManager = plugin.getUtilsManager();
        this.voteManager = plugin.getVoteManager();
        this.playerEnvManager = plugin.getPlayerEnvManager();
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        try {
            if (!(sender instanceof Player)) {
                sender.sendMessage(this.languageManager.getMessage("player_only_command"));
                return true;
            }
            PlayerEnv playerEnv = this.playerEnvManager.getPlayerEnv((Player)sender);
            if (args.length == 0) {
                return this.handleVoteList(playerEnv);
            }
            switch (args[0]) {
                case "give": {
                    if (args.length > 1) {
                        switch (args[1]) {
                            case "vote": {
                                return this.handleGiveVote(playerEnv, args);
                            }
                            case "reward": {
                                return this.handleGiveReward(playerEnv, args);
                            }
                        }
                    }
                    return false;
                }
                case "help": {
                    return this.handleHelp(playerEnv);
                }
                case "info": {
                    return this.handleInfo(playerEnv);
                }
                case "list": {
                    return this.handleStats(playerEnv, args);
                }
                case "playerenvs": {
                    return this.handleListPlayerEnvs(playerEnv);
                }
                case "reload": {
                    return this.handleReload(playerEnv);
                }
                case "rewards": {
                    return this.handleListRewards(playerEnv);
                }
                case "stats": {
                    return this.handleStats(playerEnv, args);
                }
                case "triggers": {
                    return this.handleListTriggers(playerEnv);
                }
                case "players": {
                    return this.handleListPlayers(playerEnv);
                }
                case "expire": {
                    return this.handleExpireRewards(playerEnv);
                }
            }
            playerEnv.player.sendMessage(this.languageManager.getMessage("no_command"));
            return true;
        }
        catch (PlayerNotFoundException e) {
            sender.sendMessage(this.languageManager.getMessage("player_not_found", Map.of("player", e.getMessage())));
            return true;
        }
        catch (Exception e) {
            this.logger.severe("Catchall exception: " + e.getMessage());
            sender.sendMessage(this.languageManager.getMessage("plugin_error"));
            e.printStackTrace();
            return true;
        }
    }

    private boolean checkPerm(PlayerEnv playerEnv, String minPerm) {
        return this.checkPerm(playerEnv, minPerm, false);
    }

    private boolean checkPerm(PlayerEnv playerEnv, String minPerm, boolean failAlert) {
        String fullPerm = "delphivoting." + minPerm;
        if (minPerm == "admin") {
            if (playerEnv.player.hasPermission(fullPerm)) {
                return true;
            }
            if (failAlert) {
                playerEnv.player.sendMessage(this.languageManager.getMessage("no_permission"));
            }
            return false;
        }
        if (minPerm == "player") {
            if (playerEnv.player.hasPermission(fullPerm) || playerEnv.player.hasPermission("delphivoting.admin")) {
                return true;
            }
            if (failAlert) {
                playerEnv.player.sendMessage(this.languageManager.getMessage("no_permission"));
            }
            return false;
        }
        return false;
    }

    private boolean handleGiveReward(PlayerEnv playerEnv, String[] args) {
        if (this.checkPerm(playerEnv, "admin")) {
            if (args.length <= 3) {
                playerEnv.player.sendMessage(this.languageManager.getMessage("admin_trigger_fail"));
                return false;
            }
            String rewardName = args[2];
            String tgt_playerName = args[3];
            PlayerEnv tgt_playerEnv = this.playerEnvManager.getPlayerEnv(tgt_playerName);
            this.rewardManager.handleRewards(playerEnv, tgt_playerEnv, "Admin", rewardName);
            return true;
        }
        return false;
    }

    private boolean handleGiveVote(PlayerEnv playerEnv, String[] args) {
        if (this.checkPerm(playerEnv, "admin")) {
            if (args.length <= 2) {
                playerEnv.player.sendMessage(this.languageManager.getMessage("give_vote_fail"));
                return false;
            }
            String tgt_playerName = args[2];
            PlayerEnv tgt_playerEnv = this.playerEnvManager.getPlayerEnv(tgt_playerName);
            this.voteManager.handleVote(playerEnv, tgt_playerEnv, "Admin");
            return true;
        }
        return false;
    }

    private boolean handleExpireRewards(PlayerEnv playerEnv) {
        if (this.checkPerm(playerEnv, "admin")) {
            this.rewardManager.expireRewards();
            return true;
        }
        return false;
    }

    private boolean handleHelp(PlayerEnv playerEnv) {
        playerEnv.player.sendMessage(this.languageManager.getMessage("help_header"));
        if (this.checkPerm(playerEnv, "player")) {
            playerEnv.player.sendMessage(this.languageManager.getMessage("help_vote"));
            playerEnv.player.sendMessage(this.languageManager.getMessage("help_stats"));
            playerEnv.player.sendMessage(this.languageManager.getMessage("help_stats_player"));
        }
        if (this.checkPerm(playerEnv, "admin")) {
            playerEnv.player.sendMessage(this.languageManager.getMessage("help_info"));
            playerEnv.player.sendMessage(this.languageManager.getMessage("help_list_rewards"));
            playerEnv.player.sendMessage(this.languageManager.getMessage("help_give_reward"));
            playerEnv.player.sendMessage(this.languageManager.getMessage("help_give_vote"));
            playerEnv.player.sendMessage(this.languageManager.getMessage("help_reload"));
            playerEnv.player.sendMessage(this.languageManager.getMessage("help_addplayer"));
        }
        playerEnv.player.sendMessage(this.languageManager.getMessage("help_footer"));
        return true;
    }

    private boolean handleInfo(PlayerEnv playerEnv) {
        if (this.checkPerm(playerEnv, "admin")) {
            String pluginUrl = this.plugin.getDescription().getWebsite();
            TextComponent urlMessage = new TextComponent(this.languageManager.getMessage("plugin_info_url", Map.of("url", pluginUrl)));
            urlMessage.setClickEvent(new ClickEvent(ClickEvent.Action.OPEN_URL, pluginUrl));
            urlMessage.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new Content[]{new Text(this.languageManager.getMessage("plugin_info_url_hover"))}));
            playerEnv.player.sendMessage(this.languageManager.getMessage("plugin_info_header"));
            playerEnv.player.sendMessage(this.languageManager.getMessage("plugin_info_name", Map.of("name", this.plugin.getDescription().getName())));
            playerEnv.player.sendMessage(this.languageManager.getMessage("plugin_info_version", Map.of("version", this.plugin.getDescription().getVersion())));
            playerEnv.player.sendMessage(this.languageManager.getMessage("plugin_info_author", Map.of("author", String.join((CharSequence)", ", this.plugin.getDescription().getAuthors()))));
            playerEnv.player.spigot().sendMessage((BaseComponent)urlMessage);
            playerEnv.player.sendMessage(this.languageManager.getMessage("plugin_info_footer"));
            return true;
        }
        return false;
    }

    private boolean handleListPlayerEnvs(PlayerEnv playerEnv) {
        if (this.checkPerm(playerEnv, "admin")) {
            this.playerEnvManager.listActivePlayerEnvs();
            return true;
        }
        return false;
    }

    private boolean handleListPlayers(PlayerEnv playerEnv) {
        if (this.checkPerm(playerEnv, "admin")) {
            List<UUID> allPlayers = this.databaseManager.getAllPlayersUUID();
            this.logger.info("All Player UUIDs: " + allPlayers.toString());
            return true;
        }
        return false;
    }

    private boolean handleListRewards(PlayerEnv playerEnv) {
        if (this.checkPerm(playerEnv, "admin")) {
            this.rewardManager.listRewards(playerEnv);
            return true;
        }
        return false;
    }

    private boolean handleListTriggers(PlayerEnv playerEnv) {
        if (this.checkPerm(playerEnv, "admin")) {
            this.rewardManager.listTriggers(playerEnv);
            return true;
        }
        return false;
    }

    private boolean handleReload(PlayerEnv playerEnv) {
        if (this.checkPerm(playerEnv, "admin")) {
            this.plugin.reloadConfig();
            this.configManager.loadConfigs();
            this.languageManager.loadLanguageConfigs();
            playerEnv.player.sendMessage(this.languageManager.getMessage("plugin_reload_true"));
            return true;
        }
        return false;
    }

    private boolean handleStats(PlayerEnv playerEnv, String[] args) {
        if (this.checkPerm(playerEnv, "player")) {
            if (args.length == 1) {
                playerEnv.player.sendMessage(this.languageManager.getMessage("top_voters_header"));
                int totalVotes = this.databaseManager.getServerVoteCount();
                playerEnv.player.sendMessage(this.languageManager.getMessage("total_server_votes", Map.of("total_votes", String.valueOf(totalVotes))));
                List<Map.Entry<String, Integer>> topVoters = this.databaseManager.getTopVoters(10);
                int rank = 1;
                for (Map.Entry<String, Integer> entry : topVoters) {
                    playerEnv.player.sendMessage(this.languageManager.getMessage("top_voter_item", Map.of("rank", String.valueOf(rank), "player", entry.getKey(), "votes", String.valueOf(entry.getValue()))));
                    ++rank;
                }
                playerEnv.player.sendMessage(this.languageManager.getMessage("top_voters_last_item"));
                playerEnv.player.sendMessage(this.languageManager.getMessage("top_voters_footer"));
            } else {
                String tgt_playerName = args[1];
                PlayerEnv tgt_playerEnv = this.playerEnvManager.getPlayerEnv(tgt_playerName);
                Map<String, Object> playerStats = this.databaseManager.getPlayerVoteStats(tgt_playerEnv);
                if (playerStats != null) {
                    playerEnv.player.sendMessage(this.languageManager.getMessage("player_stats_header", Map.of("player", tgt_playerEnv.name)));
                    playerEnv.player.sendMessage(this.languageManager.getMessage("player_stats_votes", Map.of("votes", String.valueOf(playerStats.get("totalVotes")))));
                    if (playerStats.get("lastVoteDate") != null) {
                        playerEnv.player.sendMessage(this.languageManager.getMessage("player_stats_last_vote", Map.of("last_vote", String.valueOf(playerStats.get("lastVoteDate")))));
                    }
                } else {
                    playerEnv.player.sendMessage(this.languageManager.getMessage("player_not_found", Map.of("player", tgt_playerEnv.name)));
                }
                playerEnv.player.sendMessage(this.languageManager.getMessage("player_stats_footer"));
            }
            return true;
        }
        return false;
    }

    private boolean handleVoteList(PlayerEnv playerEnv) {
        if (this.checkPerm(playerEnv, "player")) {
            playerEnv.player.sendMessage(this.languageManager.getMessage("vote_site_header"));
            playerEnv.player.sendMessage(this.languageManager.getMessage("vote_site_first_item"));
            YamlConfiguration sitesConfig = this.configManager.getConfig("sites");
            if (sitesConfig == null || sitesConfig.getKeys(false).isEmpty()) {
                playerEnv.player.sendMessage(this.languageManager.getMessage("no_vote_sites"));
                return false;
            }
            for (String siteKey : sitesConfig.getKeys(false)) {
                ConfigurationSection siteSection = sitesConfig.getConfigurationSection(siteKey);
                if (siteSection == null || !siteSection.getBoolean("site_active", true)) continue;
                String siteName = siteSection.getString("site_name", "Unknown");
                String siteUrl = siteSection.getString("site_vote_url", "");
                TextComponent message = new TextComponent(this.languageManager.getMessage("vote_site_entry", Map.of("site_name", siteName)));
                message.setClickEvent(new ClickEvent(ClickEvent.Action.OPEN_URL, siteUrl));
                message.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new ComponentBuilder(this.languageManager.getMessage("vote_site_hover")).create()));
                playerEnv.player.spigot().sendMessage((BaseComponent)message);
            }
            playerEnv.player.sendMessage(this.languageManager.getMessage("vote_site_footer"));
            return true;
        }
        return false;
    }
}

