/*
 * Decompiled with CFR 0.152.
 */
package com.playdelphi;

import com.playdelphi.DelphiVote;
import com.playdelphi.YamlManager;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.YamlConfiguration;

public class ConfigManager {
    private final DelphiVote plugin;
    private Logger logger;
    private File datafolder;
    private Map<String, YamlConfiguration> configs;
    private YamlManager yamlManager;

    public ConfigManager(DelphiVote plugin) {
        this.plugin = plugin;
        this.logger = plugin.getLogger();
        this.datafolder = plugin.getDataFolder();
        this.yamlManager = plugin.getYamlManager();
        this.configs = new HashMap<String, YamlConfiguration>();
        this.loadConfigs();
    }

    public void loadConfigs() {
        this.loadConfig("config", "config.yml");
        this.loadConfig("sites", "sites.yml");
        this.loadConfig("reward_items", "reward_items.yml");
        this.loadConfig("reward_triggers", "reward_triggers.yml");
        this.loadConfig("example_sites", "examples/sites.yml");
        this.loadConfig("example_reward_items", "examples/reward_items.yml");
        this.loadConfig("example_reward_triggers", "examples/reward_triggers.yml");
        File langFolder = new File(this.datafolder, "lang");
        if (!langFolder.exists()) {
            langFolder.mkdirs();
        }
        List resources = this.getResourceConfig("plugin.yml").getStringList("resources");
        for (String resource : resources) {
            File langFile;
            if (!resource.startsWith("lang/") || (langFile = new File(this.datafolder, resource)).exists()) continue;
            this.plugin.saveResource(resource, false);
            this.logger.info("Created language file: " + resource);
        }
        File[] langFiles = langFolder.listFiles((dir, name) -> name.toLowerCase().startsWith("messages-") && name.toLowerCase().endsWith(".yml"));
        if (langFiles != null) {
            for (File langFile : langFiles) {
                this.loadConfig("lang_" + langFile.getName(), "lang/" + langFile.getName());
            }
        }
    }

    private void loadConfig(String configName, String resourceName) {
        File configFile = new File(this.datafolder, resourceName);
        if (!configFile.exists()) {
            this.plugin.saveResource(resourceName, false);
        }
        try {
            InputStream resourceStream = this.plugin.getResource(resourceName);
            if (resourceStream == null) {
                this.logger.warning("Resource not found: " + resourceName);
                return;
            }
            this.yamlManager.processYaml(resourceStream, configFile.getPath(), configFile.getPath());
        }
        catch (IOException e) {
            this.logger.severe("Error processing " + resourceName + ": " + e.getMessage());
            return;
        }
        YamlConfiguration config = new YamlConfiguration();
        try {
            config.load(configFile);
            this.configs.put(configName, config);
        }
        catch (IOException | InvalidConfigurationException e) {
            if (e.getMessage().contains("not a Map")) {
                this.logger.warning(resourceName + " is empty, be sure to set up your configs and restart the server!");
                return;
            }
            this.logger.severe("Error loading " + resourceName + ": " + e.getMessage());
            return;
        }
    }

    public YamlConfiguration getConfig(String configName) {
        return this.configs.get(configName);
    }

    public YamlConfiguration getResourceConfig(String resourceName) {
        InputStream stream = this.plugin.getResource(resourceName);
        return YamlConfiguration.loadConfiguration((Reader)new InputStreamReader(stream, StandardCharsets.UTF_8));
    }

    public ConfigurationSection getTriggerTable() {
        YamlConfiguration triggersConfig = this.configs.get("reward_triggers");
        if (triggersConfig == null) {
            this.logger.severe("Triggers configuration is null");
            return null;
        }
        return triggersConfig.getRoot();
    }

    public ConfigurationSection getRewardItemTable() {
        YamlConfiguration rewardsConfig = this.configs.get("reward_items");
        if (rewardsConfig == null) {
            this.logger.severe("Rewards configuration is null");
            return null;
        }
        return rewardsConfig.getRoot();
    }
}

