/*
 * Decompiled with CFR 0.152.
 */
package com.playdelphi;

import com.playdelphi.ConfigManager;
import com.playdelphi.DelphiVote;
import com.playdelphi.LanguageManager;
import com.playdelphi.PlayerEnv;
import com.playdelphi.shaded.com.zaxxer.hikari.HikariConfig;
import com.playdelphi.shaded.com.zaxxer.hikari.HikariDataSource;
import java.io.File;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Logger;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public class DatabaseManager {
    private final DelphiVote plugin;
    private FileConfiguration config;
    private ConfigManager configManager;
    private File datafolder;
    private Logger logger;
    private HikariDataSource dataSource;
    private LanguageManager languageManager;
    private boolean isMySQL;
    private String dbType;
    private String tablePrefix;
    private String votesTable;
    private String playersTable;
    private String offlineRewardsTable;

    public DatabaseManager(DelphiVote plugin) {
        this.plugin = plugin;
        this.config = plugin.getConfig();
        this.datafolder = plugin.getDataFolder();
        this.logger = plugin.getLogger();
        this.configManager = plugin.getConfigManager();
        this.languageManager = plugin.getLanguageManager();
        this.dbType = this.config.getString("database.type", "sqlite");
        this.isMySQL = "mysql".equalsIgnoreCase(this.dbType);
        this.initializeDatabase();
        this.createTables();
    }

    private void initializeDatabase() {
        this.tablePrefix = this.config.getString("database.table_prefix");
        this.votesTable = this.tablePrefix + "_votes";
        this.playersTable = this.tablePrefix + "_players";
        this.offlineRewardsTable = this.tablePrefix + "_offline_rewards";
        File databaseFolder = new File(this.datafolder, "data");
        if (!databaseFolder.exists()) {
            databaseFolder.mkdirs();
        }
        HikariConfig hikariConfig = new HikariConfig();
        if (this.isMySQL) {
            hikariConfig.setJdbcUrl("jdbc:mysql://" + this.config.getString("database.host") + ":" + this.config.getInt("database.port") + "/" + this.config.getString("database.database"));
            hikariConfig.setUsername(this.config.getString("database.username"));
            hikariConfig.setPassword(this.config.getString("database.password"));
            hikariConfig.addDataSourceProperty("cachePrepStmts", "true");
            hikariConfig.addDataSourceProperty("prepStmtCacheSize", "250");
            hikariConfig.addDataSourceProperty("prepStmtCacheSqlLimit", "2048");
        } else {
            hikariConfig.setJdbcUrl("jdbc:sqlite:" + this.datafolder.getAbsolutePath() + "/data/delphivote.db");
            hikariConfig.setDriverClassName("org.sqlite.JDBC");
        }
        hikariConfig.setMaximumPoolSize(10);
        this.dataSource = new HikariDataSource(hikariConfig);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void createTables() {
        YamlConfiguration databaseConfig = this.configManager.getResourceConfig("database.yml");
        ConfigurationSection tablesSection = databaseConfig.getConfigurationSection("tables");
        if (tablesSection == null) {
            this.logger.severe("No table definitions found in database.yml");
            return;
        }
        try (Connection conn = this.dataSource.getConnection();
             Statement stmt = conn.createStatement();){
            for (String tableName : tablesSection.getKeys(false)) {
                ConfigurationSection tableSection = tablesSection.getConfigurationSection(tableName);
                if (tableSection == null) continue;
                StringBuilder createTableSQL = new StringBuilder("CREATE TABLE IF NOT EXISTS " + this.tablePrefix + "_" + tableName + " (");
                for (String fieldName : tableSection.getKeys(false)) {
                    ConfigurationSection fieldSection = tableSection.getConfigurationSection(fieldName);
                    String fieldDef = fieldSection != null ? (this.isMySQL ? fieldSection.getString("mysql") : fieldSection.getString("sqlite")) : tableSection.getString(fieldName);
                    if (fieldDef == null) continue;
                    createTableSQL.append(fieldName).append(" ").append(fieldDef).append(", ");
                }
                createTableSQL.setLength(createTableSQL.length() - 2);
                createTableSQL.append(")");
                stmt.execute(createTableSQL.toString());
                if (!tableName.equals("votes") || !this.isMySQL) continue;
                try {
                    stmt.execute("CREATE INDEX idx_player_uuid ON " + this.tablePrefix + "_" + tableName + " (player_uuid)");
                }
                catch (SQLException e) {
                    if (e.getErrorCode() == 1061) continue;
                    throw e;
                    return;
                }
            }
        }
        catch (SQLException e) {
            this.logger.severe("Error creating tables: " + e.getMessage());
        }
    }

    public void addVote(PlayerEnv playerEnv, PlayerEnv tgt_playerEnv, String serviceName) {
        String sql = "INSERT INTO " + this.votesTable + " (player_uuid, player_name, vote_service, vote_ts) VALUES (?, ?, ?, CURRENT_TIMESTAMP)";
        try (Connection conn = this.dataSource.getConnection();
             PreparedStatement pstmt = conn.prepareStatement(sql);){
            pstmt.setString(1, tgt_playerEnv.uuid.toString());
            pstmt.setString(2, tgt_playerEnv.name);
            pstmt.setString(3, serviceName);
            pstmt.executeUpdate();
        }
        catch (SQLException e) {
            this.logger.severe("Error adding vote: " + e.getMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int getPlayerVoteCount(PlayerEnv tgt_playerEnv) {
        String sql = "SELECT COUNT(*) FROM " + this.votesTable + " WHERE player_uuid = ?";
        try (Connection conn = this.dataSource.getConnection();
             PreparedStatement pstmt = conn.prepareStatement(sql);){
            pstmt.setString(1, tgt_playerEnv.uuid.toString());
            try (ResultSet rs = pstmt.executeQuery();){
                if (!rs.next()) return 0;
                int n = rs.getInt(1);
                return n;
            }
        }
        catch (SQLException e) {
            this.logger.severe("Error getting player vote count: " + e.getMessage());
        }
        return 0;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int getServerVoteCount() {
        try (Connection conn = this.dataSource.getConnection();
             PreparedStatement stmt = conn.prepareStatement("SELECT COUNT(*) FROM " + this.votesTable);
             ResultSet rs = stmt.executeQuery();){
            if (!rs.next()) return 0;
            int n = rs.getInt(1);
            return n;
        }
        catch (SQLException e) {
            this.logger.severe("Failed to get total server vote count: " + e.getMessage());
        }
        return 0;
    }

    public List<Map.Entry<String, Integer>> getTopVoters(int limit) {
        ArrayList<Map.Entry<String, Integer>> topVoters = new ArrayList<Map.Entry<String, Integer>>();
        String sql = "SELECT player_name, COUNT(*) as vote_count FROM " + this.votesTable + " GROUP BY player_name ORDER BY vote_count DESC LIMIT ?";
        try (Connection conn = this.dataSource.getConnection();
             PreparedStatement pstmt = conn.prepareStatement(sql);){
            pstmt.setInt(1, limit);
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                String player_name = rs.getString("player_name");
                int voteCount = rs.getInt("vote_count");
                topVoters.add(new AbstractMap.SimpleEntry<String, Integer>(player_name, voteCount));
            }
        }
        catch (SQLException e) {
            this.logger.severe("Error fetching top voters: " + e.getMessage());
        }
        return topVoters;
    }

    public Map<String, Object> getPlayerVoteStats(PlayerEnv tgt_playerEnv) {
        HashMap<String, Object> stats = new HashMap<String, Object>();
        String sql = "SELECT COUNT(*) as total_votes, MAX(vote_ts) as last_vote FROM " + this.votesTable + " WHERE player_uuid = ?";
        try (Connection conn = this.dataSource.getConnection();
             PreparedStatement pstmt = conn.prepareStatement(sql);){
            pstmt.setString(1, tgt_playerEnv.uuid.toString());
            ResultSet rs = pstmt.executeQuery();
            if (rs.next()) {
                stats.put("totalVotes", rs.getInt("total_votes"));
                stats.put("lastVoteDate", rs.getTimestamp("last_vote"));
            }
        }
        catch (SQLException e) {
            this.logger.severe("Error fetching player vote stats: " + e.getMessage());
        }
        return stats.isEmpty() ? null : stats;
    }

    public void expireRewards(long cutoffTime) {
        String sql = "DELETE FROM " + this.offlineRewardsTable + " WHERE reward_ts < ?";
        try (Connection conn = this.dataSource.getConnection();
             PreparedStatement pstmt = conn.prepareStatement(sql);){
            pstmt.setTimestamp(1, new Timestamp(cutoffTime));
            int deletedRewards = pstmt.executeUpdate();
            this.logger.info("Cleared " + deletedRewards + " old offline rewards.");
        }
        catch (SQLException e) {
            this.logger.severe("Error clearing old offline rewards: " + e.getMessage());
        }
    }

    public void close() {
        if (this.dataSource != null) {
            this.dataSource.close();
        }
    }

    public void addOrUpdatePlayer(PlayerEnv tgt_playerEnv) {
        String query = this.isMySQL ? "INSERT INTO " + this.playersTable + " (player_uuid, player_name, last_seen_ts) VALUES (?, ?, CURRENT_TIMESTAMP) ON DUPLICATE KEY UPDATE player_name = ?, last_seen_ts = CURRENT_TIMESTAMP" : "INSERT OR REPLACE INTO " + this.playersTable + " (player_uuid, player_name, last_seen_ts) VALUES (?, ?, CURRENT_TIMESTAMP)";
        try (Connection conn = this.dataSource.getConnection();
             PreparedStatement pstmt = conn.prepareStatement(query);){
            pstmt.setString(1, tgt_playerEnv.uuid.toString());
            pstmt.setString(2, tgt_playerEnv.name);
            if (this.isMySQL) {
                pstmt.setString(3, tgt_playerEnv.name);
            }
            pstmt.executeUpdate();
        }
        catch (SQLException e) {
            this.logger.severe("Error adding/updating player: " + e.getMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public UUID getPlayerUUID(PlayerEnv tgt_playerEnv) {
        String query = "SELECT player_uuid FROM " + this.playersTable + " WHERE player_name = ?";
        try (Connection conn = this.dataSource.getConnection();
             PreparedStatement pstmt = conn.prepareStatement(query);){
            pstmt.setString(1, tgt_playerEnv.name);
            try (ResultSet rs = pstmt.executeQuery();){
                if (!rs.next()) return null;
                UUID uUID = UUID.fromString(rs.getString("player_uuid"));
                return uUID;
            }
        }
        catch (SQLException e) {
            this.logger.severe("Error getting player UUID: " + e.getMessage());
        }
        return null;
    }

    /*
     * Exception decompiling
     */
    public List<UUID> getAllPlayersUUID() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getPlayerUsername(PlayerEnv tgt_playerEnv) {
        String query = "SELECT player_name FROM " + this.playersTable + " WHERE player_uuid = ?";
        try (Connection conn = this.dataSource.getConnection();
             PreparedStatement pstmt = conn.prepareStatement(query);){
            pstmt.setString(1, tgt_playerEnv.uuid.toString());
            try (ResultSet rs = pstmt.executeQuery();){
                if (!rs.next()) return null;
                String string = rs.getString("player_name");
                return string;
            }
        }
        catch (SQLException e) {
            this.logger.severe("Error getting player name: " + e.getMessage());
        }
        return null;
    }

    public void addOfflineReward(PlayerEnv tgt_playerEnv, String rewardId, String serviceName) {
        String sql = "INSERT INTO " + this.offlineRewardsTable + " (player_uuid, reward_id, vote_service, reward_ts) VALUES (?, ?, ?, ?)";
        try (Connection conn = this.getConnection();
             PreparedStatement pstmt = conn.prepareStatement(sql);){
            pstmt.setString(1, tgt_playerEnv.uuid.toString());
            pstmt.setString(2, rewardId);
            pstmt.setString(3, serviceName);
            pstmt.setTimestamp(4, new Timestamp(System.currentTimeMillis()));
            pstmt.executeUpdate();
        }
        catch (SQLException e) {
            this.logger.severe("Error adding offline reward: " + e.getMessage());
        }
    }

    public List<Map<String, Object>> getOfflineRewards(PlayerEnv tgt_playerEnv) {
        ArrayList<Map<String, Object>> rewards = new ArrayList<Map<String, Object>>();
        String sql = "SELECT * FROM " + this.offlineRewardsTable + " WHERE player_uuid = ?";
        try (Connection conn = this.getConnection();
             PreparedStatement pstmt = conn.prepareStatement(sql);){
            pstmt.setString(1, tgt_playerEnv.uuid.toString());
            try (ResultSet rs = pstmt.executeQuery();){
                while (rs.next()) {
                    HashMap<String, Object> reward = new HashMap<String, Object>();
                    reward.put("reward_id", rs.getString("reward_id"));
                    reward.put("vote_service", rs.getString("vote_service"));
                    reward.put("reward_ts", rs.getTimestamp("reward_ts"));
                    rewards.add(reward);
                }
            }
        }
        catch (SQLException e) {
            this.logger.severe("Error getting offline rewards: " + e.getMessage());
        }
        return rewards;
    }

    public void removeOfflineReward(PlayerEnv tgt_playerEnv, String rewardId) {
        String sql = "DELETE FROM " + this.offlineRewardsTable + " WHERE player_uuid = ? AND reward_id = ?";
        try (Connection conn = this.getConnection();
             PreparedStatement pstmt = conn.prepareStatement(sql);){
            pstmt.setString(1, tgt_playerEnv.uuid.toString());
            pstmt.setString(2, rewardId);
            pstmt.executeUpdate();
            this.logger.info("Removed offline reward for " + String.valueOf(tgt_playerEnv.uuid) + ", reward ID " + rewardId);
        }
        catch (SQLException e) {
            this.logger.severe("Error removing offline reward: " + e.getMessage());
        }
    }

    private Connection getConnection() throws SQLException {
        return this.dataSource.getConnection();
    }
}

