/*
 * Decompiled with CFR 0.152.
 */
package com.playdelphi;

import com.playdelphi.CommandManager;
import com.playdelphi.ConfigManager;
import com.playdelphi.DatabaseManager;
import com.playdelphi.LanguageManager;
import com.playdelphi.PlayerEnv;
import com.playdelphi.PlayerEnvManager;
import com.playdelphi.RewardManager;
import com.playdelphi.UtilsManager;
import com.playdelphi.VoteManager;
import com.playdelphi.YamlManager;
import com.playdelphi.shaded.org.bstats.bukkit.Metrics;
import com.vexsoftware.votifier.model.VotifierEvent;
import org.bukkit.command.CommandExecutor;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerLoginEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class DelphiVote
extends JavaPlugin
implements Listener {
    private FileConfiguration config;
    private ConfigManager configManager;
    private DatabaseManager databaseManager;
    private LanguageManager languageManager;
    private RewardManager rewardManager;
    private VoteManager voteManager;
    private CommandManager commandManager;
    private UtilsManager utilsManager;
    private PlayerEnvManager playerEnvManager;
    private YamlManager yamlManager;
    private Object headDatabaseAPI;
    private boolean headDatabaseEnabled = false;

    public ConfigManager getConfigManager() {
        return this.configManager;
    }

    public DatabaseManager getDatabaseManager() {
        return this.databaseManager;
    }

    public LanguageManager getLanguageManager() {
        return this.languageManager;
    }

    public RewardManager getRewardManager() {
        return this.rewardManager;
    }

    public VoteManager getVoteManager() {
        return this.voteManager;
    }

    public CommandManager getCommandManager() {
        return this.commandManager;
    }

    public Object getHeadDatabaseAPI() {
        return this.headDatabaseEnabled ? this.headDatabaseAPI : null;
    }

    public UtilsManager getUtilsManager() {
        return this.utilsManager;
    }

    public PlayerEnvManager getPlayerEnvManager() {
        return this.playerEnvManager;
    }

    public YamlManager getYamlManager() {
        return this.yamlManager;
    }

    public void onEnable() {
        this.getLogger().info("DelphiVote plugin is starting up...");
        this.yamlManager = new YamlManager(this);
        this.configManager = new ConfigManager(this);
        this.utilsManager = new UtilsManager(this);
        this.playerEnvManager = new PlayerEnvManager(this);
        this.databaseManager = new DatabaseManager(this);
        this.languageManager = new LanguageManager(this);
        this.setupHeadDatabase();
        this.rewardManager = new RewardManager(this);
        this.voteManager = new VoteManager(this);
        this.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this);
        int pluginId = 24111;
        Metrics metrics = new Metrics(this, pluginId);
        this.commandManager = new CommandManager(this);
        this.getCommand("vote").setExecutor((CommandExecutor)this.commandManager);
        this.getLogger().info("DelphiVote plugin has been enabled!");
        this.startPeriodicTasks();
    }

    public void onDisable() {
        this.getLogger().info("DelphiVote plugin is shutting down...");
        if (this.databaseManager != null) {
            this.databaseManager.close();
        }
    }

    @EventHandler
    public void onPlayerLogin(PlayerLoginEvent event) {
        PlayerEnv playerEnv = this.playerEnvManager.getPlayerEnv(event.getPlayer());
        this.databaseManager.addOrUpdatePlayer(playerEnv);
        this.getServer().getScheduler().runTaskLater((Plugin)this, () -> this.rewardManager.processPendingOfflineRewards(playerEnv), 20L);
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent event) {
        this.playerEnvManager.removePlayerEnv(event.getPlayer().getUniqueId());
    }

    @EventHandler
    public void onVotifierEvent(VotifierEvent event) {
        PlayerEnv playerEnv = this.playerEnvManager.getPlayerEnv(event.getVote().getUsername());
        this.voteManager.handleVote(playerEnv, playerEnv, event.getVote().getServiceName());
    }

    private void startPeriodicTasks() {
        this.getServer().getScheduler().runTaskTimerAsynchronously((Plugin)this, this.rewardManager::expireRewards, 12000L, 728000L);
    }

    private void setupHeadDatabase() {
        try {
            Class.forName("me.arcaniax.hdb.api.HeadDatabaseAPI");
            if (this.getServer().getPluginManager().getPlugin("HeadDatabase") != null) {
                Class<?> apiClass = Class.forName("me.arcaniax.hdb.api.HeadDatabaseAPI");
                this.headDatabaseAPI = apiClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                this.headDatabaseEnabled = true;
                this.getLogger().info("HeadDatabase found and enabled!");
            }
        }
        catch (Exception e) {
            this.getLogger().info("HeadDatabase plugin not found");
            this.headDatabaseEnabled = false;
        }
    }
}

