/*
 * Decompiled with CFR 0.152.
 */
package com.playdelphi;

import com.playdelphi.ConfigManager;
import com.playdelphi.DelphiVote;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.bukkit.ChatColor;
import org.bukkit.configuration.file.YamlConfiguration;

public class LanguageManager {
    private final DelphiVote plugin;
    private File datafolder;
    private Logger logger;
    private YamlConfiguration langConfig;
    private ConfigManager configManager;
    private final Map<String, String> messages = new HashMap<String, String>();

    public LanguageManager(DelphiVote plugin) {
        this.plugin = plugin;
        this.logger = plugin.getLogger();
        this.datafolder = plugin.getDataFolder();
        this.configManager = plugin.getConfigManager();
        this.loadLanguageConfigs();
    }

    public void loadLanguageConfigs() {
        File langFolder = new File(this.datafolder, "lang");
        String langPref = this.configManager.getConfig("config").getString("language", "messages-en.yml");
        this.langConfig = this.configManager.getConfig("lang_" + langPref);
        for (String key : this.langConfig.getKeys(false)) {
            String message = this.langConfig.getString(key);
            if (message == null) continue;
            this.messages.put(key, ChatColor.translateAlternateColorCodes((char)'&', (String)message));
        }
    }

    private void createLanguageFile(String fileName) {
        File file = new File(String.valueOf(this.datafolder) + File.separator + fileName);
        if (!file.exists()) {
            this.plugin.saveResource(fileName, false);
        }
    }

    public String getMessage(String key) {
        return this.messages.getOrDefault(key, "Message not found: " + key);
    }

    public String getMessage(String key, Map<String, String> placeholders) {
        String message = this.messages.getOrDefault(key, key);
        for (Map.Entry<String, String> entry : placeholders.entrySet()) {
            message = message.replace("{" + entry.getKey() + "}", entry.getValue());
        }
        return ChatColor.translateAlternateColorCodes((char)'&', (String)message);
    }

    public String formatMessage(String messageKey, String playerName, int voteCount) {
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put("player", playerName);
        placeholders.put("votes", String.valueOf(voteCount));
        return this.getMessage(messageKey, placeholders);
    }
}

