/*
 * Decompiled with CFR 0.152.
 */
package com.playdelphi;

import com.playdelphi.DelphiVote;
import com.playdelphi.PlayerEnv;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;
import org.bukkit.entity.Player;

public class PlayerEnvManager {
    private final DelphiVote plugin;
    private Logger logger;
    private static ConcurrentHashMap<UUID, PlayerEnv> playerEnvMap;

    public PlayerEnvManager(DelphiVote plugin) {
        this.plugin = plugin;
        this.logger = plugin.getLogger();
        playerEnvMap = new ConcurrentHashMap();
    }

    public PlayerEnv getPlayerEnv(Player player) {
        return playerEnvMap.compute(player.getUniqueId(), (key, playerEnv) -> new PlayerEnv(player));
    }

    public PlayerEnv getPlayerEnv(UUID uuid) {
        return playerEnvMap.computeIfAbsent(uuid, key -> new PlayerEnv(uuid));
    }

    public PlayerEnv getPlayerEnv(String name) {
        UUID uuid = this.plugin.getUtilsManager().mojangUUIDLookup(name);
        PlayerEnv thisPlayer = playerEnvMap.computeIfAbsent(uuid, key -> new PlayerEnv(uuid));
        thisPlayer.name = thisPlayer.player != null ? thisPlayer.player.getName() : name;
        return thisPlayer;
    }

    public void removePlayerEnv(UUID uuid) {
        playerEnvMap.remove(uuid);
    }

    public void listActivePlayerEnvs() {
        this.logger.info("Active PlayerEnv entries:");
        for (UUID uuid : playerEnvMap.keySet()) {
            PlayerEnv playerEnv = playerEnvMap.get(uuid);
            this.logger.info("UUID: " + String.valueOf(uuid) + ", PlayerEnv: " + playerEnv.toString() + ", Player: " + playerEnv.name + ", uuid: " + String.valueOf(playerEnv.uuid) + ", online: " + (playerEnv.player != null));
        }
    }
}

