/*
 * Decompiled with CFR 0.152.
 */
package com.playdelphi;

import com.playdelphi.ConfigManager;
import com.playdelphi.DatabaseManager;
import com.playdelphi.DelphiVote;
import com.playdelphi.LanguageManager;
import com.playdelphi.PlayerEnv;
import com.playdelphi.PlayerEnvManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import java.util.logging.Logger;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class RewardManager {
    private final DelphiVote plugin;
    private Logger logger;
    private ConfigManager configManager;
    private DatabaseManager databaseManager;
    private final LanguageManager languageManager;
    private Object headDatabaseAPI;
    private final PlayerEnvManager playerEnvManager;
    private final Random random;

    public RewardManager(DelphiVote plugin) {
        this.plugin = plugin;
        this.logger = plugin.getLogger();
        this.configManager = plugin.getConfigManager();
        this.databaseManager = plugin.getDatabaseManager();
        this.headDatabaseAPI = plugin.getHeadDatabaseAPI();
        this.languageManager = plugin.getLanguageManager();
        this.playerEnvManager = plugin.getPlayerEnvManager();
        this.random = new Random();
    }

    public void handleTriggers(PlayerEnv playerEnv, PlayerEnv tgt_playerEnv, String serviceName) {
        int playerVoteCount = this.databaseManager.getPlayerVoteCount(tgt_playerEnv);
        int serverVoteCount = this.databaseManager.getServerVoteCount();
        ConfigurationSection triggerTable = this.configManager.getTriggerTable();
        for (String triggerKey : triggerTable.getKeys(false)) {
            ConfigurationSection trigger = triggerTable.getConfigurationSection(triggerKey);
            if (!this.evaluateTrigger(trigger, playerVoteCount, serverVoteCount)) continue;
            this.executeTrigger(playerEnv, tgt_playerEnv, trigger, playerVoteCount, serviceName);
        }
    }

    private boolean evaluateTrigger(ConfigurationSection trigger, int playerVoteCount, int serverVoteCount) {
        String triggerName = trigger.getString("trigger_name");
        String triggerUser = trigger.getString("trigger_user");
        int triggerThreshold = trigger.getInt("trigger_threshold", 0);
        boolean triggerRepeat = trigger.getBoolean("trigger_repeat", true);
        if (triggerThreshold == 0) {
            return true;
        }
        if (triggerUser.equals("player")) {
            if (triggerRepeat) {
                return playerVoteCount % triggerThreshold == 0;
            }
            return playerVoteCount == triggerThreshold;
        }
        if (triggerUser.equals("server")) {
            if (triggerRepeat) {
                return serverVoteCount % triggerThreshold == 0;
            }
            return serverVoteCount == triggerThreshold;
        }
        return false;
    }

    private void executeTrigger(PlayerEnv playerEnv, PlayerEnv tgt_playerEnv, ConfigurationSection trigger, int voteCount, String serviceName) {
        String triggerUser = trigger.getString("trigger_user");
        List triggerRewards = trigger.getStringList("trigger_rewards");
        String playerMessage = trigger.getString("trigger_player_message");
        String broadcastMessage = trigger.getString("trigger_broadcast_message");
        if (triggerUser.equals("player")) {
            for (String rewardName : triggerRewards) {
                ConfigurationSection reward = this.configManager.getRewardItemTable().getConfigurationSection(rewardName);
                if (reward == null) continue;
                this.giveReward(playerEnv, tgt_playerEnv, reward, serviceName);
            }
            if (!serviceName.equals("Admin")) {
                this.plugin.getServer().broadcastMessage(this.formatTriggerMessage(broadcastMessage, tgt_playerEnv.name, voteCount, serviceName));
            }
            if (tgt_playerEnv.player != null) {
                tgt_playerEnv.player.sendMessage(this.formatTriggerMessage(playerMessage, tgt_playerEnv.name, voteCount, serviceName));
            }
        } else if (triggerUser.equals("server")) {
            List<UUID> allPlayers = this.databaseManager.getAllPlayersUUID();
            for (UUID uuid : allPlayers) {
                PlayerEnv svr_playerEnv = this.playerEnvManager.getPlayerEnv(uuid);
                for (String rewardName : triggerRewards) {
                    ConfigurationSection reward = this.configManager.getRewardItemTable().getConfigurationSection(rewardName);
                    if (reward == null) continue;
                    this.giveReward(playerEnv, svr_playerEnv, reward, serviceName);
                }
                if (svr_playerEnv.player != null) {
                    svr_playerEnv.player.sendMessage(this.formatTriggerMessage(playerMessage, svr_playerEnv.name, voteCount, serviceName));
                }
                if (svr_playerEnv.player != null) continue;
                this.playerEnvManager.removePlayerEnv(svr_playerEnv.uuid);
            }
            this.plugin.getServer().broadcastMessage(this.formatTriggerMessage(broadcastMessage, playerEnv.name, voteCount, serviceName));
        }
    }

    public void handleRewards(PlayerEnv playerEnv, PlayerEnv tgt_playerEnv, String serviceName, String rewardName) {
        ConfigurationSection rewardTable = this.configManager.getRewardItemTable();
        for (String rewardKey : rewardTable.getKeys(false)) {
            ConfigurationSection reward = this.configManager.getRewardItemTable().getConfigurationSection(rewardKey);
            if (!rewardName.equals(rewardKey)) continue;
            this.giveReward(playerEnv, tgt_playerEnv, reward, serviceName);
            playerEnv.player.sendMessage(this.languageManager.getMessage("give_reward_success", Map.of("player", tgt_playerEnv.name, "reward", reward.getString("reward_name"))));
            if (tgt_playerEnv.player == null) continue;
            tgt_playerEnv.player.sendMessage(this.languageManager.getMessage("give_reward_success_player", Map.of("reward", reward.getString("reward_name"))));
        }
    }

    public void giveReward(PlayerEnv playerEnv, PlayerEnv tgt_playerEnv, ConfigurationSection reward, String serviceName) {
        if (tgt_playerEnv.player == null) {
            this.databaseManager.addOfflineReward(tgt_playerEnv, reward.getName(), serviceName);
            return;
        }
        List rewardItems = reward.getMapList("reward_items");
        boolean isRandomized = reward.getBoolean("reward_randomized");
        int maxItems = reward.getInt("reward_max_items");
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        HashMap<ItemStack, List> commands = new HashMap<ItemStack, List>();
        for (Map rewardItem : rewardItems) {
            ItemStack item;
            String itemTitle = (String)rewardItem.get("title");
            String itemName = (String)rewardItem.get("item");
            int itemCount = (Integer)rewardItem.get("quantity");
            List itemLoreList = (List)rewardItem.get("lore");
            List itemCommandList = (List)rewardItem.get("commands");
            if (itemName.startsWith("hdb-") && this.headDatabaseAPI != null) {
                String headID = itemName.split("-")[1];
                item = this.getHeadItem(headID);
                if (item == null) {
                    this.logger.warning("Head with ID " + headID + " could not be found!");
                    continue;
                }
                item.setAmount(itemCount);
            } else {
                item = new ItemStack(Material.valueOf((String)itemName.toUpperCase()), itemCount);
            }
            ItemMeta meta = item.getItemMeta();
            if (meta != null) {
                if (itemTitle != null) {
                    meta.setDisplayName(itemTitle);
                }
                if (itemLoreList != null) {
                    meta.setLore(itemLoreList);
                }
                item.setItemMeta(meta);
            }
            if (itemCommandList != null && !itemCommandList.isEmpty()) {
                commands.put(item, itemCommandList);
            }
            items.add(item);
        }
        if (isRandomized && maxItems > 0 && maxItems < items.size()) {
            while (items.size() > maxItems) {
                ItemStack removedItem = (ItemStack)items.remove(this.random.nextInt(items.size()));
                commands.remove(removedItem);
            }
        }
        for (ItemStack item : items) {
            tgt_playerEnv.player.getInventory().addItem(new ItemStack[]{item});
            if (!commands.containsKey(item)) continue;
            for (String command : (List)commands.get(item)) {
                this.executeConsoleCommand(tgt_playerEnv, command);
            }
        }
    }

    public void processPendingOfflineRewards(PlayerEnv tgt_playerEnv) {
        List<Map<String, Object>> pendingRewards = this.databaseManager.getOfflineRewards(tgt_playerEnv);
        for (Map<String, Object> rewardData : pendingRewards) {
            String rewardId = (String)rewardData.get("reward_id");
            String serviceName = (String)rewardData.get("vote_service");
            ConfigurationSection reward = this.configManager.getRewardItemTable().getConfigurationSection(rewardId);
            if (reward == null) continue;
            this.giveReward(tgt_playerEnv, tgt_playerEnv, reward, serviceName);
            this.databaseManager.removeOfflineReward(tgt_playerEnv, rewardId);
            String message = this.languageManager.getMessage("give_reward_success_player", Map.of("reward", reward.getString("reward_name")));
            tgt_playerEnv.player.sendMessage(message);
        }
    }

    private String formatTriggerMessage(String message, String playerName, int voteCount, String serviceName) {
        return this.languageManager.getMessage(message, Map.of("player", playerName, "votes", String.valueOf(voteCount), "service", serviceName));
    }

    public void listTriggers(PlayerEnv playerEnv) {
        ConfigurationSection triggerTable = this.configManager.getTriggerTable();
        if (triggerTable == null && playerEnv.player != null) {
            playerEnv.player.sendMessage(this.languageManager.getMessage("trigger_list_error"));
            return;
        }
        if (playerEnv.player != null) {
            playerEnv.player.sendMessage(this.languageManager.getMessage("trigger_list_header"));
        }
        for (String triggerKey : triggerTable.getKeys(false)) {
            ConfigurationSection trigger = triggerTable.getConfigurationSection(triggerKey);
            if (trigger == null || playerEnv.player == null) continue;
            playerEnv.player.sendMessage(this.languageManager.getMessage("trigger_list_item", Map.of("key", triggerKey)));
        }
    }

    public void listRewards(PlayerEnv playerEnv) {
        ConfigurationSection rewardTable = this.configManager.getRewardItemTable();
        if (rewardTable == null && playerEnv.player != null) {
            playerEnv.player.sendMessage(this.languageManager.getMessage("reward_list_error"));
            return;
        }
        if (playerEnv.player != null) {
            playerEnv.player.sendMessage(this.languageManager.getMessage("reward_list_header"));
        }
        for (String rewardKey : rewardTable.getKeys(false)) {
            ConfigurationSection reward = rewardTable.getConfigurationSection(rewardKey);
            if (reward == null || playerEnv.player == null) continue;
            playerEnv.player.sendMessage(this.languageManager.getMessage("reward_list_item", Map.of("key", rewardKey)));
        }
    }

    public void expireRewards() {
        YamlConfiguration mainConfig = this.configManager.getConfig("config");
        long rewardsExpire = mainConfig.getInt("rewards_expire");
        long cutoffTime = System.currentTimeMillis() - rewardsExpire * 24L * 60L * 60L * 1000L;
        this.databaseManager.expireRewards(cutoffTime);
    }

    private void executeConsoleCommand(PlayerEnv tgt_playerEnv, String itemCommand) {
        String command = itemCommand.replace("{player}", tgt_playerEnv.name);
        ConsoleCommandSender console = Bukkit.getServer().getConsoleSender();
        Bukkit.dispatchCommand((CommandSender)console, (String)command);
    }

    private ItemStack getHeadItem(String headId) {
        try {
            if (this.headDatabaseAPI != null) {
                Class<?> apiClass = Class.forName("me.arcaniax.hdb.api.HeadDatabaseAPI");
                return (ItemStack)apiClass.getMethod("getItemHead", String.class).invoke(this.headDatabaseAPI, headId);
            }
            return new ItemStack(Material.PLAYER_HEAD);
        }
        catch (Exception e) {
            this.plugin.getLogger().warning("Failed to get head item: " + e.getMessage());
            return new ItemStack(Material.PLAYER_HEAD);
        }
    }
}

