/*
 * Decompiled with CFR 0.152.
 */
package com.playdelphi;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.playdelphi.DelphiVote;
import com.playdelphi.exceptions.PlayerNotFoundException;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.UUID;
import java.util.logging.Logger;

public class UtilsManager {
    private final DelphiVote plugin;
    private Logger logger;

    public UtilsManager(DelphiVote plugin) {
        this.plugin = plugin;
        this.logger = plugin.getLogger();
    }

    public UUID mojangUUIDLookup(String playerName) throws PlayerNotFoundException {
        try {
            URL url = new URL("https://api.mojang.com/users/profiles/minecraft/" + playerName);
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("GET");
            int responseCode = connection.getResponseCode();
            if (responseCode == 200) {
                String inputLine;
                BufferedReader in = new BufferedReader(new InputStreamReader(connection.getInputStream()));
                StringBuilder response = new StringBuilder();
                while ((inputLine = in.readLine()) != null) {
                    response.append(inputLine);
                }
                in.close();
                JsonObject jsonObject = JsonParser.parseString(response.toString()).getAsJsonObject();
                String uuidString = jsonObject.get("id").getAsString();
                return UUID.fromString(uuidString.replaceFirst("(\\p{XDigit}{8})(\\p{XDigit}{4})(\\p{XDigit}{4})(\\p{XDigit}{4})(\\p{XDigit}+)", "$1-$2-$3-$4-$5"));
            }
            this.logger.warning("Failed to find UUID for player " + playerName + ". Response code: " + responseCode);
            throw new PlayerNotFoundException("Player not found: " + playerName);
        }
        catch (Exception e) {
            this.logger.warning("mojangUUIDLookup Error: " + e.getMessage());
            throw new PlayerNotFoundException(playerName);
        }
    }
}

