/*
 * Decompiled with CFR 0.152.
 */
package com.playdelphi;

import com.playdelphi.DatabaseManager;
import com.playdelphi.DelphiVote;
import com.playdelphi.LanguageManager;
import com.playdelphi.PlayerEnv;
import com.playdelphi.PlayerEnvManager;
import com.playdelphi.RewardManager;
import java.util.Map;
import java.util.logging.Logger;

public class VoteManager {
    private final DelphiVote plugin;
    private Logger logger;
    private final LanguageManager languageManager;
    private final DatabaseManager databaseManager;
    private final RewardManager rewardManager;
    private final PlayerEnvManager playerEnvManager;

    public VoteManager(DelphiVote plugin) {
        this.plugin = plugin;
        this.databaseManager = plugin.getDatabaseManager();
        this.languageManager = plugin.getLanguageManager();
        this.logger = plugin.getLogger();
        this.rewardManager = plugin.getRewardManager();
        this.playerEnvManager = plugin.getPlayerEnvManager();
    }

    public void handleVote(PlayerEnv playerEnv, PlayerEnv tgt_playerEnv, String serviceName) {
        block6: {
            if (tgt_playerEnv.uuid == null && tgt_playerEnv.player != null) {
                playerEnv.player.sendMessage("Unable to resolve UUID for " + tgt_playerEnv.name + ". Vote not recorded.");
                return;
            }
            try {
                this.databaseManager.addVote(playerEnv, tgt_playerEnv, serviceName);
                if (playerEnv.uuid != tgt_playerEnv.uuid && playerEnv.player != null) {
                    playerEnv.player.sendMessage(this.languageManager.getMessage("vote_success", Map.of("player", tgt_playerEnv.name, "service", serviceName)));
                }
                if (tgt_playerEnv.player != null) {
                    tgt_playerEnv.player.sendMessage(this.languageManager.getMessage("vote_success_player", Map.of("service", serviceName)));
                }
                if (!serviceName.equals("Admin")) {
                    this.plugin.getServer().broadcastMessage(this.languageManager.getMessage("vote_success_broadcast", Map.of("player", tgt_playerEnv.name, "service", serviceName)));
                }
            }
            catch (Exception e) {
                this.logger.severe("Error adding vote: " + e.getMessage());
                if (playerEnv.player == null) break block6;
                playerEnv.player.sendMessage(this.languageManager.getMessage("vote_fail", Map.of("player", tgt_playerEnv.name, "service", serviceName)));
            }
        }
        this.rewardManager.handleTriggers(playerEnv, tgt_playerEnv, serviceName);
    }
}

