/*
 * Decompiled with CFR 0.152.
 */
package com.playdelphi;

import com.playdelphi.DelphiVote;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.snakeyaml.engine.v2.api.Dump;
import org.snakeyaml.engine.v2.api.DumpSettings;
import org.snakeyaml.engine.v2.api.Load;
import org.snakeyaml.engine.v2.api.LoadSettings;
import org.snakeyaml.engine.v2.common.FlowStyle;
import org.snakeyaml.engine.v2.common.ScalarStyle;

public class YamlManager {
    private final DelphiVote plugin;
    private final Logger logger;
    private final Load yamlLoader;
    private final Dump yamlDumper;

    public YamlManager(DelphiVote plugin) {
        this.plugin = plugin;
        this.logger = plugin.getLogger();
        LoadSettings loadSettings = LoadSettings.builder().build();
        DumpSettings dumpSettings = DumpSettings.builder().setDefaultFlowStyle(FlowStyle.BLOCK).setIndent(2).setDefaultScalarStyle(ScalarStyle.PLAIN).build();
        this.yamlLoader = new Load(loadSettings);
        this.yamlDumper = new Dump(dumpSettings);
    }

    public void processYaml(InputStream resourceStream, String localFilePath, String outputFilePath) throws IOException {
        byte[] resourceContent = resourceStream.readAllBytes();
        String commentBlock = this.extractCommentBlock(new ByteArrayInputStream(resourceContent));
        Map<String, Object> resourceData = this.loadYamlStream(new ByteArrayInputStream(resourceContent));
        Map<String, Object> localData = this.loadYamlFile(localFilePath);
        Map<String, Object> mergedData = this.mergeConfigurations(resourceData, localData);
        this.saveYaml(mergedData, outputFilePath, commentBlock);
    }

    private String extractCommentBlock(InputStream resourceStream) throws IOException {
        StringBuilder commentBlock = new StringBuilder();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(resourceStream));){
            String line;
            while ((line = reader.readLine()) != null) {
                if (line.trim().startsWith("#")) {
                    commentBlock.append(line).append("\n");
                    continue;
                }
                if (line.trim().isEmpty()) continue;
                break;
            }
        }
        return commentBlock.toString();
    }

    public Map<String, Object> loadYamlFile(String filePath) throws IOException {
        try (FileInputStream inputStream = new FileInputStream(filePath);){
            Map<String, Object> map = this.loadYamlStream(inputStream);
            return map;
        }
    }

    public Map<String, Object> loadYamlStream(InputStream inputStream) {
        Object loaded = this.yamlLoader.loadFromInputStream(inputStream);
        Map result = (Map)loaded;
        return result;
    }

    private Map<String, Object> mergeConfigurations(Map<String, Object> resourceConfig, Map<String, Object> localConfig) {
        LinkedHashMap<String, Object> mergedConfig = new LinkedHashMap<String, Object>();
        if (resourceConfig == null) {
            return localConfig;
        }
        for (Map.Entry<String, Object> entry : resourceConfig.entrySet()) {
            String key = entry.getKey();
            Object resourceValue = entry.getValue();
            Object localValue = localConfig.get(key);
            if (localValue != null) {
                if (resourceValue instanceof Map && localValue instanceof Map) {
                    mergedConfig.put(key, this.mergeConfigurations((Map)resourceValue, (Map)localValue));
                    continue;
                }
                mergedConfig.put(key, localValue);
                continue;
            }
            mergedConfig.put(key, resourceValue);
        }
        return mergedConfig;
    }

    public void saveYaml(Map<String, Object> data, String filePath, String commentBlock) throws IOException {
        try (FileWriter writer = new FileWriter(filePath);){
            writer.write(commentBlock);
            StringBuilder yamlContent = new StringBuilder();
            this.writeMapToYaml(data, yamlContent, 0);
            writer.write(yamlContent.toString());
        }
    }

    private void writeMapToYaml(Map<String, Object> map, StringBuilder builder, int indent) {
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            builder.append(" ".repeat(indent));
            builder.append(entry.getKey()).append(": ");
            Object value = entry.getValue();
            if (value instanceof Map) {
                builder.append("\n");
                Map nestedMap = (Map)value;
                this.writeMapToYaml(nestedMap, builder, indent + 2);
                continue;
            }
            if (value instanceof Collection) {
                builder.append("\n");
                for (Object item : (Collection)value) {
                    builder.append(" ".repeat(indent + 2)).append("- ");
                    if (item instanceof Map) {
                        Map mapItem = (Map)item;
                        String firstKey = (String)mapItem.keySet().iterator().next();
                        Object firstValue = mapItem.get(firstKey);
                        builder.append(firstKey).append(": ");
                        if (firstValue instanceof Map || firstValue instanceof Collection) {
                            builder.append("\n");
                            this.writeValue(firstValue, builder, indent + 4);
                        } else {
                            builder.append(this.formatValue(firstValue != null ? firstValue.toString() : "")).append("\n");
                        }
                        mapItem.entrySet().stream().skip(1L).forEach(e -> {
                            builder.append(" ".repeat(indent + 4)).append((String)e.getKey()).append(": ");
                            if (e.getValue() instanceof Map || e.getValue() instanceof Collection) {
                                builder.append("\n");
                                this.writeValue(e.getValue(), builder, indent + 6);
                            } else {
                                builder.append(this.formatValue(e.getValue() != null ? e.getValue().toString() : "")).append("\n");
                            }
                        });
                        continue;
                    }
                    String itemStr = this.formatValue(item != null ? item.toString() : "");
                    builder.append(itemStr).append("\n");
                }
                continue;
            }
            String stringValue = this.formatValue(value != null ? value.toString() : "");
            builder.append(stringValue).append("\n");
        }
    }

    private void writeValue(Object value, StringBuilder builder, int indent) {
        if (value instanceof Map) {
            Map mapValue = (Map)value;
            this.writeMapToYaml(mapValue, builder, indent);
        } else if (value instanceof Collection) {
            for (Object item : (Collection)value) {
                builder.append(" ".repeat(indent)).append("- ").append(this.formatValue(item != null ? item.toString() : "")).append("\n");
            }
        }
    }

    private String formatValue(String value) {
        if ((((String)(value = ((String)value).replace("\n", "\\n"))).contains("\"") || ((String)value).contains("\\n") || ((String)value).contains("&") || ((String)value).startsWith(" ") || ((String)value).endsWith(" ")) && !((String)value).startsWith("\"")) {
            value = "\"" + (String)value + "\"";
        }
        return value;
    }
}

