/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.jarjarbinks;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.function.Supplier;
import mod.azure.azurelib.AzureLib;
import mod.azure.jarjarbinks.CommonMod;
import mod.azure.jarjarbinks.entity.DarthJarJarEntity;
import mod.azure.jarjarbinks.entity.JarJarBinksEntity;
import mod.azure.jarjarbinks.registry.ModEntities;
import mod.azure.jarjarbinks.registry.ModItems;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.SpawnPlacementTypes;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.levelgen.Heightmap;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.common.Mod;
import net.neoforged.neoforge.common.world.BiomeModifier;
import net.neoforged.neoforge.event.BuildCreativeModeTabContentsEvent;
import net.neoforged.neoforge.event.entity.EntityAttributeCreationEvent;
import net.neoforged.neoforge.event.entity.RegisterSpawnPlacementsEvent;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.neoforged.neoforge.registries.NeoForgeRegistries;
import org.jetbrains.annotations.NotNull;

@Mod(value="jarjarbinks")
public final class NeoForgeMod {
    public static DeferredRegister<EntityType<?>> entityTypeDeferredRegister = DeferredRegister.create((ResourceKey)Registries.ENTITY_TYPE, (String)"jarjarbinks");
    public static DeferredRegister<Item> itemDeferredRegister = DeferredRegister.create((ResourceKey)Registries.ITEM, (String)"jarjarbinks");
    public static DeferredRegister<SoundEvent> soundEventDeferredRegister = DeferredRegister.create((ResourceKey)Registries.SOUND_EVENT, (String)"jarjarbinks");

    public NeoForgeMod(IEventBus modEventBus) {
        AzureLib.initialize();
        CommonMod.initRegistries();
        ModEntitySpawn.SERIALIZER.register(modEventBus);
        if (entityTypeDeferredRegister != null) {
            entityTypeDeferredRegister.register(modEventBus);
        }
        if (itemDeferredRegister != null) {
            itemDeferredRegister.register(modEventBus);
        }
        if (soundEventDeferredRegister != null) {
            soundEventDeferredRegister.register(modEventBus);
        }
        modEventBus.addListener(this::addCreativeTabs);
        modEventBus.addListener(this::createEntityAttributes);
        modEventBus.addListener(this::createSpawnPlacements);
    }

    public void createSpawnPlacements(RegisterSpawnPlacementsEvent event) {
        event.register(ModEntities.JARJAR.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, JarJarBinksEntity::canSpawn, RegisterSpawnPlacementsEvent.Operation.AND);
        event.register(ModEntities.DARTHJARJAR.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, JarJarBinksEntity::canSpawn, RegisterSpawnPlacementsEvent.Operation.AND);
    }

    public void createEntityAttributes(EntityAttributeCreationEvent event) {
        event.put(ModEntities.JARJAR.get(), JarJarBinksEntity.createMobAttributes().build());
        event.put(ModEntities.DARTHJARJAR.get(), DarthJarJarEntity.createMobAttributes().build());
    }

    public void addCreativeTabs(BuildCreativeModeTabContentsEvent event) {
        if (event.getTabKey() == CreativeModeTabs.SPAWN_EGGS) {
            event.accept((ItemLike)ModItems.JARJAR_SPAWN_EGG.get());
            event.accept((ItemLike)ModItems.DARTHJARJAR_SPAWN_EGG.get());
        }
    }

    record ModEntitySpawn(HolderSet<Biome> biomes, MobSpawnSettings.SpawnerData spawn) implements BiomeModifier
    {
        public static DeferredRegister<MapCodec<? extends BiomeModifier>> SERIALIZER = DeferredRegister.create((ResourceKey)NeoForgeRegistries.Keys.BIOME_MODIFIER_SERIALIZERS, (String)"jarjarbinks");
        static Supplier<MapCodec<ModEntitySpawn>> JARJAR_SPAWN_CODEC = SERIALIZER.register("mobspawns", () -> RecordCodecBuilder.mapCodec(builder -> builder.group((App)Biome.LIST_CODEC.fieldOf("biomes").forGetter(ModEntitySpawn::biomes), (App)MobSpawnSettings.SpawnerData.CODEC.fieldOf("spawn").forGetter(ModEntitySpawn::spawn)).apply((Applicative)builder, ModEntitySpawn::new)));

        public void modify(@NotNull Holder<Biome> biome, @NotNull BiomeModifier.Phase phase, // Could not load outer class - annotation placement on inner may be incorrect
         @NotNull ModifiableBiomeInfo.BiomeInfo.Builder builder) {
            if (phase == BiomeModifier.Phase.ADD && this.biomes.contains(biome)) {
                builder.getMobSpawnSettings().addSpawn(MobCategory.MONSTER, this.spawn);
            }
        }

        @NotNull
        public MapCodec<? extends BiomeModifier> codec() {
            return JARJAR_SPAWN_CODEC.get();
        }
    }
}

