/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.jarjarbinks.entity;

import mod.azure.jarjarbinks.entity.AmphibiousNavigation;
import mod.azure.jarjarbinks.entity.animations.AnimationDispatcher;
import mod.azure.jarjarbinks.registry.ModSounds;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.LookControl;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.control.SmoothSwimmingLookControl;
import net.minecraft.world.entity.ai.control.SmoothSwimmingMoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomSwimmingGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.animal.Cod;
import net.minecraft.world.entity.animal.Dolphin;
import net.minecraft.world.entity.animal.Pufferfish;
import net.minecraft.world.entity.animal.Salmon;
import net.minecraft.world.entity.animal.Squid;
import net.minecraft.world.entity.animal.TropicalFish;
import net.minecraft.world.entity.animal.Turtle;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class JarJarBinksEntity
extends PathfinderMob {
    protected final GroundPathNavigation landNavigation = new GroundPathNavigation((Mob)this, this.getCommandSenderWorld());
    protected final AmphibiousNavigation swimNavigation = new AmphibiousNavigation((Mob)this, this.getCommandSenderWorld());
    protected final MoveControl landMoveControl = new MoveControl((Mob)this);
    protected final LookControl landLookControl = new LookControl((Mob)this);
    protected final SmoothSwimmingMoveControl swimMoveControl = new SmoothSwimmingMoveControl((Mob)this, 85, 10, 0.5f, 1.0f, false);
    protected final SmoothSwimmingLookControl swimLookControl = new SmoothSwimmingLookControl((Mob)this, 10);
    public AnimationDispatcher dispatcher;

    public JarJarBinksEntity(EntityType<? extends JarJarBinksEntity> entityType, Level worldIn) {
        super(entityType, worldIn);
        this.navigation = this.landNavigation;
        this.moveControl = this.landMoveControl;
        this.lookControl = this.landLookControl;
        this.dispatcher = new AnimationDispatcher((Entity)this);
    }

    public static // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull AttributeSupplier.Builder createMobAttributes() {
        return LivingEntity.createLivingAttributes().add(Attributes.FOLLOW_RANGE, 50.0).add(Attributes.MAX_HEALTH, 15.0).add(Attributes.ATTACK_KNOCKBACK, 0.1).add(Attributes.KNOCKBACK_RESISTANCE, 0.0).add(Attributes.MOVEMENT_SPEED, 0.25).add(Attributes.ATTACK_DAMAGE, 1.0);
    }

    public static boolean canSpawn(EntityType<? extends JarJarBinksEntity> type, LevelAccessor world, MobSpawnType reason, BlockPos pos, RandomSource random) {
        return world.getDifficulty() != Difficulty.PEACEFUL;
    }

    public void travel(@NotNull Vec3 movementInput) {
        this.navigation = this.wasEyeInWater || this.isInWater() ? this.swimNavigation : this.landNavigation;
        this.moveControl = this.wasEyeInWater || this.isInWater() ? this.swimMoveControl : this.landMoveControl;
        Object object = this.lookControl = this.wasEyeInWater || this.isInWater() ? this.swimLookControl : this.landLookControl;
        if (this.tickCount % 10 == 0) {
            this.refreshDimensions();
        }
        if (this.isEffectiveAi() && this.isInWater()) {
            this.moveRelative(this.getSpeed(), movementInput);
            this.move(MoverType.SELF, this.getDeltaMovement());
            this.setDeltaMovement(this.getDeltaMovement().scale(0.35));
            if (this.getTarget() == null) {
                this.setDeltaMovement(this.getDeltaMovement().add(0.0, -0.005, 0.0));
            }
        } else {
            super.travel(movementInput);
        }
    }

    @NotNull
    public PathNavigation createNavigation(@NotNull Level world) {
        return this.swimNavigation;
    }

    public boolean isPushedByFluid() {
        return false;
    }

    protected void jumpInLiquid(@NotNull TagKey<Fluid> fluid) {
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(2, (Goal)new MeleeAttackGoal(this, this, 1.3, false){

            protected void checkAndPerformAttack(LivingEntity target) {
                super.checkAndPerformAttack(target);
                PathfinderMob pathfinderMob = this.mob;
                if (pathfinderMob instanceof JarJarBinksEntity) {
                    JarJarBinksEntity jarJarBinksEntity = (JarJarBinksEntity)pathfinderMob;
                    jarJarBinksEntity.dispatcher.sendAttackAnimation();
                }
            }
        });
        this.goalSelector.addGoal(6, (Goal)new RandomLookAroundGoal((Mob)this));
        this.goalSelector.addGoal(2, (Goal)new RandomSwimmingGoal((PathfinderMob)this, 1.0, 10));
        this.goalSelector.addGoal(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.goalSelector.addGoal(5, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 0.8));
        this.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Cod.class, true));
        this.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Pufferfish.class, true));
        this.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Salmon.class, true));
        this.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)this, TropicalFish.class, true));
        this.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Squid.class, true));
        this.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Turtle.class, true));
        this.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Dolphin.class, true));
        this.targetSelector.addGoal(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
    }

    public void tick() {
        super.tick();
        if (this.level().isClientSide) {
            if (this.isInWater()) {
                this.dispatcher.sendIdleWaterAnimation();
            } else {
                this.dispatcher.sendIdleAnimation();
            }
        }
    }

    protected SoundEvent getAmbientSound() {
        return ModSounds.JARNORMAL.get();
    }

    protected SoundEvent getHurtSound(@NotNull DamageSource damageSourceIn) {
        return ModSounds.JARHURT.get();
    }

    protected SoundEvent getDeathSound() {
        return ModSounds.JARDEATH.get();
    }

    @NotNull
    public EntityDimensions getDefaultDimensions(@NotNull Pose pose) {
        return this.wasEyeInWater ? EntityDimensions.scalable((float)1.5f, (float)0.8f) : super.getDefaultDimensions(pose);
    }
}

