/*
 * Decompiled with CFR 0.152.
 */
package org.bxteam.commons.folia.scheduler;

import io.papermc.paper.threadedregions.scheduler.AsyncScheduler;
import io.papermc.paper.threadedregions.scheduler.GlobalRegionScheduler;
import io.papermc.paper.threadedregions.scheduler.RegionScheduler;
import java.util.concurrent.TimeUnit;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.plugin.Plugin;
import org.bxteam.commons.folia.scheduler.FoliaScheduledTask;
import org.bxteam.commons.scheduler.Scheduler;
import org.bxteam.commons.scheduler.Task;

public class FoliaScheduler
implements Scheduler {
    final Plugin plugin;
    private final RegionScheduler regionScheduler = Bukkit.getServer().getRegionScheduler();
    private final GlobalRegionScheduler globalRegionScheduler = Bukkit.getServer().getGlobalRegionScheduler();
    private final AsyncScheduler asyncScheduler = Bukkit.getServer().getAsyncScheduler();

    public FoliaScheduler(Plugin plugin) {
        this.plugin = plugin;
    }

    @Override
    public boolean isGlobalThread() {
        return Bukkit.getServer().isGlobalTickThread();
    }

    @Override
    public boolean isTickThread() {
        return Bukkit.getServer().isPrimaryThread();
    }

    @Override
    public boolean isEntityThread(Entity entity) {
        return Bukkit.getServer().isOwnedByCurrentRegion(entity);
    }

    @Override
    public boolean isRegionThread(Location location) {
        return Bukkit.getServer().isOwnedByCurrentRegion(location);
    }

    @Override
    public Task runTask(Runnable runnable) {
        return new FoliaScheduledTask(this.globalRegionScheduler.run(this.plugin, task -> runnable.run()));
    }

    @Override
    public Task runTaskLater(Runnable runnable, long delay) {
        if (delay <= 0L) {
            return this.runTask(runnable);
        }
        return new FoliaScheduledTask(this.globalRegionScheduler.runDelayed(this.plugin, task -> runnable.run(), delay));
    }

    @Override
    public Task runTaskTimer(Runnable runnable, long delay, long period) {
        delay = this.getOneIfNotPositive(delay);
        return new FoliaScheduledTask(this.globalRegionScheduler.runAtFixedRate(this.plugin, task -> runnable.run(), delay, period));
    }

    @Override
    public Task runTask(Location location, Runnable runnable) {
        return new FoliaScheduledTask(this.regionScheduler.run(this.plugin, location, task -> runnable.run()));
    }

    @Override
    public Task runTaskLater(Location location, Runnable runnable, long delay) {
        if (delay <= 0L) {
            return this.runTask(runnable);
        }
        return new FoliaScheduledTask(this.regionScheduler.runDelayed(this.plugin, location, task -> runnable.run(), delay));
    }

    @Override
    public Task runTaskTimer(Location location, Runnable runnable, long delay, long period) {
        delay = this.getOneIfNotPositive(delay);
        return new FoliaScheduledTask(this.regionScheduler.runAtFixedRate(this.plugin, location, task -> runnable.run(), delay, period));
    }

    @Override
    public Task runTask(Entity entity, Runnable runnable) {
        return new FoliaScheduledTask(entity.getScheduler().run(this.plugin, task -> runnable.run(), null));
    }

    @Override
    public Task runTaskLater(Entity entity, Runnable runnable, long delay) {
        if (delay <= 0L) {
            return this.runTask(entity, runnable);
        }
        return new FoliaScheduledTask(entity.getScheduler().runDelayed(this.plugin, task -> runnable.run(), null, delay));
    }

    @Override
    public Task runTaskTimer(Entity entity, Runnable runnable, long delay, long period) {
        delay = this.getOneIfNotPositive(delay);
        return new FoliaScheduledTask(entity.getScheduler().runAtFixedRate(this.plugin, task -> runnable.run(), null, delay, period));
    }

    @Override
    public Task runTaskAsynchronously(Runnable runnable) {
        return new FoliaScheduledTask(this.asyncScheduler.runNow(this.plugin, task -> runnable.run()));
    }

    @Override
    public Task runTaskLaterAsynchronously(Runnable runnable, long delay) {
        delay = this.getOneIfNotPositive(delay);
        return new FoliaScheduledTask(this.asyncScheduler.runDelayed(this.plugin, task -> runnable.run(), delay * 50L, TimeUnit.MILLISECONDS));
    }

    @Override
    public Task runTaskTimerAsynchronously(Runnable runnable, long delay, long period) {
        return new FoliaScheduledTask(this.asyncScheduler.runAtFixedRate(this.plugin, task -> runnable.run(), delay * 50L, period * 50L, TimeUnit.MILLISECONDS));
    }

    @Override
    public void execute(Runnable runnable) {
        this.globalRegionScheduler.execute(this.plugin, runnable);
    }

    @Override
    public void execute(Location location, Runnable runnable) {
        this.regionScheduler.execute(this.plugin, location, runnable);
    }

    @Override
    public void execute(Entity entity, Runnable runnable) {
        entity.getScheduler().execute(this.plugin, runnable, null, 1L);
    }

    @Override
    public void cancelTasks() {
        this.globalRegionScheduler.cancelTasks(this.plugin);
        this.asyncScheduler.cancelTasks(this.plugin);
    }

    @Override
    public void cancelTasks(Plugin plugin) {
        this.globalRegionScheduler.cancelTasks(plugin);
        this.asyncScheduler.cancelTasks(plugin);
    }

    private long getOneIfNotPositive(long x) {
        return x <= 0L ? 1L : x;
    }
}

