/*
 * Decompiled with CFR 0.152.
 */
package org.bxteam.commons.logger;

import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import org.bxteam.commons.logger.LogEntry;
import org.bxteam.commons.logger.LogLevel;
import org.bxteam.commons.logger.Logger;
import org.bxteam.commons.logger.appender.Appender;

public class ExtendedLogger
extends Logger {
    public ExtendedLogger(String name) {
        super(name);
    }

    public ExtendedLogger(String name, LogLevel currentLevel, List<Appender> appenders, List<Function<LogEntry, Boolean>> listeners) {
        super(name, currentLevel, appenders, listeners);
    }

    public void log(LogLevel logLevel, String message) {
        LogEntry entry = new LogEntry(this.name, logLevel, message, System.currentTimeMillis(), Thread.currentThread().getId(), Thread.currentThread().getName(), null, new HashMap<String, Object>());
        super.log(logLevel, entry, this.defaultAppenders);
    }

    public void log(LogLevel logLevel, String message, Throwable throwable) {
        LogEntry entry = new LogEntry(this.name, logLevel, message, System.currentTimeMillis(), Thread.currentThread().getId(), Thread.currentThread().getName(), throwable, new HashMap<String, Object>());
        super.log(logLevel, entry, this.defaultAppenders);
    }

    public void log(LogLevel logLevel, Throwable throwable) {
        LogEntry entry = new LogEntry(this.name, logLevel, throwable.getMessage(), System.currentTimeMillis(), Thread.currentThread().getId(), Thread.currentThread().getName(), throwable, new HashMap<String, Object>());
        super.log(logLevel, entry, this.defaultAppenders);
    }

    public void debug(String message) {
        this.log(LogLevel.DEBUG, message);
    }

    public void info(String message) {
        this.log(LogLevel.INFO, message);
    }

    public void warn(String message) {
        this.log(LogLevel.WARN, message);
    }

    public void warn(Throwable throwable) {
        this.log(LogLevel.WARN, throwable);
    }

    public void error(String message) {
        this.log(LogLevel.ERROR, message);
    }

    public void error(Throwable throwable) {
        this.log(LogLevel.ERROR, throwable);
    }
}

