/*
 * Decompiled with CFR 0.152.
 */
package org.bxteam.commons.logger;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.bxteam.commons.logger.LogEntry;
import org.bxteam.commons.logger.LogLevel;
import org.bxteam.commons.logger.appender.Appender;
import org.bxteam.commons.logger.appender.ConsoleAppender;

public class Logger {
    private static final Logger GLOBAL_LOGGER = new Logger("Commons-Global");
    private static final ExecutorService executor = Executors.newSingleThreadExecutor(r -> {
        Thread t = new Thread(r, "Commons-Logger");
        t.setDaemon(true);
        return t;
    });
    protected final String name;
    protected final List<Appender> defaultAppenders;
    protected final List<Function<LogEntry, Boolean>> listeners;
    protected LogLevel currentLevel;

    public Logger(String name) {
        this.name = name;
        this.currentLevel = LogLevel.INFO;
        this.defaultAppenders = new ArrayList<Appender>();
        this.defaultAppenders.add(new ConsoleAppender());
        this.listeners = new ArrayList<Function<LogEntry, Boolean>>();
    }

    public Logger(String name, LogLevel currentLevel, List<Appender> appenders, List<Function<LogEntry, Boolean>> listeners) {
        this.name = name;
        this.currentLevel = currentLevel;
        this.defaultAppenders = new ArrayList<Appender>(appenders);
        this.listeners = new ArrayList<Function<LogEntry, Boolean>>(listeners);
    }

    public static Logger getGlobalLogger() {
        return GLOBAL_LOGGER;
    }

    public void log(LogLevel logLevel, LogEntry logEntry, List<Appender> appenders) {
        for (Function<LogEntry, Boolean> listener : this.listeners) {
            if (listener.apply(logEntry).booleanValue()) continue;
            return;
        }
        if (logLevel.ordinal() < this.currentLevel.ordinal()) {
            return;
        }
        executor.submit(() -> {
            try {
                for (Appender appender : appenders) {
                    appender.append(logEntry);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
    }

    public String getName() {
        return this.name;
    }

    public void addAppender(Appender appender) {
        this.defaultAppenders.add(appender);
    }

    public void addListener(Function<LogEntry, Boolean> listener) {
        this.listeners.add(listener);
    }

    public void setCurrentLevel(LogLevel currentLevel) {
        this.currentLevel = currentLevel;
    }

    static {
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            executor.shutdown();
            try {
                if (!executor.awaitTermination(5L, TimeUnit.SECONDS)) {
                    executor.shutdownNow();
                }
            }
            catch (InterruptedException e) {
                executor.shutdownNow();
            }
        }));
    }
}

