/*
 * Decompiled with CFR 0.152.
 */
package org.bxteam.commons.logger.appender;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import org.bxteam.commons.logger.ExtendedLogger;
import org.bxteam.commons.logger.LogEntry;
import org.bxteam.commons.logger.appender.Appender;

public class JsonAppender
implements Appender {
    private static final ExtendedLogger logger = new ExtendedLogger("JsonAppender");
    private final boolean printToConsole;
    private final boolean printToFile;
    private final String filePath;
    private final Gson gson;

    public JsonAppender(boolean prettyPrint, boolean printToConsole, boolean printToFile, String filePath) {
        this.printToConsole = printToConsole;
        this.printToFile = printToFile;
        this.filePath = filePath;
        GsonBuilder gsonBuilder = new GsonBuilder();
        if (prettyPrint) {
            gsonBuilder.setPrettyPrinting();
        }
        gsonBuilder.registerTypeAdapterFactory((TypeAdapterFactory)new ThrowableTypeAdapterFactory());
        this.gson = gsonBuilder.create();
    }

    @Override
    public void append(LogEntry logEntry) {
        String json = this.gson.toJson((Object)logEntry);
        if (this.printToConsole) {
            System.out.println(json);
        }
        if (this.printToFile) {
            try (BufferedWriter writer = new BufferedWriter(new FileWriter(this.filePath, true));){
                writer.write(json);
                writer.newLine();
            }
            catch (IOException e) {
                logger.warn(e);
            }
        }
    }

    @Override
    public void close() {
    }

    static class ThrowableTypeAdapterFactory
    implements TypeAdapterFactory {
        ThrowableTypeAdapterFactory() {
        }

        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!Throwable.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            return new ThrowableTypeAdapter();
        }
    }

    static class ThrowableTypeAdapter
    extends TypeAdapter<Throwable> {
        ThrowableTypeAdapter() {
        }

        public void write(JsonWriter out, Throwable throwable) throws IOException {
            if (throwable == null) {
                out.nullValue();
                return;
            }
            out.beginObject();
            out.name("type").value(throwable.getClass().getName());
            out.name("message").value(throwable.getMessage());
            out.name("stackTrace");
            out.beginArray();
            for (StackTraceElement element : throwable.getStackTrace()) {
                out.beginObject();
                out.name("className").value(element.getClassName());
                out.name("methodName").value(element.getMethodName());
                out.name("fileName").value(element.getFileName());
                out.name("lineNumber").value((long)element.getLineNumber());
                out.endObject();
            }
            out.endArray();
            Throwable cause = throwable.getCause();
            if (cause != null && cause != throwable) {
                out.name("cause");
                this.write(out, cause);
            }
            out.endObject();
        }

        public Throwable read(JsonReader in) throws IOException {
            in.beginObject();
            String message = null;
            String type = null;
            Throwable cause = null;
            block10: while (in.hasNext()) {
                String name;
                switch (name = in.nextName()) {
                    case "type": {
                        type = in.nextString();
                        continue block10;
                    }
                    case "message": {
                        message = in.nextString();
                        continue block10;
                    }
                    case "cause": {
                        cause = this.read(in);
                        continue block10;
                    }
                }
                in.skipValue();
            }
            in.endObject();
            return new Throwable(message, cause);
        }
    }
}

