/*
 * Decompiled with CFR 0.152.
 */
package org.bxteam.ndailyrewards.listener;

import com.google.inject.Inject;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.plugin.Plugin;
import org.bxteam.ndailyrewards.manager.menu.MenuManager;
import org.bxteam.ndailyrewards.manager.reward.RewardManager;
import org.bxteam.ndailyrewards.utils.TextUtils;

public class InventoryClickListener
implements Listener {
    private final Plugin plugin;
    private final RewardManager rewardManager;
    private final Map<Integer, Integer> slotToDayMap = new ConcurrentHashMap<Integer, Integer>();
    private final Map<Integer, List<String>> customButtonActions = new ConcurrentHashMap<Integer, List<String>>();

    @Inject
    public InventoryClickListener(Plugin plugin, RewardManager rewardManager) {
        this.plugin = plugin;
        this.rewardManager = rewardManager;
        this.initializeMappings();
    }

    private void initializeMappings() {
        ConfigurationSection customSection;
        ConfigurationSection daysSection = this.plugin.getConfig().getConfigurationSection("rewards.days");
        if (daysSection != null) {
            for (String dayKey : daysSection.getKeys(false)) {
                int day = Integer.parseInt(dayKey);
                ConfigurationSection daySection = daysSection.getConfigurationSection(dayKey);
                if (daySection == null) continue;
                int position = daySection.getInt("position");
                this.slotToDayMap.put(position, day);
            }
        }
        if ((customSection = this.plugin.getConfig().getConfigurationSection("gui.reward.custom")) != null) {
            for (String customKey : customSection.getKeys(false)) {
                int position = customSection.getInt(customKey + ".position");
                List actions = customSection.getStringList(customKey + ".actions");
                this.customButtonActions.put(position, actions);
            }
        }
    }

    @EventHandler
    public void mainMenuClickListener(InventoryClickEvent event) {
        if (!(event.getInventory().getHolder() instanceof MenuManager.MainMenuHolder)) {
            return;
        }
        if (event.getCurrentItem() == null || event.getCurrentItem().getType() == Material.AIR) {
            return;
        }
        event.setCancelled(true);
        Player player = (Player)event.getWhoClicked();
        int slot = event.getSlot();
        Integer day = this.slotToDayMap.get(slot);
        if (day != null && day > 0) {
            this.rewardManager.handleReward(player, day);
            return;
        }
        List<String> actions = this.customButtonActions.get(slot);
        if (actions != null && !actions.isEmpty()) {
            this.executeActions(player, actions);
        }
    }

    private void executeActions(Player player, List<String> actions) {
        for (String action : actions) {
            String command;
            if (action.startsWith("[console]")) {
                command = action.substring("[console]".length()).trim();
                Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)command);
                continue;
            }
            if (action.startsWith("[player]")) {
                command = action.substring("[player]".length()).trim();
                player.performCommand(command);
                continue;
            }
            if (action.startsWith("[message]")) {
                String message = action.substring("[message]".length()).trim();
                player.sendMessage(TextUtils.applyColor(message));
                continue;
            }
            if (action.startsWith("[actionbar]")) {
                String actionBarMessage = action.substring("[actionbar]".length()).trim();
                player.sendActionBar(TextUtils.applyColor(actionBarMessage));
                continue;
            }
            if (action.startsWith("[sound]")) {
                String[] soundParams = action.substring("[sound]".length()).trim().split(":");
                if (soundParams.length < 1) continue;
                try {
                    Sound sound = Sound.valueOf((String)soundParams[0].toUpperCase());
                    float volume = soundParams.length > 1 ? Float.parseFloat(soundParams[1]) : 1.0f;
                    float pitch = soundParams.length > 2 ? Float.parseFloat(soundParams[2]) : 1.0f;
                    player.playSound(player.getLocation(), sound, volume, pitch);
                }
                catch (IllegalArgumentException e) {
                    player.sendMessage(TextUtils.applyColor("&cInvalid sound specified: " + soundParams[0]));
                }
                continue;
            }
            if (!action.startsWith("[close]")) continue;
            player.closeInventory();
        }
    }
}

