/*
 * Decompiled with CFR 0.152.
 */
package org.bxteam.ndailyrewards.listener;

import com.google.inject.Inject;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import lombok.Generated;
import org.apache.maven.artifact.versioning.ComparableVersion;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.plugin.Plugin;
import org.bxteam.commons.logger.ExtendedLogger;
import org.bxteam.commons.scheduler.Scheduler;
import org.bxteam.commons.updater.VersionFetcher;
import org.bxteam.ndailyrewards.api.event.AutoClaimEvent;
import org.bxteam.ndailyrewards.api.event.PlayerReceiveReminderEvent;
import org.bxteam.ndailyrewards.configuration.Language;
import org.bxteam.ndailyrewards.event.EventCaller;
import org.bxteam.ndailyrewards.manager.menu.MenuManager;
import org.bxteam.ndailyrewards.manager.reward.PlayerRewardData;
import org.bxteam.ndailyrewards.manager.reward.RewardManager;
import org.bxteam.ndailyrewards.utils.Permissions;
import org.bxteam.ndailyrewards.utils.SoundUtil;
import org.bxteam.ndailyrewards.utils.TextUtils;

public class PlayerJoinListener
implements Listener {
    private final Plugin plugin;
    private final RewardManager rewardManager;
    private final MenuManager menuManager;
    private final ExtendedLogger logger;
    private final VersionFetcher versionFetcher;
    private final Scheduler scheduler;
    private final EventCaller eventCaller;
    private final SoundUtil soundUtil;

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        UUID uuid = player.getUniqueId();
        ((CompletableFuture)this.rewardManager.createInitialPlayerData(uuid).thenAccept(initialData -> this.checkPlayerRewards(player))).exceptionally(throwable -> {
            this.logger.error("Could not create initial player data: %s".formatted(throwable.getMessage()));
            return null;
        });
    }

    private void checkPlayerRewards(Player player) {
        this.rewardManager.getPlayerRewardDataAsync(player.getUniqueId()).thenAccept(playerRewardData -> {
            if (playerRewardData == null) {
                return;
            }
            int currentDay = playerRewardData.currentDay() + 1;
            if (this.rewardManager.isRewardAvailable((PlayerRewardData)playerRewardData, currentDay)) {
                this.rewardManager.checkResetForPlayerAsync(player.getUniqueId()).thenAccept(wasReset -> {
                    if (wasReset.booleanValue()) {
                        player.sendMessage(Language.PREFIX.asColoredString() + Language.CLAIM_REWARD_RESET.asColoredString());
                        return;
                    }
                    long delayTime = this.plugin.getConfig().getLong("events.auto-claim-delay");
                    if (this.plugin.getConfig().getBoolean("events.auto-claim-reward")) {
                        this.scheduler.runTaskLater(() -> {
                            this.rewardManager.giveReward(player, currentDay);
                            this.eventCaller.callEvent(new AutoClaimEvent(player, currentDay));
                        }, delayTime * 20L);
                    }
                    if (this.plugin.getConfig().getBoolean("events.open-gui-when-available")) {
                        this.scheduler.runTask(() -> {
                            this.menuManager.openRewardsMenu(player);
                            if (this.plugin.getConfig().getBoolean("sound.open.enabled")) {
                                this.soundUtil.playSound(player, "open");
                            }
                        });
                    }
                    if (this.plugin.getConfig().getBoolean("events.notify-when-available")) {
                        player.sendMessage(Language.PREFIX.asColoredString() + Language.EVENTS_NOTIFY_WHEN_AVAILABLE.asColoredString());
                        this.eventCaller.callEvent(new PlayerReceiveReminderEvent(player, currentDay));
                    }
                });
            }
        });
    }

    @EventHandler
    public void updateChecker(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        if (this.plugin.getConfig().getBoolean("check-updates") && player.hasPermission(Permissions.UPDATE_NOTIFY)) {
            ComparableVersion current = new ComparableVersion(this.plugin.getDescription().getVersion());
            ((CompletableFuture)CompletableFuture.supplyAsync(this.versionFetcher::fetchNewestVersion).thenApply(Objects::requireNonNull)).whenComplete((newest, error) -> {
                if (error != null || newest.compareTo(current) <= 0) {
                    return;
                }
                player.sendMessage(TextUtils.applyColor(Language.PREFIX.asString() + "&aA new update is available: &e" + String.valueOf(newest)));
                player.sendMessage(TextUtils.applyColor(Language.PREFIX.asString() + "&aDownload here: &e" + this.versionFetcher.getDownloadUrl()));
            });
        }
    }

    @Inject
    @Generated
    public PlayerJoinListener(Plugin plugin, RewardManager rewardManager, MenuManager menuManager, ExtendedLogger logger, VersionFetcher versionFetcher, Scheduler scheduler, EventCaller eventCaller, SoundUtil soundUtil) {
        this.plugin = plugin;
        this.rewardManager = rewardManager;
        this.menuManager = menuManager;
        this.logger = logger;
        this.versionFetcher = versionFetcher;
        this.scheduler = scheduler;
        this.eventCaller = eventCaller;
        this.soundUtil = soundUtil;
    }
}

