/*
 * Decompiled with CFR 0.152.
 */
package org.bxteam.quark.classloader;

import java.net.URLClassLoader;
import java.nio.file.Path;
import java.util.Objects;
import org.bxteam.quark.LibraryManager;
import org.bxteam.quark.classloader.URLClassLoaderAccessor;
import org.jetbrains.annotations.NotNull;

public class URLClassLoaderHelper {
    private final URLClassLoaderAccessor accessor;
    private final LibraryManager libraryManager;

    public URLClassLoaderHelper(@NotNull URLClassLoader classLoader, @NotNull LibraryManager libraryManager) {
        this.libraryManager = Objects.requireNonNull(libraryManager, "Library manager cannot be null");
        this.accessor = URLClassLoaderAccessor.create(Objects.requireNonNull(classLoader, "Class loader cannot be null"));
        if (this.accessor == null) {
            throw new IllegalStateException("Failed to create URLClassLoader accessor for: " + String.valueOf(classLoader.getClass()));
        }
    }

    public void addToClasspath(@NotNull Path jarPath) {
        Objects.requireNonNull(jarPath, "JAR path cannot be null");
        try {
            this.accessor.addJarToClasspath(jarPath);
            this.libraryManager.getLogger().debug("Added JAR to classpath: " + String.valueOf(jarPath.getFileName()));
        }
        catch (Exception e) {
            throw new URLClassLoaderAccessor.ClassLoaderAccessException("Failed to add JAR to classpath: " + String.valueOf(jarPath), e);
        }
    }

    @NotNull
    public URLClassLoaderAccessor getAccessor() {
        return this.accessor;
    }

    @NotNull
    public String getAccessorType() {
        return this.accessor.getType();
    }

    public String toString() {
        return "URLClassLoaderHelper{accessorType=" + this.getAccessorType() + "}";
    }
}

