/*
 * Decompiled with CFR 0.152.
 */
package org.bxteam.quark.relocation;

import java.util.Objects;
import org.bxteam.quark.util.StringUtils;
import org.jetbrains.annotations.NotNull;

public record Relocation(@NotNull String pattern, @NotNull String relocatedPattern) {
    public Relocation(@NotNull String pattern, @NotNull String relocatedPattern) {
        this.pattern = StringUtils.sanitizePath(Objects.requireNonNull(pattern, "Pattern cannot be null"));
        this.relocatedPattern = StringUtils.sanitizePath(Objects.requireNonNull(relocatedPattern, "Relocated pattern cannot be null"));
    }

    @NotNull
    public static RelocationBuilder builder() {
        return new RelocationBuilder();
    }

    @NotNull
    public static Relocation of(@NotNull String from, @NotNull String to) {
        return new Relocation(from, to);
    }

    public boolean isEffective() {
        return !this.pattern.equals(this.relocatedPattern);
    }

    @NotNull
    public String getDescription() {
        return this.pattern + " -> " + this.relocatedPattern;
    }

    @Override
    public String toString() {
        return this.getDescription();
    }

    public static final class RelocationBuilder {
        private String pattern;
        private String relocatedPattern;

        private RelocationBuilder() {
        }

        @NotNull
        public RelocationBuilder from(@NotNull String pattern) {
            this.pattern = pattern;
            return this;
        }

        @NotNull
        public RelocationBuilder to(@NotNull String relocatedPattern) {
            this.relocatedPattern = relocatedPattern;
            return this;
        }

        @NotNull
        public Relocation build() {
            if (this.pattern == null || this.relocatedPattern == null) {
                throw new IllegalStateException("Both pattern and relocated pattern must be set");
            }
            return new Relocation(this.pattern, this.relocatedPattern);
        }
    }
}

