/*
 * Decompiled with CFR 0.152.
 */
package org.bxteam.quark.relocation;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.bxteam.quark.LibraryManager;
import org.bxteam.quark.classloader.IsolatedClassLoader;
import org.bxteam.quark.classloader.IsolatedClassLoaderImpl;
import org.bxteam.quark.dependency.Dependency;
import org.bxteam.quark.relocation.Relocation;
import org.bxteam.quark.relocation.RelocationCacheResolver;
import org.bxteam.quark.repository.LocalRepository;
import org.jetbrains.annotations.NotNull;

public class RelocationHandler
implements AutoCloseable {
    private static final List<Dependency> RELOCATION_DEPENDENCIES = List.of(Dependency.of("org.ow2.asm", "asm", "9.7"), Dependency.of("org.ow2.asm", "asm-commons", "9.7"), Dependency.of("me.lucko", "jar-relocator", "1.7"));
    private static final String JAR_RELOCATOR_CLASS = "me.lucko.jarrelocator.JarRelocator";
    private static final String JAR_RELOCATOR_RUN_METHOD = "run";
    private final IsolatedClassLoader classLoader;
    private final Constructor<?> jarRelocatorConstructor;
    private final Method jarRelocatorRunMethod;
    private final RelocationCacheResolver cacheResolver;

    private RelocationHandler(@NotNull IsolatedClassLoader classLoader, @NotNull Constructor<?> jarRelocatorConstructor, @NotNull Method jarRelocatorRunMethod, @NotNull RelocationCacheResolver cacheResolver) {
        this.classLoader = Objects.requireNonNull(classLoader, "Class loader cannot be null");
        this.jarRelocatorConstructor = Objects.requireNonNull(jarRelocatorConstructor, "JAR relocator constructor cannot be null");
        this.jarRelocatorRunMethod = Objects.requireNonNull(jarRelocatorRunMethod, "JAR relocator run method cannot be null");
        this.cacheResolver = Objects.requireNonNull(cacheResolver, "Cache resolver cannot be null");
    }

    @NotNull
    public Path relocateDependency(@NotNull LocalRepository localRepository, @NotNull Path dependencyPath, @NotNull Dependency dependency, @NotNull List<Relocation> relocations) {
        Objects.requireNonNull(localRepository, "Local repository cannot be null");
        Objects.requireNonNull(dependencyPath, "Dependency path cannot be null");
        Objects.requireNonNull(dependency, "Dependency cannot be null");
        Objects.requireNonNull(relocations, "Relocations cannot be null");
        if (relocations.isEmpty()) {
            return dependencyPath;
        }
        Path relocatedJar = this.getRelocatedJarPath(localRepository, dependency);
        if (Files.exists(relocatedJar, new LinkOption[0]) && !this.cacheResolver.shouldForceRelocate(dependency, relocations)) {
            return relocatedJar;
        }
        return this.relocate(dependency, dependencyPath, relocatedJar, relocations);
    }

    @NotNull
    private Path getRelocatedJarPath(@NotNull LocalRepository localRepository, @NotNull Dependency dependency) {
        Dependency relocatedDependency = dependency.withClassifier("relocated");
        return relocatedDependency.getJarPath(localRepository.getPath());
    }

    @NotNull
    private Path relocate(@NotNull Dependency dependency, @NotNull Path input, @NotNull Path output, @NotNull List<Relocation> relocations) {
        HashMap<String, String> mappings = new HashMap<String, String>();
        for (Relocation relocation : relocations) {
            mappings.put(relocation.pattern(), relocation.relocatedPattern());
        }
        try {
            Path outputParent = output.getParent();
            if (outputParent != null) {
                Files.createDirectories(outputParent, new FileAttribute[0]);
            }
            Files.deleteIfExists(output);
            Object relocator = this.jarRelocatorConstructor.newInstance(input.toFile(), output.toFile(), mappings);
            this.jarRelocatorRunMethod.invoke(relocator, new Object[0]);
            this.cacheResolver.markAsRelocated(dependency, relocations);
            if (!Files.exists(output, new LinkOption[0])) {
                throw new RelocationException("Relocation failed to create output file: " + String.valueOf(output));
            }
            return output;
        }
        catch (IOException | IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new RelocationException("Failed to relocate JAR for dependency: " + dependency.toShortString(), e);
        }
    }

    @NotNull
    public static RelocationHandler create(@NotNull LibraryManager libraryManager) {
        Objects.requireNonNull(libraryManager, "Library manager cannot be null");
        IsolatedClassLoaderImpl classLoader = new IsolatedClassLoaderImpl();
        try {
            libraryManager.loadDependencies(classLoader, RELOCATION_DEPENDENCIES, Collections.emptyList());
            Class<?> jarRelocatorClass = classLoader.loadClass(JAR_RELOCATOR_CLASS);
            Constructor<?> jarRelocatorConstructor = jarRelocatorClass.getDeclaredConstructor(File.class, File.class, Map.class);
            jarRelocatorConstructor.setAccessible(true);
            Method jarRelocatorRunMethod = jarRelocatorClass.getDeclaredMethod(JAR_RELOCATOR_RUN_METHOD, new Class[0]);
            jarRelocatorRunMethod.setAccessible(true);
            RelocationCacheResolver cacheResolver = new RelocationCacheResolver(libraryManager.getLocalRepository());
            return new RelocationHandler(classLoader, jarRelocatorConstructor, jarRelocatorRunMethod, cacheResolver);
        }
        catch (ClassNotFoundException | NoSuchMethodException e) {
            throw new RelocationException("Failed to initialize relocation handler", e);
        }
    }

    @NotNull
    public static List<Dependency> getRelocationDependencies() {
        return List.copyOf(RELOCATION_DEPENDENCIES);
    }

    @Override
    public void close() {
        try {
            this.classLoader.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String toString() {
        return "RelocationHandler{classLoader=" + this.classLoader.getClass().getSimpleName() + "}";
    }

    public static class RelocationException
    extends RuntimeException {
        public RelocationException(String message) {
            super(message);
        }

        public RelocationException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

