/*
 * Decompiled with CFR 0.152.
 */
package org.bxteam.quark.repository;

import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public class Repository {
    protected final String baseUrl;

    protected Repository(@NotNull String url) {
        this.baseUrl = Repository.normalizeUrl(Objects.requireNonNull(url, "Repository URL cannot be null"));
    }

    @NotNull
    public String getUrl() {
        return this.baseUrl;
    }

    @NotNull
    public String url() {
        return this.baseUrl;
    }

    @NotNull
    public static Repository of(@NotNull String url) {
        return new Repository(url);
    }

    @NotNull
    private static String normalizeUrl(@NotNull String url) {
        String trimmed = url.trim();
        while (trimmed.endsWith("/")) {
            trimmed = trimmed.substring(0, trimmed.length() - 1);
        }
        return trimmed;
    }

    @NotNull
    public String getArtifactUrl(@NotNull String artifactPath) {
        Objects.requireNonNull(artifactPath, "Artifact path cannot be null");
        String normalizedPath = artifactPath.startsWith("/") ? artifactPath.substring(1) : artifactPath;
        return this.baseUrl + "/" + normalizedPath;
    }

    public boolean isLocal() {
        return this.baseUrl.startsWith("file:");
    }

    public boolean isRemote() {
        return this.baseUrl.startsWith("http:") || this.baseUrl.startsWith("https:");
    }

    @NotNull
    public String getType() {
        if (this.isLocal()) {
            return "local";
        }
        if (this.isRemote()) {
            return "remote";
        }
        return "unknown";
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Repository that = (Repository)obj;
        return this.baseUrl.equals(that.baseUrl);
    }

    public int hashCode() {
        return this.baseUrl.hashCode();
    }

    public String toString() {
        return this.baseUrl;
    }
}

