/*
 * Decompiled with CFR 0.152.
 */
package org.bxteam.quark.util;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class StringUtils {
    private static final String BRACE_PLACEHOLDER = "{}";
    private static final String DOT_REPLACEMENT = ".";

    private StringUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated.");
    }

    @NotNull
    public static String sanitizePath(@NotNull String input) {
        if (input == null) {
            throw new NullPointerException("Input string cannot be null");
        }
        return input.replace(BRACE_PLACEHOLDER, DOT_REPLACEMENT);
    }

    public static boolean isBlank(@Nullable String str) {
        return str == null || str.trim().isEmpty();
    }

    public static boolean isNotBlank(@Nullable String str) {
        return !StringUtils.isBlank(str);
    }

    @NotNull
    public static String defaultIfBlank(@Nullable String str, @NotNull String defaultValue) {
        return StringUtils.isBlank(str) ? defaultValue : str;
    }
}

