/*
 * Decompiled with CFR 0.152.
 */
package io.icker.factions.api.events;

import io.icker.factions.api.persistents.Faction;
import io.icker.factions.api.persistents.Home;
import io.icker.factions.api.persistents.User;
import net.fabricmc.fabric.api.event.Event;
import net.fabricmc.fabric.api.event.EventFactory;

public final class FactionEvents {
    public static final Event<Create> CREATE = EventFactory.createArrayBacked(Create.class, callbacks -> (faction, user) -> {
        for (Create callback : callbacks) {
            callback.onCreate(faction, user);
        }
    });
    public static final Event<Disband> DISBAND = EventFactory.createArrayBacked(Disband.class, callbacks -> faction -> {
        for (Disband callback : callbacks) {
            callback.onDisband(faction);
        }
    });
    public static final Event<MemberJoin> MEMBER_JOIN = EventFactory.createArrayBacked(MemberJoin.class, callbacks -> (faction, user) -> {
        for (MemberJoin callback : callbacks) {
            callback.onMemberJoin(faction, user);
        }
    });
    public static final Event<MemberLeave> MEMBER_LEAVE = EventFactory.createArrayBacked(MemberLeave.class, callbacks -> (faction, user) -> {
        for (MemberLeave callback : callbacks) {
            callback.onMemberLeave(faction, user);
        }
    });
    public static final Event<Modify> MODIFY = EventFactory.createArrayBacked(Modify.class, callbacks -> faction -> {
        for (Modify callback : callbacks) {
            callback.onModify(faction);
        }
    });
    public static final Event<PowerChange> POWER_CHANGE = EventFactory.createArrayBacked(PowerChange.class, callbacks -> (faction, oldPower) -> {
        for (PowerChange callback : callbacks) {
            callback.onPowerChange(faction, oldPower);
        }
    });
    public static final Event<SetHome> SET_HOME = EventFactory.createArrayBacked(SetHome.class, callbacks -> (faction, home) -> {
        for (SetHome callback : callbacks) {
            callback.onSetHome(faction, home);
        }
    });
    public static final Event<RemoveAllClaims> REMOVE_ALL_CLAIMS = EventFactory.createArrayBacked(RemoveAllClaims.class, callbacks -> faction -> {
        for (RemoveAllClaims callback : callbacks) {
            callback.onRemoveAllClaims(faction);
        }
    });

    @FunctionalInterface
    public static interface RemoveAllClaims {
        public void onRemoveAllClaims(Faction var1);
    }

    @FunctionalInterface
    public static interface SetHome {
        public void onSetHome(Faction var1, Home var2);
    }

    @FunctionalInterface
    public static interface PowerChange {
        public void onPowerChange(Faction var1, int var2);
    }

    @FunctionalInterface
    public static interface Modify {
        public void onModify(Faction var1);
    }

    @FunctionalInterface
    public static interface MemberLeave {
        public void onMemberLeave(Faction var1, User var2);
    }

    @FunctionalInterface
    public static interface MemberJoin {
        public void onMemberJoin(Faction var1, User var2);
    }

    @FunctionalInterface
    public static interface Disband {
        public void onDisband(Faction var1);
    }

    @FunctionalInterface
    public static interface Create {
        public void onCreate(Faction var1, User var2);
    }
}

