/*
 * Decompiled with CFR 0.152.
 */
package io.icker.factions.api.persistents;

import io.icker.factions.FactionsMod;
import io.icker.factions.api.events.FactionEvents;
import io.icker.factions.api.persistents.Claim;
import io.icker.factions.api.persistents.Home;
import io.icker.factions.api.persistents.Relationship;
import io.icker.factions.api.persistents.User;
import io.icker.factions.database.Database;
import io.icker.factions.database.Field;
import io.icker.factions.database.Name;
import io.icker.factions.util.WorldUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import java.util.stream.Stream;
import net.minecraft.class_124;
import net.minecraft.class_1277;
import net.minecraft.class_1799;
import net.minecraft.class_2371;
import org.jetbrains.annotations.Nullable;

@Name(value="Faction")
public class Faction {
    private static final HashMap<UUID, Faction> STORE = Database.load(Faction.class, Faction::getID);
    @Field(value="ID")
    private UUID id;
    @Field(value="Name")
    private String name;
    @Field(value="Description")
    private String description;
    @Field(value="MOTD")
    private String motd;
    @Field(value="Color")
    private String color;
    @Field(value="Open")
    private boolean open;
    @Field(value="Power")
    private int power;
    @Field(value="AdminPower")
    private int adminPower;
    @Field(value="Home")
    private Home home;
    @Field(value="Safe")
    private class_1277 safe = new class_1277(54);
    @Field(value="Invites")
    public ArrayList<UUID> invites = new ArrayList();
    @Field(value="Relationships")
    private ArrayList<Relationship> relationships = new ArrayList();
    @Field(value="GuestPermissions")
    public ArrayList<Relationship.Permissions> guest_permissions;

    public Faction(String name, String description, String motd, class_124 color, boolean open, int power) {
        this.guest_permissions = new ArrayList<Relationship.Permissions>(FactionsMod.CONFIG.RELATIONSHIPS.DEFAULT_GUEST_PERMISSIONS);
        this.id = UUID.randomUUID();
        this.name = name;
        this.motd = motd;
        this.description = description;
        this.color = color.method_537();
        this.open = open;
        this.power = power;
    }

    public Faction() {
        this.guest_permissions = new ArrayList<Relationship.Permissions>(FactionsMod.CONFIG.RELATIONSHIPS.DEFAULT_GUEST_PERMISSIONS);
    }

    public Stream<Relationship> getRelationships() {
        return this.relationships.stream().filter(rel -> Faction.get(rel.target) != null);
    }

    public String getKey() {
        return this.id.toString();
    }

    @Nullable
    public static Faction get(UUID id) {
        return STORE.get(id);
    }

    @Nullable
    public static Faction getByName(String name) {
        return STORE.values().stream().filter(f -> f.name.equals(name)).findFirst().orElse(null);
    }

    public static void add(Faction faction) {
        STORE.put(faction.id, faction);
    }

    public static Collection<Faction> all() {
        return STORE.values();
    }

    public static List<Faction> allBut(UUID id) {
        return STORE.values().stream().filter(f -> f.id != id).toList();
    }

    public UUID getID() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public class_124 getColor() {
        return class_124.method_533((String)this.color);
    }

    public String getDescription() {
        return this.description;
    }

    public String getMOTD() {
        return this.motd;
    }

    public int getPower() {
        return this.power + this.adminPower;
    }

    public class_1277 getSafe() {
        return this.safe;
    }

    public class_2371<class_1799> clearSafe() {
        class_2371 stacks = this.safe.field_5828;
        this.safe = new class_1277(54);
        return stacks;
    }

    public boolean isOpen() {
        return this.open;
    }

    public void setName(String name) {
        this.name = name;
        ((FactionEvents.Modify)FactionEvents.MODIFY.invoker()).onModify(this);
    }

    public void setDescription(String description) {
        this.description = description;
        ((FactionEvents.Modify)FactionEvents.MODIFY.invoker()).onModify(this);
    }

    public void setMOTD(String motd) {
        this.motd = motd;
        ((FactionEvents.Modify)FactionEvents.MODIFY.invoker()).onModify(this);
    }

    public void setColor(class_124 color) {
        this.color = color.method_537();
        ((FactionEvents.Modify)FactionEvents.MODIFY.invoker()).onModify(this);
    }

    public void setOpen(boolean open) {
        this.open = open;
        ((FactionEvents.Modify)FactionEvents.MODIFY.invoker()).onModify(this);
    }

    public int adjustPower(int adjustment) {
        int oldPower;
        int maxPower = this.calculateMaxPower();
        int newPower = Math.min(Math.max(0, this.power + adjustment), maxPower);
        if (newPower == (oldPower = this.power)) {
            return 0;
        }
        this.power = newPower;
        ((FactionEvents.PowerChange)FactionEvents.POWER_CHANGE.invoker()).onPowerChange(this, oldPower);
        return Math.abs(newPower - oldPower);
    }

    public int getAdminPower() {
        return this.adminPower;
    }

    public void addAdminPower(int amount) {
        this.adminPower += amount;
    }

    public List<User> getUsers() {
        return User.getByFaction(this.id);
    }

    public List<Claim> getClaims() {
        return Claim.getByFaction(this.id);
    }

    public void removeAllClaims() {
        Claim.getByFaction(this.id).stream().forEach(Claim::remove);
        ((FactionEvents.RemoveAllClaims)FactionEvents.REMOVE_ALL_CLAIMS.invoker()).onRemoveAllClaims(this);
    }

    public void addClaim(int x, int z, String level) {
        Claim.add(new Claim(x, z, level, this.id));
    }

    public boolean isInvited(UUID playerID) {
        return this.invites.stream().anyMatch(invite -> invite.equals(playerID));
    }

    public Home getHome() {
        return this.home;
    }

    public void setHome(Home home) {
        this.home = home;
        ((FactionEvents.SetHome)FactionEvents.SET_HOME.invoker()).onSetHome(this, home);
    }

    public Relationship getRelationship(UUID target) {
        return this.relationships.stream().filter(rel -> rel.target.equals(target)).findFirst().orElse(new Relationship(target, Relationship.Status.NEUTRAL));
    }

    public Relationship getReverse(Relationship rel) {
        return Faction.get(rel.target).getRelationship(this.id);
    }

    public boolean isMutualAllies(UUID target) {
        Relationship rel = this.getRelationship(target);
        return rel.status == Relationship.Status.ALLY && this.getReverse((Relationship)rel).status == Relationship.Status.ALLY;
    }

    public List<Relationship> getMutualAllies() {
        return this.getRelationships().filter(rel -> this.isMutualAllies(rel.target)).toList();
    }

    public List<Relationship> getEnemiesWith() {
        return this.getRelationships().filter(rel -> rel.status == Relationship.Status.ENEMY).toList();
    }

    public List<Relationship> getEnemiesOf() {
        return this.getRelationships().filter(rel -> this.getReverse((Relationship)rel).status == Relationship.Status.ENEMY).toList();
    }

    public void removeRelationship(UUID target) {
        this.relationships = new ArrayList<Relationship>(this.getRelationships().filter(rel -> !rel.target.equals(target)).toList());
    }

    public void setRelationship(Relationship relationship) {
        if (this.getRelationship(relationship.target) != null) {
            this.removeRelationship(relationship.target);
        }
        if (relationship.status != Relationship.Status.NEUTRAL || !relationship.permissions.isEmpty()) {
            this.relationships.add(relationship);
        }
    }

    public void remove() {
        for (User user : this.getUsers()) {
            user.leaveFaction();
        }
        for (Relationship rel : this.relationships) {
            Faction target = Faction.get(rel.target);
            if (target == null) continue;
            target.removeRelationship(this.id);
        }
        this.removeAllClaims();
        STORE.remove(this.id);
        ((FactionEvents.Disband)FactionEvents.DISBAND.invoker()).onDisband(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Faction faction = (Faction)o;
        return this.id.equals(faction.id);
    }

    public static void audit() {
        STORE.values().removeIf(faction -> {
            if (faction.home != null && !WorldUtils.isValid(faction.home.level)) {
                faction.setHome(null);
            }
            faction.relationships.removeIf(rel -> Faction.get(rel.target) == null);
            return faction.getUsers().stream().noneMatch(user -> user.rank == User.Rank.OWNER);
        });
    }

    public static void save() {
        Database.save(Faction.class, STORE.values().stream().toList());
    }

    public int calculateMaxPower() {
        return FactionsMod.CONFIG.POWER.BASE + this.getUsers().size() * FactionsMod.CONFIG.POWER.MEMBER + this.getMutualAllies().size() * FactionsMod.CONFIG.POWER.POWER_PER_ALLY;
    }
}

