/*
 * Decompiled with CFR 0.152.
 */
package io.icker.factions.api.persistents;

import io.icker.factions.api.events.FactionEvents;
import io.icker.factions.api.persistents.Faction;
import io.icker.factions.database.Database;
import io.icker.factions.database.Field;
import io.icker.factions.database.Name;
import io.icker.factions.util.WorldUtils;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import net.minecraft.class_3222;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="User")
public class User {
    private static final HashMap<UUID, User> STORE = Database.load(User.class, User::getID);
    @Field(value="ID")
    private UUID id;
    @Field(value="FactionID")
    private UUID factionID;
    @Field(value="Rank")
    public Rank rank;
    @Field(value="Radar")
    public boolean radar = false;
    @Field(value="Chat")
    public ChatMode chat = ChatMode.GLOBAL;
    @Field(value="Sounds")
    public SoundMode sounds = SoundMode.ALL;
    @Field(value="HomeCooldown")
    public long homeCooldown = -1L;
    public boolean autoclaim = false;
    public boolean bypass = false;
    private User spoof;

    public User(UUID id) {
        this.id = id;
    }

    public User() {
    }

    public String getKey() {
        return this.id.toString();
    }

    @NotNull
    public static User get(UUID id) {
        if (!STORE.containsKey(id)) {
            User.add(new User(id));
        }
        return STORE.get(id);
    }

    public static List<User> getByFaction(UUID factionID) {
        return STORE.values().stream().filter(m -> m.isInFaction() && m.factionID.equals(factionID)).toList();
    }

    public static void add(User user) {
        STORE.put(user.id, user);
    }

    public UUID getID() {
        return this.id;
    }

    public boolean isInFaction() {
        return this.factionID != null;
    }

    private String getEnumName(Enum<?> value) {
        return value.name().toLowerCase();
    }

    public String getRankName() {
        return this.getEnumName(this.rank);
    }

    public String getChatName() {
        return this.getEnumName(this.chat);
    }

    public String getSoundName() {
        return this.getEnumName(this.sounds);
    }

    @Nullable
    public Faction getFaction() {
        return Faction.get(this.factionID);
    }

    public User getSpoof() {
        return this.spoof;
    }

    public void setSpoof(User user) {
        this.spoof = user;
    }

    public void joinFaction(UUID factionID, Rank rank) {
        this.factionID = factionID;
        this.rank = rank;
        ((FactionEvents.MemberJoin)FactionEvents.MEMBER_JOIN.invoker()).onMemberJoin(Faction.get(factionID), this);
    }

    public void leaveFaction() {
        UUID oldFactionID = this.factionID;
        this.factionID = null;
        this.rank = null;
        ((FactionEvents.MemberLeave)FactionEvents.MEMBER_LEAVE.invoker()).onMemberLeave(Faction.get(oldFactionID), this);
    }

    public static Collection<User> all() {
        return STORE.values();
    }

    public static void audit() {
        STORE.values().forEach(user -> {
            if (Faction.get(user.factionID) == null) {
                user.factionID = null;
            }
            if (!user.isInFaction()) {
                user.rank = null;
            }
        });
    }

    @Nullable
    public String getLanguage() {
        class_3222 player = WorldUtils.server.method_3760().method_14602(this.id);
        if (player == null) {
            return null;
        }
        return player.method_53823().comp_1951();
    }

    public static void save() {
        Database.save(User.class, STORE.values().stream().toList());
    }

    public static enum ChatMode {
        FOCUS,
        FACTION,
        GLOBAL;

    }

    public static enum SoundMode {
        NONE,
        WARNINGS,
        FACTION,
        ALL;

    }

    public static enum Rank {
        OWNER,
        LEADER,
        COMMANDER,
        MEMBER,
        GUEST;

    }
}

