/*
 * Decompiled with CFR 0.152.
 */
package io.icker.factions.command;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.tree.LiteralCommandNode;
import io.icker.factions.api.events.RelationshipEvents;
import io.icker.factions.api.persistents.Faction;
import io.icker.factions.api.persistents.Relationship;
import io.icker.factions.util.Command;
import io.icker.factions.util.Message;
import java.util.Locale;
import java.util.UUID;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_5250;

public class DeclareCommand
implements Command {
    private int ally(CommandContext<class_2168> context) throws CommandSyntaxException {
        return this.updateRelationship(context, Relationship.Status.ALLY);
    }

    private int neutral(CommandContext<class_2168> context) throws CommandSyntaxException {
        return this.updateRelationship(context, Relationship.Status.NEUTRAL);
    }

    private int enemy(CommandContext<class_2168> context) throws CommandSyntaxException {
        return this.updateRelationship(context, Relationship.Status.ENEMY);
    }

    private int updateRelationship(CommandContext<class_2168> context, Relationship.Status status) throws CommandSyntaxException {
        class_5250 msgStatus;
        String name = StringArgumentType.getString(context, (String)"faction");
        class_2168 source = (class_2168)context.getSource();
        class_3222 player = source.method_9207();
        Faction targetFaction = Faction.getByName(name);
        if (targetFaction == null) {
            new Message(class_2561.method_43471((String)"factions.command.declare.fail.nonexistent_faction")).fail().send((class_1657)player, false);
            return 0;
        }
        Faction sourceFaction = Command.getUser(player).getFaction();
        if (sourceFaction.equals(targetFaction)) {
            new Message(class_2561.method_43471((String)"factions.command.declare.fail.own_faction")).fail().send((class_1657)player, false);
            return 0;
        }
        if (sourceFaction.getRelationship((UUID)targetFaction.getID()).status == status) {
            new Message(class_2561.method_43471((String)"factions.command.declare.fail.no_change")).fail().send((class_1657)player, false);
            return 0;
        }
        Relationship.Status mutual = null;
        if (sourceFaction.getRelationship((UUID)targetFaction.getID()).status == targetFaction.getRelationship((UUID)sourceFaction.getID()).status) {
            mutual = sourceFaction.getRelationship((UUID)targetFaction.getID()).status;
        }
        Relationship rel = new Relationship(targetFaction.getID(), status);
        Relationship rev = targetFaction.getRelationship(sourceFaction.getID());
        sourceFaction.setRelationship(rel);
        ((RelationshipEvents.NewDecleration)RelationshipEvents.NEW_DECLARATION.invoker()).onNewDecleration(rel);
        class_5250 class_52502 = rel.status == Relationship.Status.ALLY ? class_2561.method_43471((String)"factions.command.declare.success.status.ally").method_27692(class_124.field_1060) : (msgStatus = rel.status == Relationship.Status.ENEMY ? class_2561.method_43471((String)"factions.command.declare.success.status.enemy").method_27692(class_124.field_1061) : class_2561.method_43471((String)"factions.command.declare.success.status.neutral"));
        if (rel.status == rev.status) {
            ((RelationshipEvents.NewMutual)RelationshipEvents.NEW_MUTUAL.invoker()).onNewMutual(rel);
            new Message(class_2561.method_43469((String)"factions.command.declare.success.mutual", (Object[])new Object[]{msgStatus, targetFaction.getName()})).send(sourceFaction);
            new Message(class_2561.method_43469((String)"factions.command.declare.success.mutual", (Object[])new Object[]{msgStatus, sourceFaction.getName()})).send(targetFaction);
            return 1;
        }
        if (mutual != null) {
            ((RelationshipEvents.EndMutual)RelationshipEvents.END_MUTUAL.invoker()).onEndMutual(rel, mutual);
        }
        new Message(class_2561.method_43469((String)"factions.command.declare.success.actor", (Object[])new Object[]{targetFaction.getName(), msgStatus})).send(sourceFaction);
        if (rel.status != Relationship.Status.NEUTRAL) {
            new Message(class_2561.method_43469((String)"factions.command.declare.success.subject", (Object[])new Object[]{sourceFaction.getName(), msgStatus})).hover((class_2561)class_2561.method_43471((String)"factions.command.declare.success.subject.hover")).click(String.format("/factions declare %s %s", rel.status.toString().toLowerCase(Locale.ROOT), sourceFaction.getName())).send(targetFaction);
        }
        return 1;
    }

    @Override
    public LiteralCommandNode<class_2168> getNode() {
        return ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"declare").requires(Command.Requires.isLeader())).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"ally").requires(Command.Requires.hasPerms("factions.declare.ally", 0))).then(class_2170.method_9244((String)"faction", (ArgumentType)StringArgumentType.greedyString()).suggests(Command.Suggests.allFactions(false)).executes(this::ally)))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"neutral").requires(Command.Requires.hasPerms("factions.declare.neutral", 0))).then(class_2170.method_9244((String)"faction", (ArgumentType)StringArgumentType.greedyString()).suggests(Command.Suggests.allFactions(false)).executes(this::neutral)))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"enemy").requires(Command.Requires.hasPerms("factions.declare.enemy", 0))).then(class_2170.method_9244((String)"faction", (ArgumentType)StringArgumentType.greedyString()).suggests(Command.Suggests.allFactions(false)).executes(this::enemy)))).build();
    }
}

