/*
 * Decompiled with CFR 0.152.
 */
package io.icker.factions.command;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.tree.LiteralCommandNode;
import io.icker.factions.FactionsMod;
import io.icker.factions.api.persistents.Faction;
import io.icker.factions.api.persistents.User;
import io.icker.factions.util.Command;
import io.icker.factions.util.Message;
import net.minecraft.class_1657;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2561;
import net.minecraft.class_3222;

public class JoinCommand
implements Command {
    private int run(CommandContext<class_2168> context) throws CommandSyntaxException {
        String name = StringArgumentType.getString(context, (String)"name");
        class_2168 source = (class_2168)context.getSource();
        class_3222 player = source.method_9207();
        Faction faction = Faction.getByName(name);
        if (faction == null) {
            new Message(class_2561.method_43471((String)"factions.command.join.fail.nonexistent_faction")).fail().send((class_1657)player, false);
            return 0;
        }
        boolean invited = faction.isInvited(player.method_5667());
        if (!faction.isOpen() && !invited) {
            new Message(class_2561.method_43471((String)"factions.command.join.fail.private_no_invite")).fail().send((class_1657)player, false);
            return 0;
        }
        if (FactionsMod.CONFIG.MAX_FACTION_SIZE != -1 && faction.getUsers().size() >= FactionsMod.CONFIG.MAX_FACTION_SIZE) {
            new Message(class_2561.method_43471((String)"factions.command.join.fail.faction_full")).fail().send((class_1657)player, false);
            return 0;
        }
        if (invited) {
            faction.invites.remove(player.method_5667());
        }
        Command.getUser(player).joinFaction(faction.getID(), User.Rank.MEMBER);
        source.method_9211().method_3760().method_14576(player);
        new Message(class_2561.method_43469((String)"factions.command.join.success", (Object[])new Object[]{player.method_5477().getString()})).send(faction);
        faction.adjustPower(FactionsMod.CONFIG.POWER.MEMBER);
        return 1;
    }

    @Override
    public LiteralCommandNode<class_2168> getNode() {
        return ((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"join").requires(Command.Requires.multiple(Command.Requires.isFactionless(), Command.Requires.hasPerms("factions.join", 0)))).then(class_2170.method_9244((String)"name", (ArgumentType)StringArgumentType.greedyString()).suggests(Command.Suggests.openInvitedFactions()).executes(this::run))).build();
    }
}

