/*
 * Decompiled with CFR 0.152.
 */
package io.icker.factions.command;

import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.tree.LiteralCommandNode;
import io.icker.factions.api.persistents.User;
import io.icker.factions.util.Command;
import io.icker.factions.util.Message;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import xyz.nucleoid.server.translations.api.Localization;

public class KickCommand
implements Command {
    private int run(CommandContext<class_2168> context) throws CommandSyntaxException {
        User target;
        class_2168 source = (class_2168)context.getSource();
        class_3222 player = source.method_9207();
        String name = StringArgumentType.getString(context, (String)"player");
        Optional profile = source.method_9211().method_73550().comp_4624().method_73289(name);
        if (profile.isPresent()) {
            target = User.get(((GameProfile)profile.get()).id());
        } else {
            try {
                target = User.get(UUID.fromString(name));
            }
            catch (Exception e) {
                new Message(class_2561.method_43469((String)"factions.gui.spoof.fail.no_player", (Object[])new Object[]{name})).format(class_124.field_1061).send((class_1657)player, false);
                return 0;
            }
        }
        if (target.getID().equals(player.method_5667())) {
            new Message(class_2561.method_43471((String)"factions.command.kick.fail.self")).fail().send((class_1657)player, false);
            return 0;
        }
        User selfUser = Command.getUser(player);
        if (target.getFaction() == null || !target.getFaction().equals(selfUser.getFaction())) {
            new Message(class_2561.method_43471((String)"factions.command.kick.fail.other_faction")).fail().send((class_1657)player, false);
            return 0;
        }
        if (selfUser.rank == User.Rank.LEADER && (target.rank == User.Rank.LEADER || target.rank == User.Rank.OWNER)) {
            new Message(class_2561.method_43471((String)"factions.command.kick.fail.high_rank")).fail().send((class_1657)player, false);
            return 0;
        }
        class_3222 targetPlayer = player.method_51469().method_8503().method_3760().method_14602(target.getID());
        target.leaveFaction();
        if (targetPlayer != null) {
            ((class_2168)context.getSource()).method_9211().method_3760().method_14576(targetPlayer);
            new Message(class_2561.method_43469((String)"factions.command.kick.success.subject", (Object[])new Object[]{player.method_5477().getString()})).send((class_1657)targetPlayer, false);
        }
        new Message(class_2561.method_43469((String)"factions.command.kick.success.actor", (Object[])new Object[]{profile.map(found_profile -> found_profile.name()).orElse(Localization.raw((String)"factions.gui.members.entry.unknown_player", (class_3222)player))})).send((class_1657)player, false);
        return 1;
    }

    @Override
    public LiteralCommandNode<class_2168> getNode() {
        return ((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"kick").requires(Command.Requires.multiple(Command.Requires.isLeader(), Command.Requires.hasPerms("factions.kick", 0)))).then(class_2170.method_9244((String)"player", (ArgumentType)StringArgumentType.string()).suggests(Command.Suggests.allPlayersInYourFactionButYou()).executes(this::run))).build();
    }
}

