/*
 * Decompiled with CFR 0.152.
 */
package io.icker.factions.command;

import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.tree.LiteralCommandNode;
import io.icker.factions.FactionsMod;
import io.icker.factions.api.persistents.Faction;
import io.icker.factions.api.persistents.User;
import io.icker.factions.ui.MemberGui;
import io.icker.factions.util.Command;
import io.icker.factions.util.Message;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.class_11755;
import net.minecraft.class_124;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import xyz.nucleoid.server.translations.api.Localization;

public class MemberCommand
implements Command {
    private int self(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_2168 source = (class_2168)context.getSource();
        class_3222 player = source.method_9207();
        User user = Command.getUser(player);
        if (!user.isInFaction()) {
            new Message(class_2561.method_43471((String)"factions.command.members.fail.no_faction")).fail().send((class_1657)player, false);
            return 0;
        }
        return MemberCommand.members(player, user.getFaction());
    }

    private int any(CommandContext<class_2168> context) throws CommandSyntaxException {
        String factionName = StringArgumentType.getString(context, (String)"faction");
        class_2168 source = (class_2168)context.getSource();
        class_3222 player = source.method_9207();
        Faction faction = Faction.getByName(factionName);
        if (faction == null) {
            new Message(class_2561.method_43471((String)"factions.command.members.faction.nonexistent_faction")).fail().send((class_1657)player, false);
            return 0;
        }
        return MemberCommand.members(player, faction);
    }

    public static int members(class_3222 player, Faction faction) {
        if (FactionsMod.CONFIG.GUI) {
            new MemberGui(player, faction, null);
            return 1;
        }
        List<User> users = faction.getUsers();
        class_11755 resolver = player.method_51469().method_8503().method_73550().comp_4624();
        long memberCount = users.stream().filter(u -> u.rank == User.Rank.MEMBER).count();
        String members = String.valueOf(class_124.field_1068) + users.stream().filter(u -> u.rank == User.Rank.MEMBER).map(user -> resolver.method_73290(user.getID()).orElse(new GameProfile(class_156.field_25140, Localization.raw((String)"factions.gui.generic.unknown_player", (class_3222)player))).name()).collect(Collectors.joining(", "));
        long commanderCount = users.stream().filter(u -> u.rank == User.Rank.COMMANDER).count();
        String commanders = String.valueOf(class_124.field_1068) + users.stream().filter(u -> u.rank == User.Rank.COMMANDER).map(user -> resolver.method_73290(user.getID()).orElse(new GameProfile(class_156.field_25140, Localization.raw((String)"factions.gui.generic.unknown_player", (class_3222)player))).name()).collect(Collectors.joining(", "));
        long leaderCount = users.stream().filter(u -> u.rank == User.Rank.LEADER).count();
        String leaders = String.valueOf(class_124.field_1068) + users.stream().filter(u -> u.rank == User.Rank.LEADER).map(user -> resolver.method_73290(user.getID()).orElse(new GameProfile(class_156.field_25140, Localization.raw((String)"factions.gui.generic.unknown_player", (class_3222)player))).name()).collect(Collectors.joining(", "));
        String owner = String.valueOf(class_124.field_1068) + users.stream().filter(u -> u.rank == User.Rank.OWNER).map(user -> resolver.method_73290(user.getID()).orElse(new GameProfile(class_156.field_25140, Localization.raw((String)"factions.gui.generic.unknown_player", (class_3222)player))).name()).collect(Collectors.joining(", "));
        int numDashes = 32 - faction.getName().length();
        String dashes = new StringBuilder("--------------------------------").substring(0, numDashes / 2);
        new Message(String.valueOf(class_124.field_1074) + dashes + "[ " + String.valueOf(faction.getColor()) + faction.getName() + String.valueOf(class_124.field_1074) + " ]" + dashes).send((class_1657)player, false);
        new Message(class_2561.method_43469((String)"factions.command.members.faction.title", (Object[])new Object[]{class_124.field_1068.toString() + users.size()}).method_27692(class_124.field_1065)).send((class_1657)player, false);
        new Message(class_2561.method_43469((String)"factions.command.members.faction.owner", (Object[])new Object[]{owner}).method_27692(class_124.field_1065)).send((class_1657)player, false);
        new Message(class_2561.method_43469((String)"factions.command.members.faction.leaders", (Object[])new Object[]{leaderCount, leaders})).send((class_1657)player, false);
        new Message(class_2561.method_43469((String)"factions.command.members.faction.commanders", (Object[])new Object[]{commanderCount, commanders})).send((class_1657)player, false);
        new Message(class_2561.method_43469((String)"factions.command.members.faction.members", (Object[])new Object[]{memberCount, members})).send((class_1657)player, false);
        return 1;
    }

    @Override
    public LiteralCommandNode<class_2168> getNode() {
        return ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"members").requires(Command.Requires.hasPerms("factions.members", 0))).executes(this::self)).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"faction", (ArgumentType)StringArgumentType.greedyString()).requires(Command.Requires.hasPerms("factions.members.other", 0))).suggests(Command.Suggests.allFactions()).executes(this::any))).build();
    }
}

