/*
 * Decompiled with CFR 0.152.
 */
package io.icker.factions.core;

import io.icker.factions.FactionsMod;
import io.icker.factions.api.events.PlayerEvents;
import io.icker.factions.api.persistents.Claim;
import io.icker.factions.api.persistents.Faction;
import io.icker.factions.api.persistents.Relationship;
import io.icker.factions.api.persistents.User;
import io.icker.factions.core.InteractionsUtil;
import io.icker.factions.mixin.BucketItemAccessor;
import io.icker.factions.mixin.ItemInvoker;
import java.util.UUID;
import net.fabricmc.fabric.api.event.player.AttackEntityCallback;
import net.fabricmc.fabric.api.event.player.PlayerBlockBreakEvents;
import net.fabricmc.fabric.api.event.player.UseBlockCallback;
import net.fabricmc.fabric.api.event.player.UseItemCallback;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1755;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1838;
import net.minecraft.class_1922;
import net.minecraft.class_1923;
import net.minecraft.class_1927;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_239;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_3966;

public class InteractionManager {
    public static void register() {
        PlayerBlockBreakEvents.BEFORE.register(InteractionManager::onBreakBlock);
        PlayerEvents.EXPLODE_BLOCK.register(InteractionManager::onExplodeBlock);
        PlayerEvents.EXPLODE_DAMAGE.register(InteractionManager::onExplodeDamage);
        UseBlockCallback.EVENT.register(InteractionManager::onUseBlock);
        UseItemCallback.EVENT.register(InteractionManager::onUseBucket);
        AttackEntityCallback.EVENT.register(InteractionManager::onAttackEntity);
        PlayerEvents.IS_INVULNERABLE.register(InteractionManager::isInvulnerableTo);
        PlayerEvents.USE_ENTITY.register(InteractionManager::onUseEntity);
        PlayerEvents.USE_INVENTORY.register(InteractionManager::onUseInventory);
        PlayerEvents.PLACE_BLOCK.register(InteractionManager::onPlaceBlock);
    }

    private static boolean onBreakBlock(class_1937 world, class_1657 player, class_2338 pos, class_2680 state, class_2586 blockEntity) {
        boolean result;
        boolean bl = result = InteractionManager.checkPermissions(player, pos, world, Relationship.Permissions.BREAK_BLOCKS) == class_1269.field_5814;
        if (result) {
            InteractionsUtil.warn(player, InteractionsUtil.InteractionsUtilActions.BREAK_BLOCKS);
        }
        return !result;
    }

    private static class_1269 onExplodeBlock(class_1927 explosion, class_1922 world, class_2338 pos, class_2680 state) {
        if (explosion.method_8347() != null && explosion.method_8347() instanceof class_1657) {
            class_1269 result = InteractionManager.checkPermissions((class_1657)explosion.method_8347(), pos, (class_1937)explosion.method_64504(), Relationship.Permissions.BREAK_BLOCKS);
            if (result == class_1269.field_5814) {
                InteractionsUtil.warn((class_1657)explosion.method_8347(), InteractionsUtil.InteractionsUtilActions.BREAK_BLOCKS);
            }
            return result;
        }
        if (!FactionsMod.CONFIG.BLOCK_TNT) {
            return class_1269.field_5811;
        }
        String dimension = explosion.method_64504().method_27983().method_29177().toString();
        class_1923 chunkPosition = explosion.method_64504().method_22350(pos).method_12004();
        Claim claim = Claim.get(chunkPosition.field_9181, chunkPosition.field_9180, dimension);
        if (claim == null) {
            return class_1269.field_5811;
        }
        Faction claimFaction = claim.getFaction();
        if (claimFaction.getClaims().size() * FactionsMod.CONFIG.POWER.CLAIM_WEIGHT > claimFaction.getPower()) {
            return class_1269.field_5811;
        }
        if (claimFaction.guest_permissions.contains((Object)Relationship.Permissions.BREAK_BLOCKS)) {
            return class_1269.field_5811;
        }
        return class_1269.field_5814;
    }

    private static class_1269 onExplodeDamage(class_1927 explosion, class_1297 entity) {
        if (explosion.method_8347() != null && explosion.method_8347() instanceof class_1657) {
            class_1269 result = InteractionManager.checkPermissions((class_1657)explosion.method_8347(), entity.method_24515(), (class_1937)explosion.method_64504(), Relationship.Permissions.ATTACK_ENTITIES);
            if (result == class_1269.field_5814) {
                InteractionsUtil.warn((class_1657)explosion.method_8347(), InteractionsUtil.InteractionsUtilActions.BREAK_BLOCKS);
            }
            return result;
        }
        if (!FactionsMod.CONFIG.BLOCK_TNT) {
            return class_1269.field_5811;
        }
        String dimension = explosion.method_64504().method_27983().method_29177().toString();
        class_1923 chunkPosition = explosion.method_64504().method_22350(entity.method_24515()).method_12004();
        Claim claim = Claim.get(chunkPosition.field_9181, chunkPosition.field_9180, dimension);
        if (claim == null) {
            return class_1269.field_5811;
        }
        Faction claimFaction = claim.getFaction();
        if (claimFaction.getClaims().size() * FactionsMod.CONFIG.POWER.CLAIM_WEIGHT > claimFaction.getPower()) {
            return class_1269.field_5811;
        }
        if (claimFaction.guest_permissions.contains((Object)Relationship.Permissions.ATTACK_ENTITIES)) {
            return class_1269.field_5811;
        }
        return class_1269.field_5814;
    }

    private static class_1269 onUseBlock(class_1657 player, class_1937 world, class_1268 hand, class_3965 hitResult) {
        class_1799 stack = player.method_5998(hand);
        class_2338 hitPos = hitResult.method_17777();
        if (InteractionManager.checkPermissions(player, hitPos, world, Relationship.Permissions.USE_BLOCKS) == class_1269.field_5814) {
            InteractionsUtil.warn(player, InteractionsUtil.InteractionsUtilActions.USE_BLOCKS);
            InteractionsUtil.sync(player, stack, hand);
            return class_1269.field_5814;
        }
        class_2338 placePos = hitPos.method_10081(hitResult.method_17780().method_62675());
        if (InteractionManager.checkPermissions(player, placePos, world, Relationship.Permissions.USE_BLOCKS) == class_1269.field_5814) {
            InteractionsUtil.warn(player, InteractionsUtil.InteractionsUtilActions.USE_BLOCKS);
            InteractionsUtil.sync(player, stack, hand);
            return class_1269.field_5814;
        }
        return class_1269.field_5811;
    }

    private static class_1269 onPlaceBlock(class_1838 context) {
        if (InteractionManager.checkPermissions(context.method_8036(), context.method_8037(), context.method_8045(), Relationship.Permissions.PLACE_BLOCKS) == class_1269.field_5814) {
            InteractionsUtil.warn(context.method_8036(), InteractionsUtil.InteractionsUtilActions.PLACE_BLOCKS);
            InteractionsUtil.sync(context.method_8036(), context.method_8041(), context.method_20287());
            return class_1269.field_5814;
        }
        return class_1269.field_5811;
    }

    private static class_1269 onUseBucket(class_1657 player, class_1937 world, class_1268 hand) {
        class_1792 item = player.method_5998(hand).method_7909();
        if (item instanceof class_1755) {
            class_1269 playerResult = InteractionManager.checkPermissions(player, player.method_24515(), world, Relationship.Permissions.PLACE_BLOCKS);
            if (playerResult == class_1269.field_5814) {
                InteractionsUtil.warn(player, InteractionsUtil.InteractionsUtilActions.PLACE_OR_PICKUP_LIQUIDS);
                InteractionsUtil.sync(player, player.method_5998(hand), hand);
                return class_1269.field_5814;
            }
            class_3611 fluid = ((BucketItemAccessor)item).getFluid();
            class_3959.class_242 handling = fluid == class_3612.field_15906 ? class_3959.class_242.field_1345 : class_3959.class_242.field_1348;
            class_3965 raycastResult = ItemInvoker.raycast(world, player, handling);
            if (raycastResult.method_17783() != class_239.class_240.field_1333) {
                class_2338 raycastPos = raycastResult.method_17777();
                if (InteractionManager.checkPermissions(player, raycastPos, world, Relationship.Permissions.PLACE_BLOCKS) == class_1269.field_5814) {
                    InteractionsUtil.warn(player, InteractionsUtil.InteractionsUtilActions.PLACE_OR_PICKUP_LIQUIDS);
                    InteractionsUtil.sync(player, player.method_5998(hand), hand);
                    return class_1269.field_5814;
                }
                class_2338 placePos = raycastPos.method_10081(raycastResult.method_17780().method_62675());
                if (InteractionManager.checkPermissions(player, placePos, world, Relationship.Permissions.PLACE_BLOCKS) == class_1269.field_5814) {
                    InteractionsUtil.warn(player, InteractionsUtil.InteractionsUtilActions.PLACE_OR_PICKUP_LIQUIDS);
                    InteractionsUtil.sync(player, player.method_5998(hand), hand);
                    return class_1269.field_5814;
                }
            }
        }
        return class_1269.field_5811;
    }

    private static class_1269 onAttackEntity(class_1657 player, class_1937 world, class_1268 hand, class_1297 entity, class_3966 hitResult) {
        if (entity != null && InteractionManager.checkPermissions(player, entity.method_24515(), world, Relationship.Permissions.ATTACK_ENTITIES) == class_1269.field_5814) {
            InteractionsUtil.warn(player, InteractionsUtil.InteractionsUtilActions.ATTACK_ENTITIES);
            return class_1269.field_5814;
        }
        return class_1269.field_5811;
    }

    private static class_1269 onUseEntity(class_1657 player, class_1297 entity, class_1937 world) {
        class_2338 pos = entity == null ? player.method_24515() : entity.method_24515();
        if (InteractionManager.checkPermissions(player, pos, world, Relationship.Permissions.USE_ENTITIES) == class_1269.field_5814) {
            InteractionsUtil.warn(player, InteractionsUtil.InteractionsUtilActions.USE_ENTITIES);
            return class_1269.field_5814;
        }
        return class_1269.field_5811;
    }

    private static class_1269 onUseInventory(class_1657 player, class_2338 pos, class_1937 world) {
        if (InteractionManager.checkPermissions(player, pos, world, Relationship.Permissions.USE_INVENTORIES) == class_1269.field_5814) {
            InteractionsUtil.warn(player, InteractionsUtil.InteractionsUtilActions.USE_INVENTORY);
            return class_1269.field_5814;
        }
        return class_1269.field_5811;
    }

    private static class_1269 isInvulnerableTo(class_1297 source, class_1297 target) {
        Faction targetFaction;
        if (!source.method_31747() || FactionsMod.CONFIG.FRIENDLY_FIRE) {
            return class_1269.field_5811;
        }
        User sourceUser = User.get(source.method_5667());
        User targetUser = User.get(target.method_5667());
        if (!sourceUser.isInFaction() || !targetUser.isInFaction()) {
            return class_1269.field_5811;
        }
        Faction sourceFaction = sourceUser.getFaction();
        if (sourceFaction.equals(targetFaction = targetUser.getFaction())) {
            return class_1269.field_5812;
        }
        if (sourceFaction.isMutualAllies(targetFaction.getID())) {
            return class_1269.field_5812;
        }
        return class_1269.field_5811;
    }

    private static class_1269 checkPermissions(class_1657 player, class_2338 position, class_1937 world, Relationship.Permissions permission) {
        if (!FactionsMod.CONFIG.CLAIM_PROTECTION) {
            return class_1269.field_5811;
        }
        User user = User.get(player.method_5667());
        if (player.method_64475(FactionsMod.CONFIG.REQUIRED_BYPASS_LEVEL) && user.bypass) {
            return class_1269.field_5811;
        }
        String dimension = world.method_27983().method_29177().toString();
        class_1923 chunkPosition = world.method_22350(position).method_12004();
        Claim claim = Claim.get(chunkPosition.field_9181, chunkPosition.field_9180, dimension);
        if (claim == null) {
            return class_1269.field_5811;
        }
        Faction claimFaction = claim.getFaction();
        if (claimFaction.getClaims().size() * FactionsMod.CONFIG.POWER.CLAIM_WEIGHT > claimFaction.getPower()) {
            return class_1269.field_5811;
        }
        if (!user.isInFaction()) {
            return claimFaction.guest_permissions.contains((Object)permission) ? class_1269.field_5812 : class_1269.field_5814;
        }
        Faction userFaction = user.getFaction();
        if (claimFaction.equals(userFaction) && (InteractionManager.getRankLevel(claim.accessLevel) <= InteractionManager.getRankLevel(user.rank) || user.rank == User.Rank.GUEST && claimFaction.guest_permissions.contains((Object)permission) && claim.accessLevel == User.Rank.MEMBER)) {
            return class_1269.field_5812;
        }
        if (FactionsMod.CONFIG.RELATIONSHIPS.ALLY_OVERRIDES_PERMISSIONS && claimFaction.isMutualAllies(userFaction.getID()) && claim.accessLevel == User.Rank.MEMBER) {
            return class_1269.field_5812;
        }
        if (claimFaction.getRelationship((UUID)userFaction.getID()).permissions.contains((Object)permission) && claim.accessLevel == User.Rank.MEMBER) {
            return class_1269.field_5812;
        }
        return class_1269.field_5814;
    }

    private static int getRankLevel(User.Rank rank) {
        switch (rank) {
            case OWNER: {
                return 3;
            }
            case LEADER: {
                return 2;
            }
            case COMMANDER: {
                return 1;
            }
            case MEMBER: {
                return 0;
            }
            case GUEST: {
                return -1;
            }
        }
        return -2;
    }
}

